/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.n5.N5ImageLoader;
import bdv.util.source.alpha.AlphaSourceDistanceL1RAI;
import bdv.util.source.alpha.AlphaSourceHelper;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.OpenersImageLoader;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ch.epfl.biop.sourceandconverter.SourceFuserAndResampler;
import ch.epfl.biop.sourceandconverter.SourceHelper;
import ch.epfl.biop.sourceandconverter.exporter.IntRangeParser;
import ij.IJ;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.cache.ref.BoundedSoftRefLoaderCache;
import net.imglib2.realtransform.AffineTransform3D;
import ome.codecs.CompressionType;
import ome.units.UNITS;
import org.apache.commons.io.FilenameUtils;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.spimdata.importer.SpimDataFromXmlImporter;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Fuse a BigStitcher dataset to OME-Tiff")
public class FuseBigStitcherDatasetIntoOMETiffCommand
implements Command {
    @Parameter(label="BigStitcher XML file", style="open")
    File xml_bigstitcher_file;
    @Parameter(label="Output folder", style="directory")
    File output_path_directory;
    @Parameter(label="Selected channels. Leave blank for all", required=false)
    String range_channels = "";
    @Parameter(label="Selected slices. Leave blank for all", required=false)
    String range_slices = "";
    @Parameter(label="Selected timepoints. Leave blank for all", required=false)
    String range_frames = "";
    @Parameter(label="Number of resolution levels (scale factor = 2)", min="1")
    int n_resolution_levels;
    @Parameter(label="Fusion method", choices={"SMOOTH AVERAGE", "MAX", "AVERAGE"})
    String fusion_method;
    @Parameter(label="Use LZW compression")
    boolean use_lzw_compression;
    @Parameter(label="Split slices")
    boolean split_slices = false;
    @Parameter(label="Split channels")
    boolean split_channels = false;
    @Parameter(label="Split frames")
    boolean split_frames = false;
    @Parameter(label="Use custom XY/Z anisotropy ratio")
    boolean override_z_ratio = false;
    @Parameter(label="XY/Z anisotropy ratio")
    double z_ratio = 1.0;
    @Parameter(label="Interpolate when fusing (~4x slower)")
    boolean use_interpolation = false;
    double vox_size_x_micrometer = 1.0;
    double vox_size_y_micrometer = 1.0;
    double vox_size_z_micrometer = 1.0;
    @Parameter
    SourceAndConverterService sac_service;
    @Parameter
    TaskService taskService;
    File output_path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List allSources;
        block23: {
            if (this.n_resolution_levels < 1) {
                System.err.println("Invalid number of resolution, minimum = 1");
            }
            this.output_path_directory.mkdirs();
            this.output_path = new File(this.output_path_directory, FilenameUtils.removeExtension((String)this.xml_bigstitcher_file.getName()) + ".ome.tiff");
            AbstractSpimData asd = new SpimDataFromXmlImporter(this.xml_bigstitcher_file).get();
            BasicImgLoader imageLoader = asd.getSequenceDescription().getImgLoader();
            int nThreads = Runtime.getRuntime().availableProcessors() - 1;
            int maxNumberOfCells = nThreads * 200;
            BoundedSoftRefLoaderCache loaderCache = new BoundedSoftRefLoaderCache(maxNumberOfCells);
            VolatileGlobalCellCache cache = new VolatileGlobalCellCache(nThreads, 5);
            try {
                Field cacheField;
                Field backingCacheField = VolatileGlobalCellCache.class.getDeclaredField("backingCache");
                backingCacheField.setAccessible(true);
                backingCacheField.set(cache, loaderCache);
                if (imageLoader instanceof Hdf5ImageLoader) {
                    cacheField = Hdf5ImageLoader.class.getDeclaredField("cache");
                    cacheField.setAccessible(true);
                    cacheField.set(imageLoader, cache);
                } else if (imageLoader instanceof N5ImageLoader) {
                    cacheField = N5ImageLoader.class.getDeclaredField("cache");
                    cacheField.setAccessible(true);
                    cacheField.set(imageLoader, cache);
                } else if (!(imageLoader instanceof OpenersImageLoader)) {
                    IJ.log((String)("Can't override cache with image loader type: " + imageLoader.getClass().getName()));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            allSources = this.sac_service.getSourceAndConverterFromSpimdata(asd);
            AffineTransform3D transform = new AffineTransform3D();
            ((SourceAndConverter)allSources.get(0)).getSpimSource().getSourceTransform(0, 0, transform);
            IJ.log((String)("Transform of first source = " + transform));
            double voxSX = Math.max(Math.max(Math.abs(transform.get(0, 0)), Math.abs(transform.get(0, 1))), Math.abs(transform.get(0, 2)));
            double voxSY = Math.max(Math.max(Math.abs(transform.get(1, 0)), Math.abs(transform.get(1, 1))), Math.abs(transform.get(1, 2)));
            double voxSZ = Math.max(Math.max(Math.abs(transform.get(2, 0)), Math.abs(transform.get(2, 1))), Math.abs(transform.get(2, 2)));
            IJ.log((String)("Pixel size X (in pixel, so it should be one) = " + voxSX));
            IJ.log((String)("Pixel size Y (in pixel, so it should be one) = " + voxSY));
            if (voxSX != 1.0) {
                IJ.log((String)"Not ONE! ");
            }
            IJ.log((String)("Pixel size Z (in pixel, equals to the anisotropy ratio) = " + voxSZ));
            if (!this.override_z_ratio) {
                this.z_ratio = voxSZ;
            }
            if (voxSX != voxSY) {
                IJ.log((String)"You probably performed a rotation, XY will be resampled with an equal pixel size");
            }
            IJ.log((String)("Anisotropy ratio used = " + this.z_ratio));
            VoxelDimensions voxelDimensions = ((BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(0)).getVoxelSize();
            String unit = voxelDimensions.unit();
            IJ.log((String)("Units is assumed to be micrometers, and it is " + unit));
            this.vox_size_x_micrometer = voxelDimensions.dimension(0);
            this.vox_size_y_micrometer = voxelDimensions.dimension(1);
            this.vox_size_z_micrometer = voxelDimensions.dimension(2);
            SourceAndConverter<?> model = SourceHelper.getModelFusedMultiSources(allSources.toArray(new SourceAndConverter[0]), 0, SourceAndConverterHelper.getMaxTimepoint((SourceAndConverter[])allSources.toArray(new SourceAndConverter[0])), 1.0, 1.0, this.z_ratio, 1, 1, 1, 1, "Model");
            if (this.fusion_method.equals("SMOOTH AVERAGE")) {
                for (SourceAndConverter source2 : allSources) {
                    AlphaSourceDistanceL1RAI alpha = new AlphaSourceDistanceL1RAI(source2.getSpimSource(), (float)this.vox_size_x_micrometer, (float)this.vox_size_y_micrometer, (float)this.vox_size_z_micrometer);
                    AlphaSourceHelper.setAlphaSource(source2, alpha);
                }
            }
            HashMap channelToSources = new HashMap();
            allSources.forEach(source -> {
                SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)this.sac_service.getMetadata(source, "SPIMDATA");
                int channelId = ((Channel)((BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(sdi.setupId)).getAttribute(Channel.class)).getId();
                if (!channelToSources.containsKey(channelId)) {
                    channelToSources.put(channelId, new ArrayList());
                }
                ((List)channelToSources.get(channelId)).add(source);
            });
            int[] channels = channelToSources.keySet().stream().sorted().mapToInt(Integer::intValue).toArray();
            SourceAndConverter[] fusedSources = new SourceAndConverter[channels.length];
            for (int iChannel = 0; iChannel < channels.length; ++iChannel) {
                fusedSources[iChannel] = new SourceFuserAndResampler((List)channelToSources.get(channels[iChannel]), this.fusion_method.contains("AVERAGE") ? "AVERAGE" : "MAX", model, this.xml_bigstitcher_file.getName() + "_Channel" + iChannel, false, true, this.use_interpolation, 0, 128, 128, 1, nThreads * 10, nThreads).get();
            }
            try {
                if (!(this.split_channels || this.split_slices || this.split_frames)) {
                    OMETiffExporter.OMETiffExporterBuilder.WriterOptions.WriterOptionsBuilder exporter = OMETiffExporter.builder().put(fusedSources).defineMetaData(this.xml_bigstitcher_file.getName()).putMetadataFromSources(fusedSources, UNITS.MICROMETER).voxelPhysicalSizeMicrometer(this.vox_size_x_micrometer, this.vox_size_y_micrometer, this.vox_size_z_micrometer).defineWriteOptions().nThreads(nThreads).maxTilesInQueue(nThreads * 3).rangeC(this.range_channels).rangeZ(this.range_slices).rangeT(this.range_frames).monitor(this.taskService).downsample(2).tileSize(1024, 1024).nResolutionLevels(this.n_resolution_levels).savePath(this.output_path.getAbsolutePath());
                    if (this.use_lzw_compression) {
                        exporter.lzw();
                    } else {
                        exporter.compression(CompressionType.UNCOMPRESSED.getCompression());
                    }
                    exporter.create().export();
                    break block23;
                }
                int nC = fusedSources.length;
                int nZ = (int)fusedSources[0].getSpimSource().getSource(0, 0).realMax(2);
                int nT = SourceAndConverterHelper.getMaxTimepoint((SourceAndConverter[])fusedSources);
                CZTSetIterator iterator = new CZTSetIterator(this.range_channels, this.range_slices, this.range_frames, this.split_channels, this.split_slices, this.split_frames, nC, nZ, nT);
                ArrayList<CZTSet> sets = new ArrayList<CZTSet>();
                CZTSetIterator it = iterator;
                while (it.hasNext()) {
                    CZTSet set2 = it.next();
                    sets.add(set2);
                }
                int nThreadPerTask = sets.size() > nThreads ? 1 : Math.min(nThreads / sets.size(), 1);
                AtomicInteger counter = new AtomicInteger();
                int nExportedFiles = sets.size();
                Task export = this.taskService.createTask("Fuse and export " + this.xml_bigstitcher_file.getName());
                export.setProgressMaximum((long)nExportedFiles);
                try {
                    sets.parallelStream().forEach(set -> {
                        try {
                            this.export(set.channels_set, set.slices_set, set.frames_set, nThreadPerTask, fusedSources);
                            Task task = export;
                            synchronized (task) {
                                export.setProgressValue((long)counter.incrementAndGet());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                finally {
                    export.run(() -> {});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sac_service.remove(allSources.toArray(new SourceAndConverter[0]));
    }

    private String getPath(String select_channels, String select_slices, String select_frames) {
        String path = this.output_path.getAbsolutePath();
        path = path.endsWith(".ome.tiff") ? path.substring(0, path.length() - 9) : (path.endsWith(".ome.tif") ? path.substring(0, path.length() - 8) : FilenameUtils.removeExtension((String)path));
        if (this.split_channels) {
            path = path + "_C" + select_channels;
        }
        if (this.split_slices) {
            path = path + "_Z" + select_slices;
        }
        if (this.split_frames) {
            path = path + "_T" + select_frames;
        }
        path = path + ".ome.tiff";
        return path;
    }

    private void export(String select_channels, String select_slices, String select_frames, int nThreads, SourceAndConverter[] fusedSources) throws Exception {
        OMETiffExporter.OMETiffExporterBuilder.WriterOptions.WriterOptionsBuilder exporter = OMETiffExporter.builder().put(fusedSources).defineMetaData(this.xml_bigstitcher_file.getName()).putMetadataFromSources(fusedSources, UNITS.MICROMETER).voxelPhysicalSizeMicrometer(this.vox_size_x_micrometer, this.vox_size_y_micrometer, this.vox_size_z_micrometer).defineWriteOptions().nThreads(nThreads).maxTilesInQueue(nThreads * 3).rangeC(select_channels).rangeZ(select_slices).rangeT(select_frames).monitor(this.taskService).downsample(2).tileSize(1024, 1024).nResolutionLevels(this.n_resolution_levels).savePath(this.getPath(select_channels, select_slices, select_frames));
        if (this.use_lzw_compression) {
            exporter.lzw();
        }
        exporter.create().export();
    }

    static class CZTSetIterator
    implements Iterator<CZTSet> {
        CZTSet iniSet;
        List<Integer> lC = new ArrayList<Integer>();
        List<Integer> lZ = new ArrayList<Integer>();
        List<Integer> lT = new ArrayList<Integer>();
        int iC = 0;
        int iZ = -1;
        int iT = 0;
        int nC;
        int nZ;
        int nT;
        final boolean splitC;
        final boolean splitZ;
        final boolean splitT;

        CZTSetIterator(String range_channels, String range_slices, String range_frames, boolean splitC, boolean splitZ, boolean splitT, int nC, int nZ, int nT) throws Exception {
            this.iniSet = new CZTSet();
            this.splitC = splitC;
            this.splitZ = splitZ;
            this.splitT = splitT;
            this.iniSet.channels_set = range_channels;
            this.iniSet.slices_set = range_slices;
            this.iniSet.frames_set = range_frames;
            if (splitC) {
                this.lC = new IntRangeParser(range_channels).get(nC);
                this.nC = this.lC.size();
            } else {
                this.nC = 1;
            }
            if (splitZ) {
                this.lZ = new IntRangeParser(range_slices).get(nZ);
                this.nZ = this.lZ.size();
            } else {
                this.nZ = 1;
            }
            if (splitT) {
                this.lT = new IntRangeParser(range_frames).get(nT);
                this.nT = this.lT.size();
            } else {
                this.nT = 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iC != this.nC - 1 || this.iZ != this.nZ - 1 || this.iT != this.nT - 1;
        }

        @Override
        public CZTSet next() {
            CZTSet next = new CZTSet(this.iniSet);
            ++this.iZ;
            if (this.iZ == this.nZ) {
                this.iZ = 0;
                ++this.iC;
                if (this.iC == this.nC) {
                    this.iC = 0;
                    ++this.iT;
                    if (this.iT == this.nT) {
                        return null;
                    }
                }
            }
            if (this.splitC) {
                next.channels_set = this.lC.get(this.iC).toString();
            }
            if (this.splitZ) {
                next.slices_set = this.lZ.get(this.iZ).toString();
            }
            if (this.splitT) {
                next.frames_set = this.lT.get(this.iT).toString();
            }
            return next;
        }
    }

    static class CZTSet {
        String channels_set = "";
        String slices_set = "";
        String frames_set = "";

        public CZTSet() {
        }

        public CZTSet(CZTSet ini) {
            this.channels_set = ini.channels_set;
            this.slices_set = ini.slices_set;
            this.frames_set = ini.frames_set;
        }

        public String toString() {
            return "C:\t" + this.channels_set + "\tZ:\t" + this.slices_set + "\tT\t:" + this.frames_set;
        }
    }
}

