/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsToSpimData;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.FileIndex;
import ij.IJ;
import java.io.File;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import spimdata.SpimDataHelper;
import spimdata.util.Displaysettings;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Open [Single file]")
public class FileToBigStitcherDatasetCommand
implements Command {
    @Parameter(label="Bioformats compatible file", style="open")
    File file;
    @Parameter(label="Xml Bdv Dataset output", style="save")
    File xmlout;

    public void run() {
        if (this.xmlout.exists()) {
            IJ.error((String)"The output file already exist! Skipping execution");
            return;
        }
        try {
            BioFormatsBdvOpener opener = BioFormatsToSpimData.getDefaultOpener((String)this.file.getAbsolutePath()).micrometer();
            IFormatReader reader = opener.getNewReader();
            Length[] voxSizes = BioFormatsTools.getSeriesVoxelSizeAsLengths((IMetadata)((IMetadata)reader.getMetadataStore()), (int)0);
            double pixSizeXYMicrometer = voxSizes[0].value(UNITS.MICROMETER).doubleValue();
            double scalingForBigStitcher = 1.0 / pixSizeXYMicrometer;
            reader.close();
            AbstractSpimData asd = BioFormatsToSpimData.getSpimData((BioFormatsBdvOpener)opener.voxSizeReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)).positionReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)));
            SpimDataHelper.removeEntities((AbstractSpimData)asd, (Class[])new Class[]{Displaysettings.class, FileIndex.class});
            SpimDataHelper.scale((AbstractSpimData)asd, (String)"BigStitcher Scaling", (double)scalingForBigStitcher);
            asd.setBasePath(new File(this.xmlout.getAbsolutePath()).getParentFile());
            new XmlIoSpimData().save((AbstractSpimData)((SpimData)asd), this.xmlout.getAbsolutePath());
            IJ.log((String)("- Done! Dataset created - " + this.xmlout.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

