/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import ch.epfl.biop.bdv.img.bioformats.entity.SeriesIndex;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.FileIndex;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.SeriesNumber;
import ij.IJ;
import java.io.File;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.VoxelDimensions;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import spimdata.SpimDataHelper;
import spimdata.util.Displaysettings;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Edit>Make BDVDataset BigStitcher Compatible")
public class DatasetToBigStitcherDatasetCommand
implements Command {
    @Parameter(label="Xml Bdv Dataset input", style="open")
    File xmlin;
    @Parameter(label="View setup reference for rescaling, -1 to list all voxel dimensions and pick the first", persist=false)
    int viewsetupreference = -1;
    @Parameter(label="Xml Bdv Dataset output", style="save")
    File xmlout;

    public void run() {
        if (this.xmlout.exists()) {
            IJ.error((String)"The output file already exist! Skipping execution");
            return;
        }
        try {
            AbstractSpimData asd = new XmlIoSpimData().load(this.xmlin.getAbsolutePath());
            BasicImgLoader imageLoader = asd.getSequenceDescription().getImgLoader();
            double scalingForBigStitcher = 1.0;
            int nSetups = asd.getSequenceDescription().getViewSetupsOrdered().size();
            if (this.viewsetupreference == -1) {
                for (int i = 0; i < nSetups; ++i) {
                    MultiResolutionSetupImgLoader setupLoader = (MultiResolutionSetupImgLoader)imageLoader.getSetupImgLoader(i);
                    VoxelDimensions voxelDimensions = setupLoader.getVoxelSize(0);
                    voxelDimensions.dimension(0);
                    IJ.log((String)("VS[" + i + "] = " + voxelDimensions));
                }
                this.viewsetupreference = 0;
            }
            MultiResolutionSetupImgLoader setupLoader = (MultiResolutionSetupImgLoader)imageLoader.getSetupImgLoader(this.viewsetupreference);
            scalingForBigStitcher = 1.0 / setupLoader.getVoxelSize(0).dimension(0);
            SpimDataHelper.removeEntities((AbstractSpimData)asd, (Class[])new Class[]{Displaysettings.class, FileIndex.class, SeriesIndex.class, SeriesNumber.class, ImageName.class});
            SpimDataHelper.scale((AbstractSpimData)asd, (String)"BigStitcher Scaling", (double)scalingForBigStitcher);
            asd.setBasePath(new File(this.xmlout.getAbsolutePath()).getParentFile());
            new XmlIoSpimData().save((AbstractSpimData)((SpimData)asd), this.xmlout.getAbsolutePath());
            IJ.log((String)("- Done! Dataset created - " + this.xmlout.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

