/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import ij.IJ;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import spimdata.SpimDataHelper;
import spimdata.util.Displaysettings;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Edit>Make CZI Dataset for BigStitcher")
public class CreateCZIDatasetCommand
implements Command {
    @Parameter(style="open")
    File czi_file;
    @Parameter
    Context ctx;
    @Parameter
    Boolean erase_if_file_already_exists = false;
    @Parameter(type=ItemIO.BOTH, label="Output file (xml)", style="save")
    File xml_out = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.xml_out.exists()) {
            if (!this.xml_out.isFile()) {
                IJ.error((String)"Command aborted: the output path is a folder, it won't be deleted.");
                return;
            }
            if (!this.erase_if_file_already_exists.booleanValue()) {
                IJ.error((String)"Command aborted: the output file already exists!");
                return;
            }
            boolean isDeleted = this.xml_out.delete();
            if (!isDeleted) {
                IJ.error((String)"ommand aborted: the output file could not be deleted.");
                return;
            }
        }
        String bfOptions = "--bfOptions zeissczi.autostitch=false";
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        int nSeries = BioFormatsHelper.getNSeries((File)this.czi_file, (String)bfOptions);
        for (int i = 0; i < nSeries; ++i) {
            openerSettings.add(OpenerSettings.BioFormats().location(this.czi_file).setSerie(i).micrometer().splitRGBChannels(true).cornerPositionConvention().addOptions(bfOptions).context(this.ctx));
        }
        AbstractSpimData asd = OpenersToSpimData.getSpimData(openerSettings);
        SpimDataHelper.removeEntities((AbstractSpimData)asd, (Class[])new Class[]{Displaysettings.class, ImageName.class});
        double pixSizeXYMicrometer = asd.getViewRegistrations().getViewRegistration(0, 0).getModel().get(0, 0);
        double scalingForBigStitcher = 1.0 / pixSizeXYMicrometer;
        SpimDataHelper.scale((AbstractSpimData)asd, (String)"BigStitcher Scaling", (double)scalingForBigStitcher);
        asd.setBasePath(new File(this.xml_out.getAbsolutePath()).getParentFile());
        try {
            new XmlIoSpimData().save((AbstractSpimData)((SpimData)asd), this.xml_out.getAbsolutePath());
            return;
        }
        catch (SpimDataException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

