/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.util.BigWarpHelper;
import bdv.util.RealTransformHelper;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarp;
import ch.epfl.biop.bdv.gui.card.CardHelper;
import ch.epfl.biop.bdv.gui.graphicalhandle.XYRectangleGraphicalHandle;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.GetUserPointsCommand;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.GetUserRectangleCommand;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.PointsSelectorBehaviour;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.PointsSelectorOverlay;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import ch.epfl.biop.scijava.command.source.register.RegisterWholeSlideScans2DCommand;
import ij.IJ;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinPlateSplineTransformAdapter;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.ManualRegistrationStarter;
import sc.fiji.bdvpg.bdv.ManualRegistrationStopper;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.bdv.supplier.BdvSupplierHelper;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.biop.BiopSerializableBdvOptions;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAutoAdjuster;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Wizard Align Slides (2D)", headless=false)
public class Wizard2DWholeScanRegisterCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(Wizard2DWholeScanRegisterCommand.class);
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "<html><h2>Automated WSI registration wizard</h2><br/>Automated registrations requires elastix.<br/></html>";
    @Parameter
    CommandService cs;
    @Parameter(label="Fixed reference source")
    SourceAndConverter<?> fixed;
    @Parameter(label="Background offset value for moving image")
    double background_offset_value_moving = 0.0;
    @Parameter(label="Background offset value for fixed image")
    double background_offset_value_fixed = 0.0;
    @Parameter(label="Moving source used for registration to the reference")
    SourceAndConverter<?> moving;
    @Parameter(label="Sources to transform, including the moving source if needed")
    SourceAndConverter<?>[] sources_to_transform;
    BdvHandle bdvh;
    @Parameter(label="Remove images z-offsets")
    boolean remove_z_offset = true;
    @Parameter(label="0 - Center moving image with fixed image")
    boolean center_moving_image = true;
    @Parameter(label="1 - Manual rigid registration")
    boolean manual_rigid_registration = true;
    @Parameter(label="2 - Auto affine registration")
    boolean automated_affine_registration = true;
    @Parameter(label="3 - Semi auto spline registration")
    boolean automated_spline_registration = true;
    @Parameter(label="4 - Manual spline registration (BigWarp)")
    boolean manual_spline_registration = true;
    @Parameter(label="Pixel size for coarse registration in microns (default 10)", style="format:0.00", persist=false)
    double coarse_pixel_size_um = 10.0;
    double coarsePixelSize_mm;
    @Parameter(label="Patch size for registration in microns (default 500)", style="format:0.0", persist=false)
    double patch_size_um = 500.0;
    double patchSize_mm;
    @Parameter(label="Pixel size for precise patch registration in microns (default 1)", style="format:0.00", persist=false)
    double precise_pixel_size_um = 1.0;
    double precisePixelSize_mm;
    @Parameter(label="Number of iterations for each scale (default 100)")
    int max_iteration_number_per_scale = 100;
    @Parameter(label="Show results of automated registrations (breaks parallelization)")
    boolean show_details = false;
    @Parameter
    boolean verbose;
    @Parameter
    SourceAndConverterBdvDisplayService sacbds;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?>[] transformed_sources;
    @Parameter(type=ItemIO.OUTPUT)
    RealTransform transformation;
    List<RealPoint> corners;
    double topLeftX;
    double topLeftY;
    double bottomRightX;
    double bottomRightY;
    double cx;
    double cy;
    List<RealPoint> landmarks = new ArrayList<RealPoint>();
    private boolean manualRegistrationStopped = false;
    AffineTransform3D centeringTransform = new AffineTransform3D();
    AffineTransform3D manualTransform = new AffineTransform3D();
    boolean isBigWarpFinished = false;
    CardHelper.CardState iniCardState;
    boolean rigidRegistrationStarted = false;
    ManualRegistrationStarter manualRegistrationStarter;
    ManualRegistrationStopper manualRegistrationStopper;
    AffineTransform3D iniView;
    final JLabel labelLogger = new JLabel();

    public void setUserMessage(String message) {
        this.labelLogger.setText(message);
        BdvHandleHelper.setWindowTitle((BdvHandle)this.bdvh, (String)("Warpy Registration Wizard - " + message));
    }

    public void run() {
        this.coarsePixelSize_mm = this.coarse_pixel_size_um / 1000.0;
        this.patchSize_mm = this.patch_size_um / 1000.0;
        this.precisePixelSize_mm = this.precise_pixel_size_um / 1000.0;
        this.bdvh = new WizardBdvSupplier().get();
        SourceAndConverterServices.getBdvDisplayService().registerBdvHandle(this.bdvh);
        if (!(this.manual_rigid_registration || this.automated_affine_registration || this.automated_spline_registration || this.manual_spline_registration)) {
            IJ.error((String)"You need to select at least one sort of registration!");
            return;
        }
        AffineTransform3D preTransformFixed = new AffineTransform3D();
        if (this.remove_z_offset) {
            AffineTransform3D at3D = new AffineTransform3D();
            this.moving.getSpimSource().getSourceTransform(0, 0, at3D);
            this.centeringTransform.translate(new double[]{0.0, 0.0, -at3D.get(2, 3)});
            this.fixed.getSpimSource().getSourceTransform(0, 0, at3D);
            preTransformFixed.translate(new double[]{0.0, 0.0, -at3D.get(2, 3)});
        }
        if (this.center_moving_image) {
            RealPoint centerMoving = SourceAndConverterHelper.getSourceAndConverterCenterPoint(this.moving, (int)0);
            RealPoint centerFixed = SourceAndConverterHelper.getSourceAndConverterCenterPoint(this.fixed, (int)0);
            this.centeringTransform.translate(new double[]{centerFixed.getDoublePosition(0) - centerMoving.getDoublePosition(0), centerFixed.getDoublePosition(1) - centerMoving.getDoublePosition(1), 0.0});
        }
        SourceAndConverter newFixed = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)preTransformFixed, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(this.fixed, 0));
        SourceAndConverter newMoving = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)this.centeringTransform, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(this.moving, 0));
        SourceAndConverterServices.getBdvDisplayService().remove(this.bdvh, new SourceAndConverter[]{this.fixed, this.moving});
        this.moving = newMoving;
        this.fixed = newFixed;
        SourceAndConverterServices.getBdvDisplayService().show(this.bdvh, new SourceAndConverter[]{this.fixed, this.moving});
        this.showImages();
        this.iniView = this.bdvh.getViewerPanel().state().getViewerTransform();
        this.addCardPanelCommons();
        if (this.manual_rigid_registration) {
            this.setUserMessage(" 0 - Manual Rigid Registration ");
            this.addManualRigidRegistration();
            while (!this.manualRegistrationStopped) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.removeCardPanelRigidRegistration();
        }
        try {
            if (this.automated_affine_registration) {
                this.setUserMessage(" 1 - Automated Affine Registration ");
                this.bdvh.getViewerPanel().state().setViewerTransform(this.iniView);
                this.getUserRectangle();
            } else {
                RealInterval box = this.getBoundingBox();
                this.corners = new ArrayList<RealPoint>();
                this.corners.add(box.minAsRealPoint());
                this.corners.add(box.maxAsRealPoint());
            }
            this.topLeftX = Math.min(this.corners.get(0).getDoublePosition(0), this.corners.get(1).getDoublePosition(0));
            this.topLeftY = Math.min(this.corners.get(0).getDoublePosition(1), this.corners.get(1).getDoublePosition(1));
            this.bottomRightX = Math.max(this.corners.get(0).getDoublePosition(0), this.corners.get(1).getDoublePosition(0));
            this.bottomRightY = Math.max(this.corners.get(0).getDoublePosition(1), this.corners.get(1).getDoublePosition(1));
            this.cx = (this.topLeftX + this.bottomRightX) / 2.0;
            this.cy = (this.topLeftY + this.bottomRightY) / 2.0;
            if (this.automated_spline_registration) {
                this.setUserMessage(" 2 - Automated Spline Registration ");
                this.getUserLandmarks();
                if (this.landmarks.size() < 4) {
                    logger.error("At least 4 points should be selected");
                    return;
                }
            } else {
                for (RealPoint realPoint : this.corners) {
                    this.landmarks.add(new RealPoint((RealLocalizable)realPoint));
                }
            }
            String ptCoords = "";
            if (this.automated_spline_registration) {
                for (RealPoint pt : this.landmarks) {
                    ptCoords = ptCoords + pt.getDoublePosition(0) + "," + pt.getDoublePosition(1) + ",";
                }
            }
            SourceAndConverterServices.getBdvDisplayService().closeBdv(this.bdvh);
            this.bdvh.close();
            IJ.log((String)"Registration started...");
            this.transformation = (RealTransform)((CommandModule)this.cs.run(RegisterWholeSlideScans2DCommand.class, true, new Object[]{"global_ref_source", this.fixed, "current_ref_source", this.moving, "pt_list_coordinates", ptCoords, "top_left_x", this.topLeftX, "top_left_y", this.topLeftY, "bottom_right_x", this.bottomRightX, "bottom_right_y", this.bottomRightY, "show_details", this.show_details, "verbose", this.verbose, "perform_first_coarse_affine_registration", this.automated_affine_registration, "perform_second_spline_registration", this.automated_spline_registration, "max_iteration_per_scale", this.max_iteration_number_per_scale, "background_offset_value_moving", this.background_offset_value_moving, "background_offset_value_fixed", this.background_offset_value_fixed, "precise_pixel_size_mm", this.precisePixelSize_mm, "patch_size_mm", this.patchSize_mm, "coarse_pixel_size_mm", this.coarsePixelSize_mm}).get()).getOutput("tst");
            if (this.manual_spline_registration) {
                IJ.log((String)"BigWarp registration...");
                List list = Arrays.stream(new SourceAndConverter[]{this.moving}).collect(Collectors.toList());
                List fixedSacs = Arrays.stream(new SourceAndConverter[]{this.fixed}).collect(Collectors.toList());
                List converterSetups = Arrays.stream(new SourceAndConverter[]{this.moving}).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList());
                converterSetups.addAll(Arrays.stream(new SourceAndConverter[]{this.fixed}).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList()));
                BigWarpLauncher bwl = new BigWarpLauncher(list, fixedSacs, "Big Warp", converterSetups);
                bwl.set2d();
                bwl.run();
                BdvHandle bdvhQ = bwl.getBdvHandleQ();
                BdvHandle bdvhP = bwl.getBdvHandleP();
                BdvHandleHelper.setWindowTitle((BdvHandle)bdvhP, (String)"Warpy Registration - 3 - BigWarp Registration");
                BdvHandleHelper.setWindowTitle((BdvHandle)bdvhQ, (String)"Warpy Registration - 3 - BigWarp Registration");
                SourceAndConverterServices.getBdvDisplayService().pairClosing(bdvhQ, bdvhP);
                bdvhP.getViewerPanel().requestRepaint();
                bdvhQ.getViewerPanel().requestRepaint();
                bwl.getBigWarp().getLandmarkFrame().repaint();
                bwl.getBigWarp().loadLandmarks(RealTransformHelper.BigWarpFileFromRealTransform(this.transformation));
                bwl.getBigWarp().setIsMovingDisplayTransformed(true);
                double sizeX = Math.abs((this.topLeftX - this.bottomRightX) * 1.25);
                AffineTransform3D at3D = new AffineTransform3D();
                bdvhP.getViewerPanel().state().getViewerTransform(at3D);
                if (sizeX != 0.0) {
                    at3D.scale((double)bdvhP.getViewerPanel().getWidth() / (sizeX * at3D.get(0, 0)));
                    bdvhP.getViewerPanel().state().setViewerTransform(at3D);
                    bdvhQ.getViewerPanel().state().setViewerTransform(at3D);
                }
                this.fitBdvOnUserROI(bdvhQ);
                this.fitBdvOnUserROI(bdvhP);
                this.waitForBigWarp(bwl.getBigWarp());
                this.transformation = bwl.getBigWarp().getBwTransform().getTransformation().copy();
                bwl.getBigWarp().closeAll();
            }
            this.preTransformLandmarks();
            IJ.log((String)"Registration DONE.");
            this.transformed_sources = (SourceAndConverter[])Arrays.stream(this.sources_to_transform).map(source -> new SourceRealTransformer(this.transformation).apply(source)).toArray(SourceAndConverter[]::new);
            SourceAndConverterServices.getSourceAndConverterService().remove(new SourceAndConverter[]{this.moving, this.fixed});
            this.manualRegistrationStarter = null;
            this.manualRegistrationStopper = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void preTransformLandmarks() {
        ThinplateSplineTransform tst = (ThinplateSplineTransform)((WrappedIterativeInvertibleRealTransform)((InvertibleWrapped2DTransformAs3D)this.transformation).getTransform()).getTransform();
        ThinPlateR2LogRSplineKernelTransform kernel = ThinPlateSplineTransformAdapter.getKernel((ThinplateSplineTransform)tst);
        double[][] pts_src = ThinPlateSplineTransformAdapter.getSrcPts((ThinPlateR2LogRSplineKernelTransform)kernel);
        double[][] pts_tgt = ThinPlateSplineTransformAdapter.getTgtPts((ThinPlateR2LogRSplineKernelTransform)kernel);
        ArrayList<RealPoint> movingPts = new ArrayList<RealPoint>();
        ArrayList<RealPoint> fixedPts = new ArrayList<RealPoint>();
        for (int i = 0; i < kernel.getNumLandmarks(); ++i) {
            RealPoint moving = new RealPoint(3);
            RealPoint fixed = new RealPoint(3);
            for (int d = 0; d < kernel.getNumDims(); ++d) {
                moving.setPosition(pts_tgt[d][i], d);
                fixed.setPosition(pts_src[d][i], d);
            }
            this.manualTransform.inverse().apply((RealLocalizable)moving, (RealPositionable)moving);
            this.centeringTransform.inverse().apply((RealLocalizable)moving, (RealPositionable)moving);
            movingPts.add(moving);
            fixedPts.add(fixed);
        }
        this.transformation = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(movingPts, fixedPts, (boolean)true)));
    }

    private void waitForBigWarp(BigWarp bw) throws InterruptedException {
        SwingUtilities.invokeLater(() -> {
            bw.getViewerFrameP().addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Wizard2DWholeScanRegisterCommand.this.isBigWarpFinished = true;
                }
            });
            bw.getViewerFrameQ().addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Wizard2DWholeScanRegisterCommand.this.isBigWarpFinished = true;
                }
            });
            JButton confirmP = new JButton("Click to finish");
            confirmP.addActionListener(e -> {
                this.isBigWarpFinished = true;
            });
            JPanel cardpanelP = RectangleSelectorBehaviour.box(false, new JLabel("BigWarp registration"), confirmP);
            bw.getViewerFrameP().getSplitPanel().setCollapsed(false);
            bw.getViewerFrameP().getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
            bw.getViewerFrameP().getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
            SwingUtilities.invokeLater(() -> bw.getViewerFrameP().getCardPanel().addCard("BigWarp Registration", (JComponent)cardpanelP, true));
            JButton confirmQ = new JButton("Click to finish");
            confirmQ.addActionListener(e -> {
                this.isBigWarpFinished = true;
            });
            JPanel cardpanelQ = RectangleSelectorBehaviour.box(false, new JLabel("BigWarp registration"), confirmQ);
            bw.getViewerFrameQ().getSplitPanel().setCollapsed(false);
            bw.getViewerFrameQ().getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
            bw.getViewerFrameQ().getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
            SwingUtilities.invokeLater(() -> bw.getViewerFrameQ().getCardPanel().addCard("BigWarp Registration", (JComponent)cardpanelQ, true));
        });
        while (!this.isBigWarpFinished) {
            Thread.sleep(100L);
        }
    }

    private void addCardPanelCommons() {
        this.iniView = new AffineTransform3D();
        this.bdvh.getViewerPanel().state().getViewerTransform(this.iniView);
        JButton restoreView = new JButton("Restore initial view");
        restoreView.addActionListener(e -> this.bdvh.getViewerPanel().state().setViewerTransform(this.iniView));
        JButton toggleMoving = new JButton("Hide moving");
        toggleMoving.addActionListener(e -> {
            if (this.bdvh.getViewerPanel().state().isSourceActive(this.moving)) {
                this.bdvh.getViewerPanel().state().setSourceActive(this.moving, false);
                toggleMoving.setText("Show moving");
            } else {
                this.bdvh.getViewerPanel().state().setSourceActive(this.moving, true);
                toggleMoving.setText("Hide moving");
            }
        });
        JButton toggleFixed = new JButton("Hide fixed");
        toggleFixed.addActionListener(e -> {
            if (this.bdvh.getViewerPanel().state().isSourceActive(this.fixed)) {
                this.bdvh.getViewerPanel().state().setSourceActive(this.fixed, false);
                toggleFixed.setText("Show fixed");
            } else {
                this.bdvh.getViewerPanel().state().setSourceActive(this.fixed, true);
                toggleFixed.setText("Hide fixed");
            }
        });
        JButton autoScaleMoving = new JButton("Autoscale moving");
        autoScaleMoving.addActionListener(e -> {
            this.bdvh.getViewerPanel().showMessage("Autoscaling moving image");
            new BrightnessAutoAdjuster(this.moving, 0).run();
        });
        JButton autoScaleFixed = new JButton("Autoscale fixed");
        autoScaleFixed.addActionListener(e -> {
            this.bdvh.getViewerPanel().showMessage("Autoscaling fixed image");
            new BrightnessAutoAdjuster(this.fixed, 0).run();
        });
        JPanel panel = RectangleSelectorBehaviour.box(false, this.labelLogger, new JLabel("BDV Navigation"), new JLabel("- Left click drag > Rotate"), new JLabel("- Right click drag > Pan"), new JLabel("- UP/mouse wheel > Zoom"), new JLabel("- DOWN/mouse wheel > Unzoom"), new JLabel("- Shift+Z > Ortho"), restoreView, RectangleSelectorBehaviour.box(true, toggleMoving, toggleFixed), RectangleSelectorBehaviour.box(true, autoScaleFixed, autoScaleMoving));
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"WSI Registration Wizard", (JComponent)panel, (boolean)true);
    }

    private void addManualRigidRegistration() {
        this.manualRegistrationStarter = new ManualRegistrationStarter(this.bdvh, new SourceAndConverter[]{this.moving});
        this.manualRegistrationStopper = new ManualRegistrationStopper(this.manualRegistrationStarter, SourceTransformHelper::mutate);
        this.iniCardState = CardHelper.getCardState(this.bdvh);
        AffineTransform3D initialView = this.bdvh.getViewerPanel().state().getViewerTransform();
        JButton restoreView = new JButton("Start manual rigid registration");
        restoreView.addActionListener(e -> {
            if (this.rigidRegistrationStarted) {
                this.bdvh.getViewerPanel().state().setViewerTransform(initialView);
                new ManualRegistrationStopper(this.manualRegistrationStarter, SourceTransformHelper::cancel).run();
                this.manualRegistrationStarter = new ManualRegistrationStarter(this.bdvh, new SourceAndConverter[]{this.moving});
                this.manualRegistrationStopper = new ManualRegistrationStopper(this.manualRegistrationStarter, SourceTransformHelper::mutate);
                this.rigidRegistrationStarted = false;
                restoreView.setText("Start manual rigid registration");
            } else {
                this.manualRegistrationStarter.run();
                this.rigidRegistrationStarted = true;
                restoreView.setText("Cancel manual registration");
            }
        });
        JButton confirmationButton = new JButton("Confirm transformation");
        confirmationButton.addActionListener(e -> {
            if (this.rigidRegistrationStarted) {
                this.manualTransform.concatenate(this.manualRegistrationStarter.getCurrentTransform().copy());
                this.manualRegistrationStopper.run();
            }
            this.manualRegistrationStopped = true;
        });
        JPanel cardpanel = RectangleSelectorBehaviour.box(false, restoreView, confirmationButton);
        this.bdvh.getSplitPanel().setCollapsed(false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", true);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"Manual rigid registration", (JComponent)cardpanel, (boolean)true);
    }

    private void removeCardPanelRigidRegistration() {
        CardHelper.restoreCardState(this.bdvh, this.iniCardState);
        this.bdvh.getCardPanel().removeCard((Object)"Manual rigid registration");
    }

    private void getUserLandmarks() throws Exception {
        JLabel addGridLabel = new JLabel("Add landmark grid");
        JLabel gridSpacingLabel = new JLabel("Spacing (um)");
        JTextField gridSpacing = new JTextField();
        gridSpacing.setEditable(true);
        gridSpacing.setText(Double.toString(this.patch_size_um));
        JButton addPoints = new JButton("Add landmark grid");
        addPoints.addActionListener(e -> {
            try {
                System.out.println("IN action listener");
                double spacing_mm = Double.parseDouble(gridSpacing.getText()) / 1000.0;
                if (spacing_mm > this.patchSize_mm / 10.0) {
                    for (double xStart = this.cx; xStart > this.topLeftX; xStart -= spacing_mm) {
                    }
                    for (double yStart = this.cy; yStart > this.topLeftY; yStart -= spacing_mm) {
                    }
                    for (double xPos = xStart + spacing_mm; xPos < this.bottomRightX; xPos += spacing_mm) {
                        for (double yPos = yStart + spacing_mm; yPos < this.bottomRightY; yPos += spacing_mm) {
                            System.out.println("Add point " + xPos + ":" + yPos);
                            ((PointsSelectorOverlay.AddGlobalPointBehaviour)this.bdvh.getTriggerbindings().getConcatenatedBehaviourMap().get("add_point_global_hack")).addGlobalPoint(xPos, yPos, 0.0);
                        }
                    }
                } else {
                    IJ.log((String)"spacing too low");
                }
            }
            catch (Exception parseException) {
                IJ.log((String)parseException.getMessage());
            }
        });
        JPanel addGridCard = RectangleSelectorBehaviour.box(false, addGridLabel, RectangleSelectorBehaviour.box(true, gridSpacingLabel, gridSpacing), addPoints);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"Place landmark grid", (JComponent)addGridCard, (boolean)true);
        this.landmarks = (List)((CommandModule)this.cs.run(GetUserPointsCommand.class, true, new Object[]{"message_for_user", "Select the position of the landmarks that will be used for the registration (at least 4).", "time_out_in_ms", -1, "graphical_handle_supplier", realPoint -> new XYRectangleGraphicalHandle(new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]), this.bdvh.getTriggerbindings(), UUID.randomUUID().toString(), this.bdvh.getViewerPanel().state(), () -> realPoint, () -> this.patchSize_mm, () -> this.patchSize_mm, () -> PointsSelectorBehaviour.defaultLandmarkColor)}).get()).getOutput("pts");
        this.bdvh.getCardPanel().removeCard((Object)"Place landmark grid");
    }

    private void getUserRectangle() throws Exception {
        RealInterval box = this.getBoundingBox();
        CommandModule module = (CommandModule)this.cs.run(GetUserRectangleCommand.class, true, new Object[]{"message_for_user", "Select a rectangular region for the region you'd like to register.", "time_out_in_ms", -1, "p1", box.minAsRealPoint(), "p2", box.maxAsRealPoint()}).get();
        this.corners = new ArrayList<RealPoint>();
        this.corners.add((RealPoint)module.getOutput("p1"));
        this.corners.add((RealPoint)module.getOutput("p2"));
    }

    RealInterval getBoundingBox() {
        SourceAndConverter[] sources = new SourceAndConverter[]{this.moving, this.fixed};
        List intervalList = Arrays.stream(sources).map(sourceAndConverter -> {
            RandomAccessibleInterval interval = sourceAndConverter.getSpimSource().getSource(0, 0);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sourceAndConverter.getSpimSource().getSourceTransform(0, 0, sourceTransform);
            RealPoint corner0 = new RealPoint(new float[]{interval.min(0), interval.min(1), interval.min(2)});
            RealPoint corner1 = new RealPoint(new float[]{interval.max(0), interval.max(1), interval.max(2)});
            sourceTransform.apply((RealLocalizable)corner0, (RealPositionable)corner0);
            sourceTransform.apply((RealLocalizable)corner1, (RealPositionable)corner1);
            return new FinalRealInterval(new double[]{Math.min(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.min(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.min(corner0.getDoublePosition(2), corner1.getDoublePosition(2))}, new double[]{Math.max(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.max(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.max(corner0.getDoublePosition(2), corner1.getDoublePosition(2))});
        }).collect(Collectors.toList());
        RealInterval maxInterval = (RealInterval)intervalList.stream().reduce((i1, i2) -> new FinalRealInterval(new double[]{Math.min(i1.realMin(0), i2.realMin(0)), Math.min(i1.realMin(1), i2.realMin(1)), Math.min(i1.realMin(2), i2.realMin(2))}, new double[]{Math.max(i1.realMax(0), i2.realMax(0)), Math.max(i1.realMax(1), i2.realMax(1)), Math.max(i1.realMax(2), i2.realMax(2))})).get();
        return maxInterval;
    }

    private void showImages() {
        this.sacbds.show(this.bdvh, new SourceAndConverter[]{this.fixed, this.moving});
        new ViewerTransformAdjuster(this.bdvh, new SourceAndConverter[]{this.fixed, this.moving}).run();
    }

    void fitBdvOnUserROI(BdvHandle bdvh) {
        AffineTransform3D newCenter = BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvh, (double[])new double[]{this.cx, this.cy, 0.0});
        bdvh.getViewerPanel().state().setViewerTransform(newCenter);
    }

    public static class WizardBdvSupplier
    implements IBdvSupplier {
        public BdvHandle get() {
            BiopSerializableBdvOptions sOptions = new BiopSerializableBdvOptions();
            sOptions.is2D = true;
            sOptions.width = 1200;
            sOptions.height = 800;
            sOptions.interpolate = false;
            sOptions.frameTitle = "Warpy Registration Wizard";
            sOptions.numTimePoints = 1;
            BdvOptions options = sOptions.getBdvOptions();
            ArrayImg dummyImg = ArrayImgs.bytes((long[])new long[]{2L, 2L, 2L});
            options = options.sourceTransform(new AffineTransform3D());
            BdvStackSource bss = BdvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BdvOptions)options);
            BdvHandle bdvh = bss.getBdvHandle();
            if (sOptions.interpolate) {
                bdvh.getViewerPanel().setInterpolation(Interpolation.NLINEAR);
            }
            bdvh.getViewerPanel().state().removeSource(bdvh.getViewerPanel().state().getCurrentSource());
            bdvh.getViewerPanel().setNumTimepoints(sOptions.numTimePoints);
            BdvSupplierHelper.addSourcesDragAndDrop((BdvHandle)bdvh);
            bdvh.getSplitPanel().setCollapsed(false);
            bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", true);
            bdvh.getCardPanel().removeCard((Object)"default bdv groups card");
            bdvh.getCardPanel().removeCard((Object)"default bdv viewer modes card");
            return bdvh;
        }
    }
}

