/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.QuPathBdvHelper;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.scijava.command.source.register.Wizard2DWholeScanRegisterCommand;
import ij.IJ;
import java.io.File;
import java.nio.charset.Charset;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>QuPath - Create Warpy Registration")
public class WarpyRegisterCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(WarpyRegisterCommand.class);
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, style="message")
    String message = "<html><h1>QuPath registration wizard</h1>Please select a moving and a fixed source<br></html>";
    @Parameter(label="Fixed source", callback="updateMessage")
    SourceAndConverter<?>[] fixed_sources;
    @Parameter(label="Moving source", callback="updateMessage")
    SourceAndConverter<?>[] moving_sources;
    @Parameter
    CommandService cs;
    @Parameter
    Context scijavaCtx;
    @Parameter
    boolean verbose = false;

    public void run() {
        try {
            RealTransformSequence transformSequence;
            String qupathProjectFixed;
            if (this.fixed_sources.length > 1) {
                logger.warn("Only the first fixed source will be used.");
            }
            if (this.moving_sources.length > 1) {
                logger.warn("Only the first movingq source will be used.");
            }
            SourceAndConverter<?> fixed_source = this.fixed_sources[0];
            SourceAndConverter<?> moving_source = this.moving_sources[0];
            if (!QuPathBdvHelper.isSourceLinkedToQuPath(fixed_source)) {
                logger.error("Error : the fixed source is not associated to a QuPath project");
                IJ.error((String)"Error : the fixed source is not associated to a QuPath project");
                return;
            }
            if (!QuPathBdvHelper.isSourceLinkedToQuPath(moving_source)) {
                logger.error("Error : the moving source is not associated to a QuPath project");
                IJ.error((String)"Error : the moving source is not associated to a QuPath project");
                return;
            }
            String qupathProjectMoving = QuPathBdvHelper.getProjectFile(moving_source).getAbsolutePath();
            if (!qupathProjectMoving.equals(qupathProjectFixed = QuPathBdvHelper.getProjectFile(fixed_source).getAbsolutePath())) {
                logger.error("Error : the moving source and the fixed source are not from the same qupath project");
                IJ.error((String)"Error : the moving source and the fixed source are not from the same qupath project");
                return;
            }
            File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(moving_source);
            File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(fixed_source);
            if (moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) {
                logger.error("Error : the moving source and the fixed source should belong to different qupath entries (you can't move two channels of the same image, unless you duplicate the images in QuPath)");
                IJ.error((String)"Error : the moving source and the fixed source should belong to different qupath entries (you can't move two channels of the same image, unless you duplicate the images in QuPath)");
                return;
            }
            CommandModule module = (CommandModule)this.cs.run(Wizard2DWholeScanRegisterCommand.class, true, new Object[]{"fixed", fixed_source, "moving", moving_source, "verbose", this.verbose, "background_offset_value_moving", 0, "background_offset_value_fixed", 0, "sources_to_transform", new SourceAndConverter[]{moving_source}}).get();
            RealTransform rt = (RealTransform)module.getOutput("transformation");
            SourceAndConverterServices.getSourceAndConverterService().remove((SourceAndConverter[])module.getOutput("transformed_sources"));
            AffineTransform3D movingToPixel = new AffineTransform3D();
            moving_source.getSpimSource().getSourceTransform(0, 0, movingToPixel);
            AffineTransform3D fixedToPixel = new AffineTransform3D();
            fixed_source.getSpimSource().getSourceTransform(0, 0, fixedToPixel);
            if (rt instanceof InvertibleRealTransform) {
                InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
                irts.add((RealTransform)fixedToPixel);
                irts.add((RealTransform)((InvertibleRealTransform)rt));
                irts.add((RealTransform)movingToPixel.inverse());
                transformSequence = irts;
            } else {
                RealTransformSequence rts = new RealTransformSequence();
                rts.add((RealTransform)fixedToPixel);
                rts.add(rt);
                rts.add((RealTransform)movingToPixel.inverse());
                transformSequence = rts;
            }
            String jsonMovingToFixed = ScijavaGsonHelper.getGson((Context)this.scijavaCtx).toJson((Object)transformSequence, RealTransform.class);
            int moving_series_entry_id = QuPathBdvHelper.getEntryId(moving_source);
            int fixed_series_entry_id = QuPathBdvHelper.getEntryId(fixed_source);
            String movingToFixedLandmarkName = "transform_" + moving_series_entry_id + "_" + fixed_series_entry_id + ".json";
            File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
            FileUtils.writeStringToFile((File)result, (String)jsonMovingToFixed, (Charset)Charset.defaultCharset());
            IJ.log((String)("Fixed: " + fixed_source.getSpimSource().getName() + " | Moving: " + moving_source.getSpimSource().getName()));
            IJ.log((String)("Transformation file successfully written to QuPath project: " + result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMessage() {
        String message = "<html><h1>QuPath registration wizard</h1>";
        if (this.fixed_sources == null) {
            this.message = message = message + "Please select a moving source<br></html>";
            return;
        }
        if (this.moving_sources == null) {
            this.message = message = message + "Please select a fixed source<br></html>";
            return;
        }
        if (this.fixed_sources.length > 1) {
            message = message + "Only the first fixed source will be used. <br>";
        }
        if (this.moving_sources.length > 1) {
            message = message + "Only the first moving source will be used. <br>";
        }
        SourceAndConverter<?> fixed_source = this.fixed_sources[0];
        SourceAndConverter<?> moving_source = this.moving_sources[0];
        if (fixed_source == null) {
            message = message + "Please select a fixed source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(fixed_source)) {
            message = message + "The fixed source is not originating from a QuPath project! <br>";
        } else if (moving_source == null) {
            message = message + "Please select a moving source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(moving_source)) {
            message = message + "The moving source is not originating from a QuPath project! <br>";
        } else {
            try {
                String qupathProjectMoving = QuPathBdvHelper.getProjectFile(moving_source).getAbsolutePath();
                String qupathProjectFixed = QuPathBdvHelper.getProjectFile(fixed_source).getAbsolutePath();
                if (!qupathProjectMoving.equals(qupathProjectFixed)) {
                    message = message + "Error : the moving source and the fixed source are not from the same qupath project";
                } else {
                    File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(moving_source);
                    File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(fixed_source);
                    if (moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) {
                        message = message + "Error : moving and fixed source should belong to different qupath entries. <br>";
                        message = message + "You can't move two channels of the same image, <br>";
                        message = message + "unless you duplicate the images in QuPath. <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + fixed_source.getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + moving_source.getSpimSource().getName() + "</li>";
                        message = message + "<ul>";
                    } else {
                        message = message + "Registration task properly set: <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + fixed_source.getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + moving_source.getSpimSource().getName() + "</li>";
                        message = message + "</ul>";
                        int moving_series_index = QuPathBdvHelper.getEntryId(moving_source);
                        int fixed_series_index = QuPathBdvHelper.getEntryId(fixed_source);
                        String movingToFixedLandmarkName = "transform_" + moving_series_index + "_" + fixed_series_index + ".json";
                        File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (result.exists()) {
                            message = message + "WARNING! A REGISTRATION FILE ALREADY EXISTS! You can:<br>";
                            message = message + "<ul><li> Click <b>OK</b> to re-run the wizard and override it</li>";
                            message = message + "<li> Run the command <b>Edit QuPath Registration</b> to edit this existing registration</li></ul>";
                        }
                        movingToFixedLandmarkName = "transform_" + fixed_series_index + "_" + moving_series_index + ".json";
                        result = new File(fixed_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (result.exists()) {
                            message = message + "WARNING! AN <b>INVERSE</b> REGISTRATION FILE ALREADY EXISTS! You can:<br>";
                            message = message + "<ul><li> Switch your fixed and moving selected source</li>";
                            message = message + "<li> Erase the transformation file and run the wizard.</li></ul>";
                            message = message + "Keeping both the forward and inverse transformation <br>";
                            message = message + "will cause some ambiguity in QuPath. <br>";
                            message = message + "Inverse transformation file:<br>";
                            message = message + result.getAbsolutePath().replace("\\", "\\\\") + "<br>";
                        }
                    }
                }
            }
            catch (Exception e) {
                message = message + "Could not fetch the QuPath project error: " + e.getMessage() + "<br>";
            }
        }
        this.message = message = message + "</html>";
    }
}

