/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.QuPathBdvHelper;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.scijava.command.source.register.MultiscaleRegisterCommand;
import ij.IJ;
import java.io.File;
import java.nio.charset.Charset;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>QuPath - Create Warpy Multiscale Registration")
public class WarpyMultiscaleRegisterCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(WarpyMultiscaleRegisterCommand.class);
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, style="message")
    String message = "<html><h1>QuPath Warpy multiscale registration</h1>Please select a list of moving and a list of fixed source<br></html>";
    @Parameter(label="Number of registration scales (# registration x2 per scale)", style="slider", min="2", max="8", callback="updateInfo")
    int n_scales = 4;
    @Parameter(visibility=ItemVisibility.MESSAGE, required=false)
    String info_registration = "";
    @Parameter(label="Fixed source", callback="updateMessage", style="sorted")
    SourceAndConverter<?>[] fixed_sources;
    @Parameter(label="Moving source", callback="updateMessage", style="sorted")
    SourceAndConverter<?>[] moving_sources;
    @Parameter(label="Remove images z-offsets")
    boolean remove_z_offset = true;
    @Parameter(label="Center moving image with fixed image")
    boolean center_moving_image = true;
    @Parameter(label="Number of pixel for each block of image used for the registration (default 128)")
    int pixels_per_block = 128;
    @Parameter(label="Number of iterations for each registration (default 100)")
    int max_iteration_number_per_scale = 100;
    @Parameter
    CommandService cs;
    @Parameter
    Context scijavaCtx;

    public void run() {
        try {
            RealTransformSequence transformSequence;
            String qupathProjectFixed;
            if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.fixed_sources[0])) {
                logger.error("Error : the fixed source is not associated to a QuPath project");
                IJ.error((String)"Error : the fixed source is not associated to a QuPath project");
                return;
            }
            if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.moving_sources[0])) {
                logger.error("Error : the moving source is not associated to a QuPath project");
                IJ.error((String)"Error : the moving source is not associated to a QuPath project");
                return;
            }
            String qupathProjectMoving = QuPathBdvHelper.getProjectFile(this.moving_sources[0]).getAbsolutePath();
            if (!qupathProjectMoving.equals(qupathProjectFixed = QuPathBdvHelper.getProjectFile(this.fixed_sources[0]).getAbsolutePath())) {
                logger.error("Error : the moving source and the fixed source are not from the same qupath project");
                IJ.error((String)"Error : the moving source and the fixed source are not from the same qupath project");
                return;
            }
            File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.moving_sources[0]);
            File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.fixed_sources[0]);
            if (moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) {
                logger.error("Error : the moving source and the fixed source should belong to different qupath entries (you can't move two channels of the same image, unless you duplicate the images in QuPath)");
                IJ.error((String)"Error : the moving source and the fixed source should belong to different qupath entries (you can't move two channels of the same image, unless you duplicate the images in QuPath)");
                return;
            }
            CommandModule module = (CommandModule)this.cs.run(MultiscaleRegisterCommand.class, true, new Object[]{"fixed", this.fixed_sources, "moving", this.moving_sources, "sources_to_transform", this.moving_sources, "n_scales", this.n_scales, "remove_z_offset", this.remove_z_offset, "center_moving_image", this.center_moving_image, "pixels_per_block", this.pixels_per_block, "max_iteration_number_per_scale", this.max_iteration_number_per_scale, "show_details", false, "debug", false}).get();
            RealTransform rt = (RealTransform)module.getOutput("transformation");
            SourceAndConverterServices.getSourceAndConverterService().remove((SourceAndConverter[])module.getOutput("transformed_sources"));
            AffineTransform3D movingToPixel = new AffineTransform3D();
            this.moving_sources[0].getSpimSource().getSourceTransform(0, 0, movingToPixel);
            AffineTransform3D fixedToPixel = new AffineTransform3D();
            this.fixed_sources[0].getSpimSource().getSourceTransform(0, 0, fixedToPixel);
            if (rt instanceof InvertibleRealTransform) {
                InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
                irts.add((RealTransform)fixedToPixel);
                irts.add((RealTransform)((InvertibleRealTransform)rt));
                irts.add((RealTransform)movingToPixel.inverse());
                transformSequence = irts;
            } else {
                RealTransformSequence rts = new RealTransformSequence();
                rts.add((RealTransform)fixedToPixel);
                rts.add(rt);
                rts.add((RealTransform)movingToPixel.inverse());
                transformSequence = rts;
            }
            String jsonMovingToFixed = ScijavaGsonHelper.getGson((Context)this.scijavaCtx).toJson((Object)transformSequence, RealTransform.class);
            int moving_series_entry_id = QuPathBdvHelper.getEntryId(this.moving_sources[0]);
            int fixed_series_entry_id = QuPathBdvHelper.getEntryId(this.fixed_sources[0]);
            String movingToFixedLandmarkName = "transform_" + moving_series_entry_id + "_" + fixed_series_entry_id + ".json";
            File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
            FileUtils.writeStringToFile((File)result, (String)jsonMovingToFixed, (Charset)Charset.defaultCharset());
            IJ.log((String)("Fixed: " + this.fixed_sources[0].getSpimSource().getName() + " | Moving: " + this.moving_sources[0].getSpimSource().getName()));
            IJ.log((String)("Transformation file successfully written to QuPath project: " + result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMessage() {
        String message = "<html><h1>QuPath Warpy multiscale registration</h1>";
        if (this.fixed_sources == null) {
            this.message = message = message + "Please select one (or several) moving sources<br></html>";
            return;
        }
        if (this.moving_sources == null) {
            this.message = message = message + "Please select one (or several) fixed sources<br></html>";
            return;
        }
        if (this.fixed_sources.length > 1) {
            message = message + "Only the first fixed source will be used. <br>";
        }
        if (this.moving_sources.length > 1) {
            message = message + "Only the first moving source will be used. <br>";
        }
        SourceAndConverter<?> fixed_source = this.fixed_sources[0];
        SourceAndConverter<?> moving_source = this.moving_sources[0];
        if (fixed_source == null) {
            message = message + "Please select a fixed source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(fixed_source)) {
            message = message + "The fixed source is not originating from a QuPath project! <br>";
        } else if (moving_source == null) {
            message = message + "Please select a moving source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(moving_source)) {
            message = message + "The moving source is not originating from a QuPath project! <br>";
        } else {
            try {
                String qupathProjectMoving = QuPathBdvHelper.getProjectFile(moving_source).getAbsolutePath();
                String qupathProjectFixed = QuPathBdvHelper.getProjectFile(fixed_source).getAbsolutePath();
                if (!qupathProjectMoving.equals(qupathProjectFixed)) {
                    message = message + "Error : the moving source and the fixed source are not from the same qupath project";
                } else {
                    File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(moving_source);
                    File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(fixed_source);
                    if (moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) {
                        message = message + "Error : moving and fixed source should belong to different qupath entries. <br>";
                        message = message + "You can't move two channels of the same image, <br>";
                        message = message + "unless you duplicate the images in QuPath. <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + fixed_source.getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + moving_source.getSpimSource().getName() + "</li>";
                        message = message + "<ul>";
                    } else {
                        message = message + "Registration task properly set: <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + fixed_source.getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + moving_source.getSpimSource().getName() + "</li>";
                        message = message + "</ul>";
                        int moving_series_index = QuPathBdvHelper.getEntryId(moving_source);
                        int fixed_series_index = QuPathBdvHelper.getEntryId(fixed_source);
                        String movingToFixedLandmarkName = "transform_" + moving_series_index + "_" + fixed_series_index + ".json";
                        File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (result.exists()) {
                            message = message + "WARNING! A REGISTRATION FILE ALREADY EXISTS! You can:<br>";
                            message = message + "<ul><li> Click <b>OK</b> to re-run the wizard and override it</li>";
                            message = message + "<li> Run the command <b>Edit QuPath Registration</b> to edit this existing registration</li></ul>";
                        }
                        movingToFixedLandmarkName = "transform_" + fixed_series_index + "_" + moving_series_index + ".json";
                        result = new File(fixed_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (result.exists()) {
                            message = message + "WARNING! AN <b>INVERSE</b> REGISTRATION FILE ALREADY EXISTS! You can:<br>";
                            message = message + "<ul><li> Switch your fixed and moving selected source</li>";
                            message = message + "<li> Erase the transformation file and run the wizard.</li></ul>";
                            message = message + "Keeping both the forward and inverse transformation <br>";
                            message = message + "will cause some ambiguity in QuPath. <br>";
                            message = message + "Inverse transformation file:<br>";
                            message = message + result.getAbsolutePath().replace("\\", "\\\\") + "<br>";
                        }
                    }
                }
            }
            catch (Exception e) {
                message = message + "Could not fetch the QuPath project error: " + e.getMessage() + "<br>";
            }
        }
        this.message = message = message + "</html>";
    }

    void updateInfo() {
        int nReg = 4 * (int)(Math.pow(2.0, this.n_scales - 1) - 1.0);
        this.info_registration = nReg + " registrations will be computed, resulting in " + (int)Math.pow(2.0, this.n_scales) + " control points";
    }
}

