/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.EmptySource;
import bdv.util.QuPathBdvHelper;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.command.KheopsExportSourcesCommand;
import ch.epfl.biop.scijava.command.source.register.WarpyEditRegistrationCommand;
import com.google.gson.stream.JsonReader;
import ij.IJ;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformHelper;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>QuPath - Export Warpy Registered Image")
public class WarpyExportRegisteredImageCommand
implements Command {
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, style="message")
    String message = "<html><h1>QuPath registration exporter</h1>Please select a moving and a fixed source<br></html>";
    @Parameter(label="Remove Z offsets")
    boolean remove_z_offsets = true;
    @Parameter(label="Pre-compute transformation before export (faster for n landmarks ~> 40)")
    boolean pre_compute_transform;
    @Parameter(label="Transformation pre-computation downsampling", style="slider", min="10", max="200")
    int pre_compute_downsample_xy = 10;
    @Parameter(label="Fixed source", callback="updateMessage", style="sorted")
    SourceAndConverter<?>[] fixed_sources;
    @Parameter(label="Moving sources", callback="updateMessage", style="sorted")
    SourceAndConverter<?>[] moving_sources;
    @Parameter(label="Include fixed sources in exported image")
    boolean include_fixed_sources;
    @Parameter(label="Interpolate pixels values")
    boolean interpolate;
    @Parameter(label="Up (v>1) or Downsample (v<1) the fused image", persist=false)
    double upsample = 1.0;
    @Parameter
    Context scijavaCtx;

    public void run() {
        try {
            if (this.remove_z_offsets) {
                this.fixed_sources = WarpyEditRegistrationCommand.removeZOffsets(this.fixed_sources);
            }
            if (this.remove_z_offsets) {
                this.moving_sources = WarpyEditRegistrationCommand.removeZOffsets(this.moving_sources);
            }
            int fixed_series_index = QuPathBdvHelper.getEntryId(this.fixed_sources[0]);
            HashMap sourceToTransformation = new HashMap();
            double downsampleXYTransformField = this.pre_compute_downsample_xy;
            double downsampleZTransformField = 1.0;
            EmptySource model = null;
            if (this.pre_compute_transform) {
                EmptySource.EmptySourceParams params = new EmptySource.EmptySourceParams();
                long nPixX = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(0) + 1L;
                long nPixY = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(1) + 1L;
                long nPixZ = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(2) + 1L;
                params.nx = (long)((double)nPixX / downsampleXYTransformField);
                params.ny = (long)((double)nPixY / downsampleXYTransformField);
                params.nz = (long)((double)nPixZ / downsampleZTransformField);
                AffineTransform3D transform = new AffineTransform3D();
                this.fixed_sources[0].getSpimSource().getSourceTransform(0, 0, transform);
                params.at3D = transform.copy();
                double posX = params.at3D.get(0, 3);
                double posY = params.at3D.get(1, 3);
                double posZ = params.at3D.get(2, 3);
                params.at3D.translate(new double[]{-posX, -posY, -posZ});
                params.at3D.scale(downsampleXYTransformField, downsampleXYTransformField, 1.0);
                params.at3D.translate(new double[]{posX, posY, posZ});
                model = new EmptySource(params);
            }
            if (this.pre_compute_transform) {
                IJ.log((String)"Computing deformation fields, please wait...");
            }
            HashMap<File, RealTransform> alreadyOpenedTransforms = new HashMap<File, RealTransform>();
            for (SourceAndConverter<?> source : this.moving_sources) {
                File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(source);
                int moving_series_index = QuPathBdvHelper.getEntryId(source);
                String movingToFixedLandmarkName = "transform_" + moving_series_index + "_" + fixed_series_index + ".json";
                File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                if (!result.exists()) {
                    IJ.error((String)("Registration file " + result.getAbsolutePath() + " not found"));
                    return;
                }
                if (alreadyOpenedTransforms.containsKey(result)) {
                    sourceToTransformation.put(source, ((RealTransform)alreadyOpenedTransforms.get(result)).copy());
                    continue;
                }
                JsonReader reader = new JsonReader((Reader)new FileReader(result));
                InvertibleRealTransformSequence irts = (InvertibleRealTransformSequence)ScijavaGsonHelper.getGson((Context)this.scijavaCtx).fromJson(reader, RealTransform.class);
                RealTransform transformation = (RealTransform)RealTransformHelper.getTransformSequence(irts).get(1);
                if (this.pre_compute_transform) {
                    transformation = bdv.util.RealTransformHelper.resampleTransform(transformation, model);
                }
                sourceToTransformation.put(source, transformation);
                alreadyOpenedTransforms.put(result, transformation);
            }
            if (this.pre_compute_transform) {
                IJ.log((String)"Computation done!");
            }
            List movingSacs = Arrays.stream(this.moving_sources).collect(Collectors.toList());
            List fixedSacs = Arrays.stream(this.fixed_sources).collect(Collectors.toList());
            ArrayList<SourceAndConverter> transformedSources = new ArrayList<SourceAndConverter>();
            Class<?> pixelType = ((SourceAndConverter)movingSacs.get(0)).getSpimSource().getType().getClass();
            for (SourceAndConverter source : movingSacs) {
                if (!source.getSpimSource().getType().getClass().equals(pixelType)) {
                    IJ.log((String)"ERROR - combining images with different pixel types is not supported: ");
                    IJ.log((String)(((SourceAndConverter)movingSacs.get(0)).getSpimSource().getName() + " pixel type = " + pixelType.getSimpleName()));
                    IJ.log((String)(source.getSpimSource().getName() + " pixel type = " + source.getSpimSource().getType().getClass().getSimpleName()));
                    IJ.log((String)"You may try to re-open your QuPath project with the option 'split RGB channel'");
                    return;
                }
                transformedSources.add(new SourceRealTransformer(((RealTransform)sourceToTransformation.get(source)).copy()).apply(source));
            }
            ArrayList<Object> exportedSources = new ArrayList<Object>();
            SourceAndConverter modelForResampling = (SourceAndConverter)fixedSacs.get(0);
            if (this.upsample != 1.0) {
                EmptySource.EmptySourceParams params = new EmptySource.EmptySourceParams();
                long nPixX = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(0) + 1L;
                long nPixY = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(1) + 1L;
                long nPixZ = this.fixed_sources[0].getSpimSource().getSource(0, 0).max(2) + 1L;
                params.nx = (long)((double)nPixX * this.upsample);
                params.ny = (long)((double)nPixY * this.upsample);
                params.nz = nPixZ;
                AffineTransform3D transform = new AffineTransform3D();
                this.fixed_sources[0].getSpimSource().getSourceTransform(0, 0, transform);
                params.at3D = transform.copy();
                double posX = params.at3D.get(0, 3);
                double posY = params.at3D.get(1, 3);
                double posZ = params.at3D.get(2, 3);
                params.at3D.translate(new double[]{-posX, -posY, -posZ});
                params.at3D.scale(1.0 / this.upsample, 1.0 / this.upsample, 1.0);
                params.at3D.translate(new double[]{posX, posY, posZ});
                modelForResampling = new SourceAndConverter((Source)new EmptySource(params), null, null);
            }
            if (this.include_fixed_sources) {
                for (SourceAndConverter source : fixedSacs) {
                    if (source.getSpimSource().getType().getClass().equals(pixelType)) continue;
                    IJ.log((String)"ERROR - combining images with different pixel types is not supported: ");
                    IJ.log((String)(((SourceAndConverter)movingSacs.get(0)).getSpimSource().getName() + " pixel type = " + pixelType.getSimpleName()));
                    IJ.log((String)(source.getSpimSource().getName() + " pixel type = " + source.getSpimSource().getType().getClass().getSimpleName()));
                    IJ.log((String)"You may try to re-open your QuPath project with the option 'split RGB channel'");
                    return;
                }
                if (this.upsample == 1.0) {
                    exportedSources.addAll(fixedSacs);
                } else {
                    for (SourceAndConverter source : fixedSacs) {
                        exportedSources.add(new SourceResampler(source, modelForResampling, source.getSpimSource().getName() + "_Warpy", false, false, this.interpolate, 0).get());
                    }
                }
            }
            for (SourceAndConverter source : transformedSources) {
                exportedSources.add(new SourceResampler(source, modelForResampling, source.getSpimSource().getName() + "_Warpy", false, false, this.interpolate, 0).get());
            }
            ((CommandService)this.scijavaCtx.getService(CommandService.class)).run(KheopsExportSourcesCommand.class, true, new Object[]{"sacs", exportedSources.toArray(new SourceAndConverter[0]), "range_channels", "", "override_voxel_size", false, "vox_size_xy_um", -1, "vox_size_z_um", -1}).get();
            IJ.log((String)"Export warpy registered image done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMessage() {
        String message = "<html><h1>Warpy registration exporter</h1>";
        if (this.fixed_sources == null || this.fixed_sources.length == 0) {
            message = message + "Please select a fixed source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.fixed_sources[0])) {
            message = message + "The fixed source is not originating from a QuPath project! <br>";
        } else if (this.moving_sources == null || this.moving_sources.length == 0) {
            message = message + "Please select at least one moving source <br>";
        } else {
            for (SourceAndConverter<?> testSource : this.moving_sources) {
                if (!QuPathBdvHelper.isSourceLinkedToQuPath(testSource)) {
                    message = message + testSource.getSpimSource().getName() + " is not originating from a QuPath project! <br>";
                    this.message = message = message + "</html>";
                    return;
                }
                try {
                    String qupathProjectMoving = QuPathBdvHelper.getProjectFile(testSource).getAbsolutePath();
                    String qupathProjectFixed = QuPathBdvHelper.getProjectFile(this.fixed_sources[0]).getAbsolutePath();
                    if (!qupathProjectMoving.equals(qupathProjectFixed)) {
                        message = message + "Error : the moving source (" + testSource.getSpimSource().getName() + ") and the fixed source are not from the same qupath project";
                        this.message = message = message + "</html>";
                        return;
                    }
                    File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(testSource);
                    File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.fixed_sources[0]);
                    if (!moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) continue;
                    message = message + "Error : moving and fixed source should belong to different qupath entries. <br>";
                    message = message + "<ul>";
                    message = message + "<li>Fixed: " + this.fixed_sources[0].getSpimSource().getName() + "</li>";
                    message = message + "<li>Moving: " + testSource.getSpimSource().getName() + "</li>";
                    message = message + "<ul>";
                    this.message = message = message + "</html>";
                    return;
                }
                catch (Exception e) {
                    message = message + "Could not fetch the QuPath project error: " + e.getMessage() + "<br>";
                    this.message = message = message + "</html>";
                    return;
                }
            }
        }
        message = message + "Export task properly set: <br>";
        this.message = message = message + "</html>";
    }
}

