/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.BdvHandle;
import bdv.util.QuPathBdvHelper;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarp;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import com.google.gson.stream.JsonReader;
import ij.IJ;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformHelper;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>QuPath - Edit Warpy Registration")
public class WarpyEditRegistrationCommand
implements Command {
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, style="message")
    String message = "<html><h1>QuPath registration edition</h1>Please select a moving and a fixed source<br></html>";
    @Parameter(label="Remove Z offsets")
    boolean remove_z_offsets = true;
    @Parameter(label="Fixed source", callback="updateMessage")
    SourceAndConverter<?>[] fixed_sources;
    @Parameter(label="Moving source", callback="updateMessage")
    SourceAndConverter<?>[] moving_sources;
    @Parameter
    Context scijavaCtx;
    boolean canceled = false;
    private boolean isBigWarpFinished = false;

    public void run() {
        try {
            File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.moving_sources[0]);
            File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.fixed_sources[0]);
            int moving_series_index = QuPathBdvHelper.getEntryId(this.moving_sources[0]);
            int fixed_series_index = QuPathBdvHelper.getEntryId(this.fixed_sources[0]);
            String movingToFixedLandmarkName = "transform_" + moving_series_index + "_" + fixed_series_index + ".json";
            File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
            if (!result.exists()) {
                IJ.error((String)"Registration file not found");
            } else {
                RealTransformSequence transformSequence;
                RealTransform rt = this.performBigWarpEdition(result);
                if (rt == null) {
                    IJ.log((String)"Edition cancelled! Click the confirm button in BigWarp if you want to save your result. ");
                    return;
                }
                AffineTransform3D movingToPixel = new AffineTransform3D();
                this.moving_sources[0].getSpimSource().getSourceTransform(0, 0, movingToPixel);
                AffineTransform3D fixedToPixel = new AffineTransform3D();
                this.fixed_sources[0].getSpimSource().getSourceTransform(0, 0, fixedToPixel);
                if (rt instanceof InvertibleRealTransform) {
                    InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
                    irts.add((RealTransform)fixedToPixel);
                    irts.add((RealTransform)((InvertibleRealTransform)rt));
                    irts.add((RealTransform)movingToPixel.inverse());
                    transformSequence = irts;
                } else {
                    RealTransformSequence rts = new RealTransformSequence();
                    rts.add((RealTransform)fixedToPixel);
                    rts.add(rt);
                    rts.add((RealTransform)movingToPixel.inverse());
                    transformSequence = rts;
                }
                String jsonMovingToFixed = ScijavaGsonHelper.getGson((Context)this.scijavaCtx).toJson((Object)transformSequence, RealTransform.class);
                FileUtils.writeStringToFile((File)result, (String)jsonMovingToFixed, (Charset)Charset.defaultCharset());
                IJ.log((String)("Fixed: " + this.fixed_sources[0].getSpimSource().getName() + " | Moving: " + this.moving_sources[0].getSpimSource().getName()));
                IJ.log((String)("Transformation file successfully written to QuPath project: " + result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RealTransform performBigWarpEdition(File result) throws Exception {
        JsonReader reader = new JsonReader((Reader)new FileReader(result));
        InvertibleRealTransformSequence irts = (InvertibleRealTransformSequence)ScijavaGsonHelper.getGson((Context)this.scijavaCtx).fromJson(reader, RealTransform.class);
        RealTransform transformation = (RealTransform)RealTransformHelper.getTransformSequence(irts).get(1);
        ThinplateSplineTransform tst = (ThinplateSplineTransform)((WrappedIterativeInvertibleRealTransform)((InvertibleWrapped2DTransformAs3D)transformation).getTransform()).getTransform();
        if (this.remove_z_offsets) {
            this.moving_sources = WarpyEditRegistrationCommand.removeZOffsets(this.moving_sources);
        }
        List movingSacs = Arrays.stream(this.moving_sources).collect(Collectors.toList());
        if (this.remove_z_offsets) {
            this.fixed_sources = WarpyEditRegistrationCommand.removeZOffsets(this.fixed_sources);
        }
        List fixedSacs = Arrays.stream(this.fixed_sources).collect(Collectors.toList());
        List converterSetups = Arrays.stream(this.moving_sources).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList());
        converterSetups.addAll(Arrays.stream(this.fixed_sources).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList()));
        BigWarpLauncher bwl = new BigWarpLauncher(movingSacs, fixedSacs, "Edit QuPath Registration", converterSetups);
        bwl.set2d();
        bwl.run();
        BdvHandle bdvhQ = bwl.getBdvHandleQ();
        BdvHandle bdvhP = bwl.getBdvHandleP();
        SourceAndConverterServices.getBdvDisplayService().pairClosing(bdvhQ, bdvhP);
        bdvhP.getViewerPanel().requestRepaint();
        bdvhQ.getViewerPanel().requestRepaint();
        bwl.getBigWarp().getLandmarkFrame().repaint();
        bwl.getBigWarp().loadLandmarks(bdv.util.RealTransformHelper.BigWarpFileFromRealTransform((RealTransform)tst));
        bwl.getBigWarp().setIsMovingDisplayTransformed(true);
        AffineTransform3D at3D = new AffineTransform3D();
        bdvhP.getViewerPanel().state().getViewerTransform(at3D);
        this.waitForBigWarp(bwl.getBigWarp());
        bwl.getBigWarp().closeAll();
        if (this.canceled) {
            return null;
        }
        return bwl.getBigWarp().getBwTransform().getTransformation().copy();
    }

    public static SourceAndConverter<?>[] removeZOffsets(SourceAndConverter<?>[] sources) {
        SourceAndConverter[] recentered = new SourceAndConverter[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            recentered[i] = WarpyEditRegistrationCommand.removeZOffset(sources[i]);
        }
        return recentered;
    }

    public static SourceAndConverter<?> removeZOffset(SourceAndConverter<?> source) {
        AffineTransform3D zOffsetTransform = new AffineTransform3D();
        AffineTransform3D at3D = new AffineTransform3D();
        source.getSpimSource().getSourceTransform(0, 0, at3D);
        zOffsetTransform.translate(new double[]{0.0, 0.0, -at3D.get(2, 3)});
        SourceAndConverter recenteredSource = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)zOffsetTransform, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(source, 0));
        return recenteredSource;
    }

    private void waitForBigWarp(BigWarp bw) throws InterruptedException {
        bw.getViewerFrameP().addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WarpyEditRegistrationCommand.this.canceled = true;
                WarpyEditRegistrationCommand.this.isBigWarpFinished = true;
            }
        });
        bw.getViewerFrameQ().addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WarpyEditRegistrationCommand.this.canceled = true;
                WarpyEditRegistrationCommand.this.isBigWarpFinished = true;
            }
        });
        JButton confirmP = new JButton("Save and close");
        confirmP.addActionListener(e -> {
            this.isBigWarpFinished = true;
        });
        JButton cancelButtonP = new JButton("Cancel and close");
        cancelButtonP.addActionListener(e -> {
            this.canceled = true;
            this.isBigWarpFinished = true;
        });
        JPanel cardpanelP = RectangleSelectorBehaviour.box(false, new JLabel("BigWarp registration"), cancelButtonP, confirmP);
        bw.getViewerFrameP().getSplitPanel().setCollapsed(false);
        bw.getViewerFrameP().getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
        bw.getViewerFrameP().getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
        SwingUtilities.invokeLater(() -> bw.getViewerFrameP().getCardPanel().addCard("Warpy transformation edition", (JComponent)cardpanelP, true));
        JButton confirmQ = new JButton("Save and close");
        confirmQ.addActionListener(e -> {
            this.isBigWarpFinished = true;
        });
        JButton cancelButtonQ = new JButton("Cancel and close");
        cancelButtonQ.addActionListener(e -> {
            this.canceled = true;
            this.isBigWarpFinished = true;
        });
        JPanel cardpanelQ = RectangleSelectorBehaviour.box(false, new JLabel("BigWarp registration"), cancelButtonQ, confirmQ);
        bw.getViewerFrameQ().getSplitPanel().setCollapsed(false);
        bw.getViewerFrameQ().getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
        bw.getViewerFrameQ().getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
        SwingUtilities.invokeLater(() -> bw.getViewerFrameQ().getCardPanel().addCard("Warpy transformation edition", (JComponent)cardpanelQ, true));
        while (!this.isBigWarpFinished) {
            Thread.sleep(100L);
        }
    }

    public void updateMessage() {
        String message = "<html><h1>QuPath registration edition</h1>";
        if (this.fixed_sources == null) {
            message = message + "Please select a fixed source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.fixed_sources[0])) {
            message = message + "The fixed source is not originating from a QuPath project! <br>";
        } else if (this.moving_sources == null) {
            message = message + "Please select a moving source <br>";
        } else if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.moving_sources[0])) {
            message = message + "The moving source is not originating from a QuPath project! <br>";
        } else {
            try {
                String qupathProjectMoving = QuPathBdvHelper.getProjectFile(this.moving_sources[0]).getAbsolutePath();
                String qupathProjectFixed = QuPathBdvHelper.getProjectFile(this.fixed_sources[0]).getAbsolutePath();
                if (!qupathProjectMoving.equals(qupathProjectFixed)) {
                    message = message + "Error : the moving source and the fixed source are not from the same qupath project";
                } else {
                    File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.moving_sources[0]);
                    File fixed_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.fixed_sources[0]);
                    if (moving_entry_folder.getAbsolutePath().equals(fixed_entry_folder.getAbsolutePath())) {
                        message = message + "Error : moving and fixed source should belong to different qupath entries. <br>";
                        message = message + "You can't move two channels of the same image, <br>";
                        message = message + "unless you duplicate the images in QuPath. <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + this.fixed_sources[0].getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + this.moving_sources[0].getSpimSource().getName() + "</li>";
                        message = message + "<ul>";
                    } else {
                        message = message + "Registration task properly set: <br>";
                        message = message + "<ul>";
                        message = message + "<li>Fixed: " + this.fixed_sources[0].getSpimSource().getName() + "</li>";
                        message = message + "<li>Moving: " + this.moving_sources[0].getSpimSource().getName() + "</li>";
                        message = message + "</ul>";
                        int moving_series_index = QuPathBdvHelper.getEntryId(this.moving_sources[0]);
                        int fixed_series_index = QuPathBdvHelper.getEntryId(this.fixed_sources[0]);
                        String movingToFixedLandmarkName = "transform_" + moving_series_index + "_" + fixed_series_index + ".json";
                        File result = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (!result.exists()) {
                            message = message + "WARNING! REGISTRATION FILE NOT FOUND!<br>";
                        }
                        movingToFixedLandmarkName = "transform_" + fixed_series_index + "_" + moving_series_index + ".json";
                        result = new File(fixed_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
                        if (result.exists()) {
                            message = message + "WARNING! AN <b>INVERSE</b> REGISTRATION FILE ALREADY EXISTS! <br>";
                            message = message + "Switch your fixed and moving selected source to edit it!<br>";
                        }
                    }
                }
            }
            catch (Exception e) {
                message = message + "Could not fetch the QuPath project error: " + e.getMessage() + "<br>";
            }
        }
        this.message = message = message + "</html>";
    }
}

