/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.BigWarpHelper;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.qupath.command.CreateBdvDatasetQuPathCommand;
import ch.epfl.biop.scijava.command.source.register.Elastix2DAffineRegisterCommand;
import ch.epfl.biop.scijava.command.source.register.Elastix2DSparsePointsRegisterCommand;
import ij.IJ;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import net.imagej.ImageJ;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.scijava.ItemIO;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesShowCommand;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Obsolete>Align Slides (2D)")
public class RegisterWholeSlideScans2DCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(RegisterWholeSlideScans2DCommand.class);
    @Parameter(label="Global reference image (fixed, usually, first dapi channel)")
    SourceAndConverter global_ref_source;
    @Parameter(label="Index of current reference image (moving, dapi channel of scan i)")
    SourceAndConverter current_ref_source;
    @Parameter(label="Background offset value for moving image")
    double background_offset_value_moving = 0.0;
    @Parameter(label="Background offset value for fixed image")
    double background_offset_value_fixed = 0.0;
    @Parameter(label="Locations of interest for warping registration", style="text area")
    String pt_list_coordinates = "15,10,\n -30,-40,\n ";
    @Parameter(label="Make a first affine registration on defined regions")
    boolean perform_first_coarse_affine_registration;
    @Parameter(label="Make a second spline registration with landmarks")
    boolean perform_second_spline_registration;
    @Parameter(style="format:0.#####E0")
    double top_left_x;
    @Parameter(style="format:0.#####E0")
    double top_left_y;
    @Parameter(style="format:0.#####E0")
    double bottom_right_x;
    @Parameter(style="format:0.#####E0")
    double bottom_right_y;
    @Parameter(label="Number of iterations for each scale (default 100)")
    int max_iteration_per_scale = 100;
    @Parameter(label="Pixel size for coarse registration in mm (default 0.01)", style="format:0.000", persist=false)
    double coarse_pixel_size_mm = 0.01;
    @Parameter(label="Patch size for registration in mm (default 0.5)", style="format:0.000", persist=false)
    double patch_size_mm = 0.5;
    @Parameter(label="Pixel size for precise patch registration in mm (default 0.001)", style="format:0.000", persist=false)
    double precise_pixel_size_mm = 0.001;
    @Parameter
    CommandService cs;
    @Parameter
    boolean show_details;
    @Parameter(type=ItemIO.OUTPUT)
    RealTransform tst;
    @Parameter
    boolean verbose;

    public void run() {
        try {
            AffineTransform3D at1 = new AffineTransform3D();
            SourceAndConverter firstRegSrc = this.current_ref_source;
            if (this.perform_first_coarse_affine_registration) {
                logger.info("----------- First registration - Coarse Affine");
                IJ.log((String)"- Coarse Affine Registration");
                CommandModule cm = (CommandModule)this.cs.run(Elastix2DAffineRegisterCommand.class, true, new Object[]{"sacs_fixed", new SourceAndConverter[]{this.global_ref_source}, "tp_fixed", 0, "level_fixed_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.global_ref_source, (int)0, (double)this.coarse_pixel_size_mm), "sacs_moving", new SourceAndConverter[]{this.current_ref_source}, "tp_moving", 0, "level_moving_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.current_ref_source, (int)0, (double)this.coarse_pixel_size_mm), "px", this.top_left_x, "py", this.top_left_y, "pz", 0, "sx", this.bottom_right_x - this.top_left_x, "sy", this.bottom_right_y - this.top_left_y, "px_size_in_current_unit", this.coarse_pixel_size_mm, "interpolate", true, "show_image_registration", this.show_details, "automatic_transform_initialization", false, "max_iteration_per_scale", this.max_iteration_per_scale, "min_image_size_pix", 32, "background_offset_value_moving", this.background_offset_value_moving, "background_offset_value_fixed", this.background_offset_value_fixed, "verbose", this.verbose}).get();
                at1 = (AffineTransform3D)cm.getOutput("at3d");
                firstRegSrc = new SourceAffineTransformer(at1).apply(this.current_ref_source);
            }
            logger.info("----------- Precise Warping based on particular locations");
            AffineTransform3D tst_temp = new AffineTransform3D();
            if (this.perform_second_spline_registration) {
                IJ.log((String)"- Landmarks registration");
                tst_temp = (RealTransform)((CommandModule)this.cs.run(Elastix2DSparsePointsRegisterCommand.class, true, new Object[]{"sacs_fixed", new SourceAndConverter[]{this.global_ref_source}, "sacs_moving", new SourceAndConverter[]{firstRegSrc}, "tp_fixed", 0, "level_fixed_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.global_ref_source, (int)0, (double)this.precise_pixel_size_mm), "tp_moving", 0, "level_moving_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)firstRegSrc, (int)0, (double)this.precise_pixel_size_mm), "pt_list_coordinates", this.pt_list_coordinates, "z_location", 0, "sx", this.patch_size_mm, "sy", this.patch_size_mm, "px_size_in_current_unit", this.precise_pixel_size_mm, "interpolate", true, "show_points", this.show_details, "parallel", !this.show_details, "verbose", this.verbose, "max_iteration_per_scale", this.max_iteration_per_scale, "background_offset_value_moving", this.background_offset_value_moving, "background_offset_value_fixed", this.background_offset_value_fixed, "verbose", this.verbose}).get()).getOutput("tst");
            } else {
                this.pt_list_coordinates = this.top_left_x + "," + this.top_left_y + ",";
                this.pt_list_coordinates = this.pt_list_coordinates + this.bottom_right_x + "," + this.top_left_y + ",";
                this.pt_list_coordinates = this.pt_list_coordinates + this.bottom_right_x + "," + this.bottom_right_y + ",";
                this.pt_list_coordinates = this.pt_list_coordinates + this.top_left_x + "," + this.bottom_right_y;
            }
            logger.info("----------- Computing global transformation");
            RealTransformSequence rts = new RealTransformSequence();
            AffineTransform3D at2 = new AffineTransform3D();
            rts.add((RealTransform)at1.concatenate(at2).inverse());
            rts.add((RealTransform)tst_temp);
            ArrayList<RealPoint> pts_Fixed = new ArrayList<RealPoint>();
            ArrayList<RealPoint> pts_Moving = new ArrayList<RealPoint>();
            String[] coordsXY = this.pt_list_coordinates.split(",");
            for (int i = 0; i < coordsXY.length; i += 2) {
                RealPoint pt_fixed = new RealPoint(new double[]{Double.valueOf(coordsXY[i]), Double.valueOf(coordsXY[i + 1]), 0.0});
                pts_Fixed.add(pt_fixed);
                RealPoint pt_moving = new RealPoint(3);
                rts.apply((RealLocalizable)pt_fixed, (RealPositionable)pt_moving);
                pts_Moving.add(pt_moving);
            }
            this.tst = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(pts_Moving, pts_Fixed, (boolean)true)));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        CommandService cs = ij.command();
        cs.run(CreateBdvDatasetQuPathCommand.class, true, new Object[]{"unit", "MILLIMETER", "split_rgb_channels", false}).get();
        cs.run(BdvSourcesShowCommand.class, true, new Object[]{"autoContrast", true, "adjustViewOnSource", true, "is2D", true, "windowTitle", "Test Registration", "interpolate", false, "nTimepoints", 1, "projector", "Sum Projector", "sacs", "SpimData 0>Channel>1"}).get();
    }
}

