/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import bdv.util.BigWarpHelper;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.scijava.command.source.register.Elastix2DSparsePointsRegisterCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.ThinPlateSplineTransformAdapter;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Obsolete>Multiscale Registration (2D)", headless=true, initializer="updateInfo")
public class MultiscaleRegisterCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(MultiscaleRegisterCommand.class);
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "<html><h2>Automated WSI registration using multiscale Warpy</h2><br/>Automated registrations requires elastix.<br/></html>";
    @Parameter(label="Number of registration scales (# registration x2 per scale)", style="slider", min="2", max="8", callback="updateInfo")
    int n_scales = 4;
    @Parameter(visibility=ItemVisibility.MESSAGE, required=false)
    String info_registration = "";
    @Parameter(label="Fixed reference sources", style="sorted")
    SourceAndConverter<?>[] fixed;
    @Parameter(label="Moving sources used for registration to the reference", style="sorted")
    SourceAndConverter<?>[] moving;
    @Parameter(label="Sources to transform, including the moving source if needed")
    SourceAndConverter<?>[] sources_to_transform;
    @Parameter(label="Remove images z-offsets")
    boolean remove_z_offset = true;
    @Parameter(label="Center moving image with fixed image")
    boolean center_moving_image = true;
    @Parameter(label="Number of pixel for each block of image used for the registration (default 128)")
    int pixels_per_block = 128;
    @Parameter(label="Number of iterations for each registration (default 100)")
    int max_iteration_number_per_scale = 100;
    @Parameter(label="Show results of automated registrations (breaks parallelization)")
    boolean show_details = false;
    @Parameter
    boolean debug;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?>[] transformed_sources;
    @Parameter(type=ItemIO.OUTPUT)
    RealTransform transformation;
    @Parameter
    CommandService cs;
    @Parameter
    TaskService taskService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InvertibleRealTransformSequence transformSequence = new InvertibleRealTransformSequence();
        AffineTransform3D preTransformFixed = new AffineTransform3D();
        AffineTransform3D preTransformMoving = new AffineTransform3D();
        if (this.remove_z_offset) {
            AffineTransform3D at3D = new AffineTransform3D();
            this.moving[0].getSpimSource().getSourceTransform(0, 0, at3D);
            preTransformMoving.translate(new double[]{0.0, 0.0, -at3D.get(2, 3)});
            this.fixed[0].getSpimSource().getSourceTransform(0, 0, at3D);
            preTransformFixed.translate(new double[]{0.0, 0.0, -at3D.get(2, 3)});
        }
        if (this.center_moving_image) {
            RealPoint centerMoving = SourceAndConverterHelper.getSourceAndConverterCenterPoint(this.moving[0], (int)0);
            RealPoint centerFixed = SourceAndConverterHelper.getSourceAndConverterCenterPoint(this.fixed[0], (int)0);
            preTransformMoving.translate(new double[]{centerFixed.getDoublePosition(0) - centerMoving.getDoublePosition(0), centerFixed.getDoublePosition(1) - centerMoving.getDoublePosition(1), 0.0});
        }
        for (int i = 0; i < this.moving.length; ++i) {
            SourceAndConverter newMoving;
            SourceAndConverter newFixed = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)preTransformFixed, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(this.fixed[i], 0));
            this.moving[i] = newMoving = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)preTransformMoving, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(this.moving[i], 0));
            this.fixed[i] = newFixed;
        }
        Task task = null;
        try {
            task = this.taskService.createTask("Warpy Reg. " + this.moving[0].getSpimSource().getName() + "  / " + this.fixed[0].getSpimSource().getName());
            RealInterval box = this.getBoundingBox();
            ArrayList<RealPoint> corners = new ArrayList<RealPoint>();
            corners.add(box.minAsRealPoint());
            corners.add(box.maxAsRealPoint());
            double topLeftX = Math.min(((RealPoint)corners.get(0)).getDoublePosition(0), ((RealPoint)corners.get(1)).getDoublePosition(0));
            double topLeftY = Math.min(((RealPoint)corners.get(0)).getDoublePosition(1), ((RealPoint)corners.get(1)).getDoublePosition(1));
            double bottomRightX = Math.max(((RealPoint)corners.get(0)).getDoublePosition(0), ((RealPoint)corners.get(1)).getDoublePosition(0));
            double bottomRightY = Math.max(((RealPoint)corners.get(0)).getDoublePosition(1), ((RealPoint)corners.get(1)).getDoublePosition(1));
            this.transformation = new RealTransformSequence();
            task.setStatusMessage("Registration started...");
            HashMap landmarksPerScale = new HashMap();
            HashMap<Integer, Double> blockSizeXmmPerScale = new HashMap<Integer, Double>();
            HashMap<Integer, Double> blockSizeYmmPerScale = new HashMap<Integer, Double>();
            int nScales = 0;
            double sizeBlockXmm = bottomRightX - topLeftX;
            double sizeBlockYmm = bottomRightY - topLeftY;
            int nRegistrations = 0;
            for (int iScale = 0; iScale < this.n_scales; ++iScale) {
                if (sizeBlockXmm > sizeBlockYmm) {
                    sizeBlockXmm /= 2.0;
                } else {
                    sizeBlockYmm /= 2.0;
                }
                ArrayList<RealPoint> landmarksAtCurrentLevel = new ArrayList<RealPoint>();
                for (double xp = topLeftX + sizeBlockXmm / 2.0; xp < bottomRightX; xp += sizeBlockXmm) {
                    for (double yp = topLeftY + sizeBlockYmm / 2.0; yp < bottomRightY; yp += sizeBlockYmm) {
                        landmarksAtCurrentLevel.add(new RealPoint(new double[]{xp, yp}));
                    }
                }
                if (landmarksAtCurrentLevel.size() < 4) continue;
                landmarksPerScale.put(nScales, landmarksAtCurrentLevel);
                blockSizeXmmPerScale.put(nScales, sizeBlockXmm);
                blockSizeYmmPerScale.put(nScales, sizeBlockYmm);
                ++nScales;
                nRegistrations += landmarksAtCurrentLevel.size();
            }
            task.setProgressMaximum((long)nRegistrations);
            for (int scale = 0; scale < nScales; ++scale) {
                SourceAndConverter<?>[] transformedMoving;
                task.setStatusMessage("Registration level " + (scale + 1) + " / " + nScales);
                double pixelSizeBlockmm = Math.max((Double)blockSizeXmmPerScale.get(scale), (Double)blockSizeYmmPerScale.get(scale)) / (double)this.pixels_per_block;
                String ptListCoordinates = "";
                for (RealPoint pt : (List)landmarksPerScale.get(scale)) {
                    ptListCoordinates = ptListCoordinates + pt.getDoublePosition(0) + "," + pt.getDoublePosition(1) + ",";
                }
                if (scale != 0) {
                    ArrayList<RealPoint> ptsSource = new ArrayList<RealPoint>();
                    ArrayList<RealPoint> ptsTarget = new ArrayList<RealPoint>();
                    List landmarksLastScale = (List)landmarksPerScale.get(nScales - 1);
                    for (Object source2 : landmarksLastScale) {
                        ptsSource.add((RealPoint)source2);
                        RealPoint dest = new RealPoint(3);
                        transformSequence.apply((RealLocalizable)source2, (RealPositionable)dest);
                        ptsTarget.add(dest);
                    }
                    InvertibleWrapped2DTransformAs3D currentTransformation = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(ptsTarget, ptsSource, (boolean)true)));
                    transformedMoving = (SourceAndConverter[])Arrays.stream(this.moving).map(arg_0 -> MultiscaleRegisterCommand.lambda$run$0((InvertibleRealTransform)currentTransformation, arg_0)).toArray(SourceAndConverter[]::new);
                } else {
                    transformedMoving = this.moving;
                }
                RealTransform currentLevelTransform = (RealTransform)((CommandModule)this.cs.run(Elastix2DSparsePointsRegisterCommand.class, true, new Object[]{"sacs_fixed", this.fixed, "sacs_moving", transformedMoving, "tp_fixed", 0, "level_fixed_source", SourceAndConverterHelper.bestLevel(this.fixed[0], (int)0, (double)pixelSizeBlockmm), "tp_moving", 0, "level_moving_source", SourceAndConverterHelper.bestLevel(this.moving[0], (int)0, (double)pixelSizeBlockmm), "pt_list_coordinates", ptListCoordinates, "z_location", 0, "sx", blockSizeXmmPerScale.get(scale), "sy", blockSizeYmmPerScale.get(scale), "px_size_in_current_unit", pixelSizeBlockmm, "interpolate", true, "show_points", this.show_details, "parallel", !this.show_details, "verbose", this.debug, "max_iteration_per_scale", this.max_iteration_number_per_scale, "background_offset_value_moving", 0, "background_offset_value_fixed", 0, "task", task}).get()).getOutput("tst");
                transformSequence.add((RealTransform)((InvertibleWrapped2DTransformAs3D)currentLevelTransform).getTransform());
                if (this.debug) {
                    SourceAndConverter[] currentScaleSources;
                    Object source2;
                    ArrayList<RealPoint> ptsSource = new ArrayList<RealPoint>();
                    ArrayList<RealPoint> ptsTarget = new ArrayList<RealPoint>();
                    List landmarksLastScale = (List)landmarksPerScale.get(nScales - 1);
                    source2 = landmarksLastScale.iterator();
                    while (source2.hasNext()) {
                        RealPoint source3 = (RealPoint)source2.next();
                        ptsSource.add(source3);
                        RealPoint dest = new RealPoint(3);
                        transformSequence.apply((RealLocalizable)source3, (RealPositionable)dest);
                        ptsTarget.add(dest);
                    }
                    InvertibleWrapped2DTransformAs3D currentTransformation = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(ptsTarget, ptsSource, (boolean)true)));
                    for (SourceAndConverter source4 : currentScaleSources = (SourceAndConverter[])Arrays.stream(this.moving).map(arg_0 -> MultiscaleRegisterCommand.lambda$run$2((InvertibleRealTransform)currentTransformation, arg_0)).toArray(SourceAndConverter[]::new)) {
                        SourceAndConverterServices.getSourceAndConverterService().register(new RenamedSourceAndConverterAdapter(source4, source4.getSpimSource().getName() + "_Scale_" + scale));
                    }
                }
                if (task.isCanceled()) break;
            }
            if (!task.isCanceled()) {
                ArrayList<RealPoint> ptsSource = new ArrayList<RealPoint>();
                ArrayList<RealPoint> ptsTarget = new ArrayList<RealPoint>();
                List landmarksLastScale = (List)landmarksPerScale.get(nScales - 1);
                for (int i = 0; i < landmarksLastScale.size(); ++i) {
                    RealPoint source5 = (RealPoint)landmarksLastScale.get(i);
                    ptsSource.add(source5);
                    RealPoint dest = new RealPoint(3);
                    transformSequence.apply((RealLocalizable)source5, (RealPositionable)dest);
                    ptsTarget.add(dest);
                }
                this.transformation = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(ptsTarget, ptsSource, (boolean)true)));
                this.preTransformLandmarks(preTransformMoving);
                task.setStatusMessage("Registration DONE.");
                this.transformed_sources = (SourceAndConverter[])Arrays.stream(this.sources_to_transform).map(source -> new SourceRealTransformer(this.transformation).apply(source)).toArray(SourceAndConverter[]::new);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            task.finish();
        }
    }

    private void preTransformLandmarks(AffineTransform3D centeringTransform) {
        ThinplateSplineTransform tst = (ThinplateSplineTransform)((WrappedIterativeInvertibleRealTransform)((InvertibleWrapped2DTransformAs3D)this.transformation).getTransform()).getTransform();
        ThinPlateR2LogRSplineKernelTransform kernel = ThinPlateSplineTransformAdapter.getKernel((ThinplateSplineTransform)tst);
        double[][] pts_src = ThinPlateSplineTransformAdapter.getSrcPts((ThinPlateR2LogRSplineKernelTransform)kernel);
        double[][] pts_tgt = ThinPlateSplineTransformAdapter.getTgtPts((ThinPlateR2LogRSplineKernelTransform)kernel);
        ArrayList<RealPoint> movingPts = new ArrayList<RealPoint>();
        ArrayList<RealPoint> fixedPts = new ArrayList<RealPoint>();
        for (int i = 0; i < kernel.getNumLandmarks(); ++i) {
            RealPoint moving = new RealPoint(3);
            RealPoint fixed = new RealPoint(3);
            for (int d = 0; d < kernel.getNumDims(); ++d) {
                moving.setPosition(pts_tgt[d][i], d);
                fixed.setPosition(pts_src[d][i], d);
            }
            centeringTransform.inverse().apply((RealLocalizable)moving, (RealPositionable)moving);
            movingPts.add(moving);
            fixedPts.add(fixed);
        }
        this.transformation = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)BigWarpHelper.getTransform(movingPts, fixedPts, (boolean)true)));
    }

    RealInterval getBoundingBox() {
        SourceAndConverter[] sources = new SourceAndConverter[]{this.moving[0], this.fixed[0]};
        List intervalList = Arrays.stream(sources).map(sourceAndConverter -> {
            RandomAccessibleInterval interval = sourceAndConverter.getSpimSource().getSource(0, 0);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sourceAndConverter.getSpimSource().getSourceTransform(0, 0, sourceTransform);
            RealPoint corner0 = new RealPoint(new float[]{interval.min(0), interval.min(1), interval.min(2)});
            RealPoint corner1 = new RealPoint(new float[]{interval.max(0), interval.max(1), interval.max(2)});
            sourceTransform.apply((RealLocalizable)corner0, (RealPositionable)corner0);
            sourceTransform.apply((RealLocalizable)corner1, (RealPositionable)corner1);
            return new FinalRealInterval(new double[]{Math.min(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.min(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.min(corner0.getDoublePosition(2), corner1.getDoublePosition(2))}, new double[]{Math.max(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.max(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.max(corner0.getDoublePosition(2), corner1.getDoublePosition(2))});
        }).collect(Collectors.toList());
        RealInterval maxInterval = (RealInterval)intervalList.stream().reduce((i1, i2) -> new FinalRealInterval(new double[]{Math.max(i1.realMin(0), i2.realMin(0)), Math.max(i1.realMin(1), i2.realMin(1)), Math.max(i1.realMin(2), i2.realMin(2))}, new double[]{Math.min(i1.realMax(0), i2.realMax(0)), Math.min(i1.realMax(1), i2.realMax(1)), Math.min(i1.realMax(2), i2.realMax(2))})).get();
        return maxInterval;
    }

    void updateInfo() {
        int nReg = 4 * (int)(Math.pow(2.0, this.n_scales - 1) - 1.0);
        this.info_registration = nReg + " registrations will be computed, resulting in " + (int)Math.pow(2.0, this.n_scales) + " control points";
    }

    private static /* synthetic */ SourceAndConverter lambda$run$2(InvertibleRealTransform currentTransformation, SourceAndConverter source) {
        return new SourceRealTransformer((RealTransform)currentTransformation).apply(source);
    }

    private static /* synthetic */ SourceAndConverter lambda$run$0(InvertibleRealTransform currentTransformation, SourceAndConverter source) {
        return new SourceRealTransformer((RealTransform)currentTransformation).apply(source);
    }

    static class RenamedSourceAdapter<T>
    implements Source<T> {
        final Source<T> origin;
        final String name;

        public RenamedSourceAdapter(Source<T> origin, String name) {
            this.origin = origin;
            this.name = name;
        }

        public boolean isPresent(int t) {
            return this.origin.isPresent(t);
        }

        public RandomAccessibleInterval<T> getSource(int t, int level) {
            return this.origin.getSource(t, level);
        }

        public boolean doBoundingBoxCulling() {
            return this.origin.doBoundingBoxCulling();
        }

        public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
            return this.origin.getInterpolatedSource(t, level, method);
        }

        public void getSourceTransform(int t, int level, AffineTransform3D transform) {
            this.origin.getSourceTransform(t, level, transform);
        }

        public T getType() {
            return (T)this.origin.getType();
        }

        public String getName() {
            return this.name;
        }

        public VoxelDimensions getVoxelDimensions() {
            return this.origin.getVoxelDimensions();
        }

        public int getNumMipmapLevels() {
            return this.origin.getNumMipmapLevels();
        }
    }

    static class RenamedSourceAndConverterAdapter<T>
    extends SourceAndConverter<T> {
        final String name;
        final SourceAndConverter<T> origin;

        protected RenamedSourceAndConverterAdapter(SourceAndConverter<T> soc, String name) {
            super(new RenamedSourceAdapter(soc.getSpimSource(), name), soc.getConverter(), soc.asVolatile());
            this.origin = soc;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

