/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import ch.epfl.biop.scijava.command.source.register.Elastix2DAffineRegisterCommand;
import ch.epfl.biop.scijava.command.source.register.SelectSourcesForRegistrationCommand;
import ij.IJ;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.scijava.ItemIO;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Obsolete>AutoWarp Sources with Elastix and BigWarp (2D)", description="Register two 2D sources by automatically registering small fields of view \nsurrounding the specified points of interests using elastix. The returned result \nis a thin plate spline transform object that can be applied to other sources then \nedited in BigWarp.")
public class Elastix2DSparsePointsRegisterCommand
extends SelectSourcesForRegistrationCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(Elastix2DSparsePointsRegisterCommand.class);
    @Parameter(label="Background offset value for moving image")
    double background_offset_value_moving = 0.0;
    @Parameter(label="Background offset value for fixed image")
    double background_offset_value_fixed = 0.0;
    @Parameter(label="Size in physical units of each fov used for the registration of each point", style="format:0.#####E0")
    double sx;
    @Parameter(label="Size in physical units of each fov used for the registration of each point", style="format:0.#####E0")
    double sy;
    @Parameter(label="Location in z (default 0)", style="format:0.#####E0")
    double z_location = 0.0;
    @Parameter(label="Location of points of interest (px,py) used for registration", style="text area")
    String pt_list_coordinates = "15,10,\n -30,-40,\n ";
    @Parameter(type=ItemIO.OUTPUT)
    RealTransform tst;
    @Parameter(label="Parallel registration of points of interests")
    boolean parallel;
    @Parameter(label="Show point of interests registration in ImageJ1 (disables parallelisation)")
    boolean show_points;
    @Parameter
    boolean verbose = false;
    @Parameter(label="Number of iterations for each scale (default 100)")
    int max_iteration_per_scale = 100;
    @Parameter(required=false)
    Task task;
    @Parameter
    TaskService taskService;
    @Parameter
    CommandService cs;
    public Consumer<String> log = s -> {};
    AtomicInteger counter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.verbose) {
            this.log = arg_0 -> ((Logger)logger).info(arg_0);
        }
        if (this.show_points) {
            this.parallel = false;
            logger.warn("Cannot run parallel registrations if showPoints is true.");
        }
        ArrayList<RealPoint> pts_Fixed = new ArrayList<RealPoint>();
        String[] coordsXY = this.pt_list_coordinates.split(",");
        for (int i = 0; i < coordsXY.length; i += 2) {
            pts_Fixed.add(new RealPoint(new double[]{Double.valueOf(coordsXY[i]), Double.valueOf(coordsXY[i + 1]), this.z_location}));
        }
        boolean innerTask = false;
        if (this.task == null) {
            this.task = this.taskService.createTask("Registration " + this.sacs_moving[0].getSpimSource().getName() + " vs " + this.sacs_fixed[0].getSpimSource().getName());
            this.task.setProgressMaximum((long)pts_Fixed.size());
            innerTask = true;
        }
        try {
            Stream streamOfPts = this.parallel ? pts_Fixed.parallelStream() : pts_Fixed.stream();
            ConcurrentHashMap correspondingPts = new ConcurrentHashMap();
            this.counter.set(0);
            streamOfPts.forEach(pt -> {
                if (!this.task.isCanceled()) {
                    try {
                        AffineTransform3D at = (AffineTransform3D)((CommandModule)this.cs.run(Elastix2DAffineRegisterCommand.class, true, new Object[]{"sacs_fixed", this.sacs_fixed, "tp_fixed", this.tp_fixed, "level_fixed_source", this.level_fixed_source, "sacs_moving", this.sacs_moving, "tp_moving", this.tp_moving, "level_moving_source", this.level_moving_source, "px", pt.getDoublePosition(0) - this.sx / 2.0, "py", pt.getDoublePosition(1) - this.sy / 2.0, "pz", pt.getDoublePosition(2), "sx", this.sx, "sy", this.sy, "px_size_in_current_unit", this.px_size_in_current_unit, "interpolate", this.interpolate, "show_image_registration", this.show_points, "automatic_transform_initialization", false, "max_iteration_per_scale", this.max_iteration_per_scale, "background_offset_value_moving", this.background_offset_value_moving, "background_offset_value_fixed", this.background_offset_value_fixed, "min_image_size_pix", 32, "verbose", this.verbose}).get()).getOutput("at3d");
                        if (at != null) {
                            RealPoint ptCorr = new RealPoint(3);
                            at.apply((RealLocalizable)pt, (RealPositionable)ptCorr);
                            correspondingPts.put(pt, ptCorr);
                            String str = "xi =" + pt.getDoublePosition(0) + "\t xf =" + ptCorr.getDoublePosition(0) + "\n";
                            str = str + "yi =" + pt.getDoublePosition(1) + "\t yf =" + ptCorr.getDoublePosition(1);
                            this.log.accept("Registration point : " + str);
                        } else {
                            correspondingPts.put(pt, pt);
                            this.log.accept("Failed registration - maybe the image has low information content ?");
                        }
                        IJ.log((String)("#Landmark:" + this.counter.addAndGet(1) + "/" + pts_Fixed.size()));
                        Task task = this.task;
                        synchronized (task) {
                            this.task.setProgressValue(this.task.getProgressValue() + 1L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        logger.error("Error during registration");
                        e.printStackTrace();
                    }
                }
            });
            if (this.task.isCanceled()) {
                return;
            }
            double[][] ptI = new double[2][pts_Fixed.size()];
            double[][] ptF = new double[2][pts_Fixed.size()];
            for (int i = 0; i < pts_Fixed.size(); ++i) {
                ptF[0][i] = ((RealPoint)pts_Fixed.get(i)).getDoublePosition(0);
                ptF[1][i] = ((RealPoint)pts_Fixed.get(i)).getDoublePosition(1);
                ptI[0][i] = ((RealPoint)correspondingPts.get(pts_Fixed.get(i))).getDoublePosition(0);
                ptI[1][i] = ((RealPoint)correspondingPts.get(pts_Fixed.get(i))).getDoublePosition(1);
            }
            this.tst = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)new WrappedIterativeInvertibleRealTransform((RealTransform)new ThinplateSplineTransform(ptI, ptF)));
        }
        finally {
            if (innerTask) {
                this.task.finish();
            }
        }
    }
}

