/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source.register;

import ch.epfl.biop.scijava.command.source.register.AbstractElastix2DRegistrationInRectangleCommand;
import ch.epfl.biop.scijava.command.source.register.ElastixHelper;
import ch.epfl.biop.sourceandconverter.register.Elastix2DAffineRegister;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Fast;
import ch.epfl.biop.wrappers.elastix.RegisterHelper;
import ch.epfl.biop.wrappers.elastix.RegistrationParameters;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Obsolete>Register Sources with Elastix (Affine, 2D)", description="Performs an affine registration in 2D between 2 sources. Low level command which\nrequires many parameters. For more user friendly command, use wizards instead.\nOutputs the transform to apply to the moving source.")
public class Elastix2DAffineRegisterCommand
extends AbstractElastix2DRegistrationInRectangleCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(Elastix2DAffineRegisterCommand.class);
    @Parameter
    Context ctx;
    @Parameter(type=ItemIO.OUTPUT)
    boolean success;

    public void run() {
        RegistrationParameters rp;
        ElastixHelper.checkOrSetLocal(this.ctx);
        RegisterHelper rh = new RegisterHelper();
        if (this.verbose) {
            rh.verbose();
        }
        if (this.sacs_fixed.length > 1) {
            if (this.sacs_fixed.length == this.sacs_moving.length) {
                RegistrationParameters[] rps = new RegistrationParameters[this.sacs_fixed.length];
                for (int iCh = 0; iCh < this.sacs_fixed.length; ++iCh) {
                    rps[iCh] = this.getRegistrationParameters();
                }
                rp = RegistrationParameters.combineRegistrationParameters((RegistrationParameters[])rps);
            } else {
                System.err.println("Cannot perform multichannel registration : non identical number of channels between moving and fixed sources.");
                rp = this.getRegistrationParameters();
            }
        } else {
            rp = this.getRegistrationParameters();
        }
        rh.addTransform(rp);
        Elastix2DAffineRegister reg = new Elastix2DAffineRegister(this.sacs_fixed, this.level_fixed_source, this.tp_fixed, this.sacs_moving, this.level_moving_source, this.tp_moving, rh, this.px_size_in_current_unit, this.px, this.py, this.pz, this.sx, this.sy, this.background_offset_value_moving, this.background_offset_value_fixed, this.show_image_registration);
        reg.setInterpolate(this.interpolate);
        this.success = reg.run();
        if (this.success) {
            this.at3d = reg.getAffineTransform();
        } else {
            logger.error("Error during registration");
        }
    }

    private RegistrationParameters getRegistrationParameters() {
        RegParamAffine_Fast rp = new RegParamAffine_Fast();
        rp.AutomaticScalesEstimation = false;
        if (this.automatic_transform_initialization) {
            rp.AutomaticTransformInitialization = true;
            rp.AutomaticTransformInitializationMethod = "CenterOfGravity";
        } else {
            rp.AutomaticTransformInitialization = false;
        }
        double maxSize = Math.min(this.sx / this.px_size_in_current_unit, this.sy / this.px_size_in_current_unit);
        int nScales = 0;
        while (Math.pow(2.0, nScales) < maxSize) {
            ++nScales;
        }
        int nScalesSkipped = 0;
        while (Math.pow(2.0, nScalesSkipped) < (double)this.min_image_size_pix) {
            ++nScalesSkipped;
        }
        rp.NumberOfResolutions = Math.max(1, nScales - nScalesSkipped);
        rp.BSplineInterpolationOrder = 1;
        rp.MaximumNumberOfIterations = this.max_iteration_per_scale;
        rp.ImagePyramidSchedule = new Integer[2 * rp.NumberOfResolutions];
        for (int scale = 0; scale < rp.NumberOfResolutions; ++scale) {
            rp.ImagePyramidSchedule[2 * scale] = (int)Math.pow(2.0, rp.NumberOfResolutions - scale - 1);
            rp.ImagePyramidSchedule[2 * scale + 1] = (int)Math.pow(2.0, rp.NumberOfResolutions - scale - 1);
        }
        return rp;
    }
}

