/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.transform.SourceMosaicZSlicer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Slice Source")
public class SliceSourceCommand
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(SliceSourceCommand.class);
    @Parameter(label="BigDataViewer Frame")
    public BdvHandle bdv_h;
    @Parameter(required=false)
    SourceAndConverter[] sacs;
    @Parameter(label="Match bdv frame window size", persist=false, callback="matchXYBDVFrame")
    public boolean match_window_size = false;
    @Parameter(label="Total Size X (physical unit)", callback="matchXYBDVFrame", style="format:0.#####E0")
    public double x_size = 100.0;
    @Parameter(label="Total Size Y (physical unit)", callback="matchXYBDVFrame", style="format:0.#####E0")
    public double y_size = 100.0;
    @Parameter(label="Half Thickness Z (above and below, physical unit)", style="format:0.#####E0")
    public double z_size = 100.0;
    @Parameter(label="XY Pixel size sampling (physical unit)", callback="changePhysicalSampling", style="format:0.#####E0")
    public double sampling_xy_in_physical_unit = 1.0;
    @Parameter(label="Z Pixel size sampling (physical unit)", callback="changePhysicalSampling", style="format:0.#####E0")
    public double sampling_z_in_physical_unit = 1.0;
    @Parameter(label="Interpolate")
    public boolean interpolate = true;
    @Parameter(label="ReUseMipMaps")
    public boolean reusemipmaps = true;
    @Parameter(label="cache")
    public boolean cache = false;
    String unitOfFirstSource = " ";
    List<SourceAndConverter<?>> sourceList;
    AffineTransform3D at3D;
    public Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter = sacs1ist -> SliceSourceCommand.sortDefault(sacs1ist);

    public void run() {
        if (this.sacs == null || this.sacs.length == 0) {
            logger.info("No selected source. Abort command.");
            return;
        }
        this.sourceList = this.sorter.apply(Arrays.asList(this.sacs));
        SourceAndConverter model = this.createModelSource();
        List<SourceAndConverter> resampledSourceList = this.sourceList.stream().map(sac -> new SourceMosaicZSlicer((SourceAndConverter)sac, model, this.reusemipmaps, this.cache, this.interpolate, () -> 1L).get()).collect(Collectors.toList());
        resampledSourceList.forEach(sac -> SourceAndConverterServices.getSourceAndConverterService().register(sac));
        SourceAndConverterServices.getSourceAndConverterService().register(model);
        this.updateUnit();
    }

    private SourceAndConverter createModelSource() {
        this.at3D = new AffineTransform3D();
        this.bdv_h.getViewerPanel().state().getViewerTransform(this.at3D);
        double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
        double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
        this.at3D.translate(new double[]{-w / 2.0, -h / 2.0, 0.0});
        double xNorm = SliceSourceCommand.getNormTransform(0, this.at3D);
        this.at3D.scale(1.0 / xNorm);
        this.at3D.scale(1.0 / this.sampling_xy_in_physical_unit, 1.0 / this.sampling_xy_in_physical_unit, 1.0 / this.sampling_z_in_physical_unit);
        this.at3D.translate(new double[]{this.x_size / (2.0 * this.sampling_xy_in_physical_unit), this.y_size / (2.0 * this.sampling_xy_in_physical_unit), this.z_size / this.sampling_z_in_physical_unit});
        long nPx = (long)(this.x_size / this.sampling_xy_in_physical_unit);
        long nPy = (long)(this.y_size / this.sampling_xy_in_physical_unit);
        long nPz = this.sampling_z_in_physical_unit == 0.0 ? 1L : 1L + (long)(this.z_size / (this.sampling_z_in_physical_unit / 2.0));
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        return new EmptySourceAndConverterCreator("SlicerModel", this.at3D.inverse(), nPx, nPy, nPz).get();
    }

    public static double getNormTransform(int axis, AffineTransform3D t) {
        double f0 = t.get(axis, 0);
        double f1 = t.get(axis, 1);
        double f2 = t.get(axis, 2);
        return Math.sqrt(f0 * f0 + f1 * f1 + f2 * f2);
    }

    public static double distance(RealPoint pt1, RealPoint pt2) {
        assert (pt1.numDimensions() == pt2.numDimensions());
        double dsquared = 0.0;
        for (int i = 0; i < pt1.numDimensions(); ++i) {
            double diff = pt1.getDoublePosition(i) - pt2.getDoublePosition(i);
            dsquared += diff * diff;
        }
        return Math.sqrt(dsquared);
    }

    public void matchXYBDVFrame() {
        if (this.match_window_size) {
            double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
            double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
            RealPoint ptTopLeft = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, 0.0, (RealPositionable)ptTopLeft);
            RealPoint ptTopRight = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, w, (RealPositionable)ptTopRight);
            RealPoint ptBottomLeft = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(h, 0.0, (RealPositionable)ptBottomLeft);
            this.x_size = SliceSourceCommand.distance(ptTopLeft, ptTopRight);
            this.y_size = SliceSourceCommand.distance(ptTopLeft, ptBottomLeft);
        }
    }

    public void updateUnit() {
        if (this.sourceList.size() > 0 && this.sourceList.get(0) != null && this.sourceList.get(0).getSpimSource().getVoxelDimensions() != null) {
            this.unitOfFirstSource = this.sourceList.get(0).getSpimSource().getVoxelDimensions().unit();
        }
    }

    public static List<SourceAndConverter<?>> sortDefault(Collection<SourceAndConverter<?>> sacs) {
        ArrayList sortedList = new ArrayList(sacs.size());
        sortedList.addAll(sacs);
        Comparator sacComparator = (s1, s2) -> {
            SourceAndConverterService.SpimDataInfo sdi1 = null;
            SourceAndConverterService.SpimDataInfo sdi2 = null;
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(s1, "SPIMDATA") != null) {
                sdi1 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(s1, "SPIMDATA");
            }
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(s2, "SPIMDATA") != null) {
                sdi2 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(s2, "SPIMDATA");
            }
            if (sdi1 == null && sdi2 != null) {
                return -1;
            }
            if (sdi1 != null && sdi2 == null) {
                return 1;
            }
            if (sdi1 != null && sdi2 != null) {
                if (sdi1.asd == sdi2.asd) {
                    return sdi1.setupId - sdi2.setupId;
                }
                return sdi2.toString().compareTo(sdi1.toString());
            }
            return s2.getSpimSource().getName().compareTo(s1.getSpimSource().getName());
        };
        sortedList.sort(sacComparator);
        return sortedList;
    }
}

