/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.source;

import javax.swing.tree.DefaultMutableTreeNode;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Filter Sources Based on Name", description="Adds a node in the tree view which selects the sources based on their name")
public class FilterSourcesByNameCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Filter name")
    String filter_name;
    @Parameter(label="The source name should contain:")
    String string_filter;
    @Parameter(label="Match case")
    boolean match_case;
    @Parameter(label="Show sources")
    boolean show_sources;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        SourceFilterNode sfn = new SourceFilterNode(this.sac_service.getUI().getTreeModel(), this.filter_name, sac -> {
            if (this.match_case) {
                return sac.getSpimSource().getName().contains(this.string_filter);
            }
            return sac.getSpimSource().getName().toUpperCase().contains(this.string_filter.toUpperCase());
        }, this.show_sources);
        this.sac_service.getUI().addNode((DefaultMutableTreeNode)sfn);
    }
}

