/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.BdvOverlay;
import bdv.viewer.ViewerPanel;
import ch.epfl.biop.bdv.select.SourceSelectorOverlay;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.util.Behaviours;

public class RectangleSelectorOverlay
extends BdvOverlay {
    final ViewerPanel viewer;
    boolean isCurrentlySelecting = false;
    int xCurrentSelectStart;
    int yCurrentSelectStart;
    int xCurrentSelectEnd;
    int yCurrentSelectEnd;
    RealPoint ptStartGlobal;
    RealPoint ptEndGlobal;
    final RectangleSelectorBehaviour rsb;
    Map<String, SourceSelectorOverlay.OverlayStyle> styles = new HashMap<String, SourceSelectorOverlay.OverlayStyle>();
    RealPoint rpA;
    RealPoint rpB;
    RealPoint rpBprim;
    RealPoint rpC;
    RealPoint rpDprim;
    RealPoint rpD;
    RealPoint rpA_screen;
    RealPoint rpB_screen;
    RealPoint rpBprim_screen;
    RealPoint rpC_screen;
    RealPoint rpDprim_screen;
    RealPoint rpD_screen;
    Font font = new Font("Courier", 0, 20);
    boolean lastRectangleDrawn = false;

    public RectangleSelectorOverlay(ViewerPanel viewer, RectangleSelectorBehaviour rsb, String message) {
        this.rsb = rsb;
        this.viewer = viewer;
        this.styles.put("SELECTED", new SelectedOverlayStyle());
        this.ptStartGlobal = new RealPoint(3);
        this.ptEndGlobal = new RealPoint(3);
    }

    protected void addSelectionBehaviours(Behaviours behaviours) {
        behaviours.behaviour((Behaviour)new RectangleSelectSourcesBehaviour("SET"), "select-set-rectangle", new String[]{"button1"});
    }

    synchronized void startCurrentSelection(int x, int y) {
        this.xCurrentSelectStart = x;
        this.yCurrentSelectStart = y;
        this.viewer.displayToGlobalCoordinates((double)this.xCurrentSelectStart, (double)this.yCurrentSelectStart, (RealPositionable)this.ptStartGlobal);
    }

    synchronized void updateCurrentSelection(int xCurrent, int yCurrent) {
        this.xCurrentSelectEnd = xCurrent;
        this.yCurrentSelectEnd = yCurrent;
        this.isCurrentlySelecting = true;
        this.viewer.displayToGlobalCoordinates((double)this.xCurrentSelectEnd, (double)this.yCurrentSelectEnd, (RealPositionable)this.ptEndGlobal);
    }

    synchronized void endCurrentSelection(int x, int y, String mode) {
        this.xCurrentSelectEnd = x;
        this.yCurrentSelectEnd = y;
        this.isCurrentlySelecting = false;
        this.viewer.displayToGlobalCoordinates((double)this.xCurrentSelectEnd, (double)this.yCurrentSelectEnd, (RealPositionable)this.ptEndGlobal);
        this.rsb.processSelectionEvent(this.ptStartGlobal, this.ptEndGlobal);
    }

    Point2D[] getLastCorners() {
        Point2D[] corners = new Point2D.Double[]{new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double()};
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpA, (RealPositionable)this.rpA_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpB, (RealPositionable)this.rpB_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpBprim, (RealPositionable)this.rpBprim_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpC, (RealPositionable)this.rpC_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpDprim, (RealPositionable)this.rpDprim_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpD, (RealPositionable)this.rpD_screen);
        ((Point2D)corners[0]).setLocation(this.rpA_screen.getDoublePosition(0), this.rpA_screen.getDoublePosition(1));
        ((Point2D)corners[1]).setLocation(this.rpB_screen.getDoublePosition(0), this.rpB_screen.getDoublePosition(1));
        ((Point2D)corners[2]).setLocation(this.rpBprim_screen.getDoublePosition(0), this.rpBprim_screen.getDoublePosition(1));
        ((Point2D)corners[3]).setLocation(this.rpC_screen.getDoublePosition(0), this.rpC_screen.getDoublePosition(1));
        ((Point2D)corners[4]).setLocation(this.rpDprim_screen.getDoublePosition(0), this.rpDprim_screen.getDoublePosition(1));
        ((Point2D)corners[5]).setLocation(this.rpD_screen.getDoublePosition(0), this.rpD_screen.getDoublePosition(1));
        return corners;
    }

    Point2D[] getCurrentCorners(boolean ac_set) {
        if (!ac_set) {
            this.rpA = new RealPoint(3);
            this.rpC = new RealPoint(3);
        }
        this.rpB = new RealPoint(3);
        this.rpBprim = new RealPoint(3);
        this.rpDprim = new RealPoint(3);
        this.rpD = new RealPoint(3);
        this.rpA_screen = new RealPoint(3);
        this.rpB_screen = new RealPoint(3);
        this.rpBprim_screen = new RealPoint(3);
        this.rpC_screen = new RealPoint(3);
        this.rpDprim_screen = new RealPoint(3);
        this.rpD_screen = new RealPoint(3);
        if (!ac_set) {
            this.viewer.displayToGlobalCoordinates((double)this.xCurrentSelectStart, (double)this.yCurrentSelectStart, (RealPositionable)this.rpA);
            this.viewer.displayToGlobalCoordinates((double)this.xCurrentSelectEnd, (double)this.yCurrentSelectEnd, (RealPositionable)this.rpC);
        }
        this.rpB.setPosition(new double[]{this.rpA.getDoublePosition(0), this.rpC.getDoublePosition(1), this.rpA.getDoublePosition(2)});
        this.rpBprim.setPosition(new double[]{this.rpA.getDoublePosition(0), this.rpC.getDoublePosition(1), this.rpC.getDoublePosition(2)});
        this.rpDprim.setPosition(new double[]{this.rpC.getDoublePosition(0), this.rpA.getDoublePosition(1), this.rpC.getDoublePosition(2)});
        this.rpD.setPosition(new double[]{this.rpC.getDoublePosition(0), this.rpA.getDoublePosition(1), this.rpA.getDoublePosition(2)});
        Point2D[] corners = new Point2D.Double[]{new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double()};
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpA, (RealPositionable)this.rpA_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpB, (RealPositionable)this.rpB_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpBprim, (RealPositionable)this.rpBprim_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpC, (RealPositionable)this.rpC_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpDprim, (RealPositionable)this.rpDprim_screen);
        this.viewer.state().getViewerTransform().apply((RealLocalizable)this.rpD, (RealPositionable)this.rpD_screen);
        ((Point2D)corners[0]).setLocation(this.rpA_screen.getDoublePosition(0), this.rpA_screen.getDoublePosition(1));
        ((Point2D)corners[1]).setLocation(this.rpB_screen.getDoublePosition(0), this.rpB_screen.getDoublePosition(1));
        ((Point2D)corners[2]).setLocation(this.rpBprim_screen.getDoublePosition(0), this.rpBprim_screen.getDoublePosition(1));
        ((Point2D)corners[3]).setLocation(this.rpC_screen.getDoublePosition(0), this.rpC_screen.getDoublePosition(1));
        ((Point2D)corners[4]).setLocation(this.rpDprim_screen.getDoublePosition(0), this.rpDprim_screen.getDoublePosition(1));
        ((Point2D)corners[5]).setLocation(this.rpD_screen.getDoublePosition(0), this.rpD_screen.getDoublePosition(1));
        return corners;
    }

    public synchronized void draw(Graphics2D g) {
        g.setStroke(this.styles.get("SELECTED").getNormalStroke());
        g.setPaint(this.styles.get("SELECTED").getBackColor());
        g.setFont(this.font);
        if (this.isCurrentlySelecting) {
            Point2D[] corners = this.getCurrentCorners(false);
            g.drawLine((int)corners[0].getX(), (int)corners[0].getY(), (int)corners[1].getX(), (int)corners[1].getY());
            g.setStroke(this.styles.get("SELECTED").getIntersectionStroke());
            g.drawLine((int)corners[1].getX(), (int)corners[1].getY(), (int)corners[2].getX(), (int)corners[2].getY());
            g.setStroke(this.styles.get("SELECTED").getNormalStroke());
            g.drawLine((int)corners[2].getX(), (int)corners[2].getY(), (int)corners[3].getX(), (int)corners[3].getY());
            g.drawLine((int)corners[3].getX(), (int)corners[3].getY(), (int)corners[4].getX(), (int)corners[4].getY());
            g.setStroke(this.styles.get("SELECTED").getIntersectionStroke());
            g.drawLine((int)corners[4].getX(), (int)corners[4].getY(), (int)corners[5].getX(), (int)corners[5].getY());
            g.setStroke(this.styles.get("SELECTED").getNormalStroke());
            g.drawLine((int)corners[5].getX(), (int)corners[5].getY(), (int)corners[0].getX(), (int)corners[0].getY());
        } else if (this.lastRectangleDrawn) {
            Point2D[] corners = this.getLastCorners();
            g.drawLine((int)corners[0].getX(), (int)corners[0].getY(), (int)corners[1].getX(), (int)corners[1].getY());
            g.setStroke(this.styles.get("SELECTED").getIntersectionStroke());
            g.drawLine((int)corners[1].getX(), (int)corners[1].getY(), (int)corners[2].getX(), (int)corners[2].getY());
            g.setStroke(this.styles.get("SELECTED").getNormalStroke());
            g.drawLine((int)corners[2].getX(), (int)corners[2].getY(), (int)corners[3].getX(), (int)corners[3].getY());
            g.drawLine((int)corners[3].getX(), (int)corners[3].getY(), (int)corners[4].getX(), (int)corners[4].getY());
            g.setStroke(this.styles.get("SELECTED").getIntersectionStroke());
            g.drawLine((int)corners[4].getX(), (int)corners[4].getY(), (int)corners[5].getX(), (int)corners[5].getY());
            g.setStroke(this.styles.get("SELECTED").getNormalStroke());
            g.drawLine((int)corners[5].getX(), (int)corners[5].getY(), (int)corners[0].getX(), (int)corners[0].getY());
        }
    }

    public void drawLastRectangle() {
        this.lastRectangleDrawn = true;
    }

    public void removeLastRectangle() {
        this.lastRectangleDrawn = false;
    }

    public void setRectangle(RealPoint p1, RealPoint p2) {
        this.rpA = p1;
        this.rpC = p2;
        this.getCurrentCorners(true);
        this.rsb.processSelectionEvent(p1, p2);
        this.viewer.requestRepaint();
    }

    class RectangleSelectSourcesBehaviour
    implements DragBehaviour {
        final String mode;

        public RectangleSelectSourcesBehaviour(String mode) {
            this.mode = mode;
        }

        public void init(int x, int y) {
            RectangleSelectorOverlay.this.startCurrentSelection(x, y);
            RectangleSelectorOverlay.this.viewer.setCursor(new Cursor(1));
            switch (this.mode) {
                case "SET": {
                    RectangleSelectorOverlay.this.viewer.showMessage("Set Selection");
                }
            }
        }

        public void drag(int x, int y) {
            RectangleSelectorOverlay.this.updateCurrentSelection(x, y);
            RectangleSelectorOverlay.this.viewer.getDisplay().repaint();
        }

        public void end(int x, int y) {
            RectangleSelectorOverlay.this.endCurrentSelection(x, y, this.mode);
            RectangleSelectorOverlay.this.viewer.setCursor(new Cursor(0));
        }
    }

    public static class SelectedOverlayStyle
    implements SourceSelectorOverlay.OverlayStyle {
        Color backColor = new Color(16312227);
        Color frontColor = new Color(13104920);
        Color intersectionFillColor = new Color(817261056, true);
        Stroke normalStroke = new BasicStroke(3.0f);
        Stroke intersectionStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
        Color intersectionColor = Color.WHITE.darker();

        public Color getBackColor() {
            return this.backColor;
        }

        public Color getFrontColor() {
            return this.frontColor;
        }

        public Color getIntersectionColor() {
            return this.intersectionColor;
        }

        public Color getIntersectionFillColor() {
            return this.intersectionFillColor;
        }

        public Stroke getNormalStroke() {
            return this.normalStroke;
        }

        public Stroke getIntersectionStroke() {
            return this.intersectionStroke;
        }
    }
}

