/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvOverlaySource;
import bdv.viewer.ViewerPanel;
import ch.epfl.biop.bdv.gui.card.CardHelper;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorOverlay;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;

public class RectangleSelectorBehaviour {
    public static final String RECTANGLE_SELECTOR_MAP = "sources-selector";
    public static final String SET = "SET";
    final RectangleSelectorOverlay rectangleOverlay;
    BdvOverlaySource bos;
    final BdvHandle bdvh;
    final TriggerBehaviourBindings triggerbindings;
    final ViewerPanel viewer;
    final Behaviours behaviours;
    boolean isInstalled;
    final String userCardKey = "Rectangle Selection";
    boolean iniSplitPanelState;
    CardHelper.CardState iniCardState;
    JPanel pane;
    private boolean navigationEnabled = false;
    AffineTransform3D initialView;
    volatile boolean rectangleSelected = false;
    volatile RealPoint startPt = null;
    volatile RealPoint endPt = null;
    boolean userValidated = false;

    public RectangleSelectorBehaviour(BdvHandle bdvh, String message) {
        this(bdvh, message, null, null);
    }

    public RectangleSelectorBehaviour(BdvHandle bdvh, String message, RealPoint p1, RealPoint p2) {
        this.bdvh = bdvh;
        this.triggerbindings = bdvh.getTriggerbindings();
        this.viewer = bdvh.getViewerPanel();
        this.rectangleOverlay = new RectangleSelectorOverlay(this.viewer, this, message);
        this.behaviours = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[]{"bdv"});
        this.initialView = bdvh.getViewerPanel().state().getViewerTransform();
        JButton navigationButton = new JButton("Enable navigation");
        navigationButton.addActionListener(e -> {
            if (this.navigationEnabled) {
                this.triggerbindings.addBehaviourMap(RECTANGLE_SELECTOR_MAP, this.behaviours.getBehaviourMap());
                this.triggerbindings.addInputTriggerMap(RECTANGLE_SELECTOR_MAP, this.behaviours.getInputTriggerMap(), new String[]{"transform", "bdv"});
                bdvh.getKeybindings().addInputMap("blocking-source-selector_rectangle", new InputMap(), new String[]{"bdv", "navigation"});
                this.navigationEnabled = false;
                navigationButton.setText("Re-enable navigation");
            } else {
                this.triggerbindings.removeBehaviourMap(RECTANGLE_SELECTOR_MAP);
                this.triggerbindings.removeInputTriggerMap(RECTANGLE_SELECTOR_MAP);
                bdvh.getKeybindings().removeInputMap("blocking-source-selector");
                this.navigationEnabled = true;
                navigationButton.setText("Enable rectangle selection");
            }
        });
        JButton restoreInitialRectangle = null;
        if (p1 != null && p2 != null) {
            this.rectangleOverlay.setRectangle(p1, p2);
            restoreInitialRectangle = new JButton("Restore initial rectangle");
            restoreInitialRectangle.addActionListener(e -> this.rectangleOverlay.setRectangle(p1, p2));
        }
        JButton confirmationButton = new JButton("Confirm rectangle");
        confirmationButton.addActionListener(e -> {
            if (this.endPt != null) {
                this.userValidated = true;
            }
        });
        this.pane = restoreInitialRectangle == null ? RectangleSelectorBehaviour.box(false, new JLabel(message), RectangleSelectorBehaviour.box(false, navigationButton), confirmationButton) : RectangleSelectorBehaviour.box(false, new JLabel(message), RectangleSelectorBehaviour.box(false, navigationButton), restoreInitialRectangle, confirmationButton);
    }

    public static JPanel box(boolean alongX, JComponent ... components) {
        JPanel box = new JPanel();
        if (alongX) {
            box.setLayout(new GridLayout(1, components.length));
        } else {
            box.setLayout(new GridLayout(components.length, 1));
        }
        for (JComponent component : components) {
            box.add(component);
        }
        return box;
    }

    public RectangleSelectorOverlay getRectangleSelectorOverlay() {
        return this.rectangleOverlay;
    }

    public BdvHandle getBdvHandle() {
        return this.bdvh;
    }

    public synchronized void enable() {
        if (!this.isInstalled) {
            this.install();
        }
    }

    public synchronized void disable() {
        if (this.isInstalled) {
            this.uninstall();
        }
    }

    public synchronized boolean isEnabled() {
        return this.isInstalled;
    }

    public void remove() {
        this.disable();
    }

    synchronized void install() {
        this.isInstalled = true;
        this.rectangleOverlay.addSelectionBehaviours(this.behaviours);
        this.behaviours.behaviour((Behaviour)new ClickBehaviour(){

            public void click(int x, int y) {
                RectangleSelectorBehaviour.this.uninstall();
            }
        }, "cancel-set-rectangle", new String[]{"ESCAPE"});
        this.triggerbindings.addBehaviourMap(RECTANGLE_SELECTOR_MAP, this.behaviours.getBehaviourMap());
        this.triggerbindings.addInputTriggerMap(RECTANGLE_SELECTOR_MAP, this.behaviours.getInputTriggerMap(), new String[]{"transform", "bdv"});
        this.bdvh.getKeybindings().addInputMap("blocking-source-selector_rectangle", new InputMap(), new String[]{"bdv", "navigation"});
        this.bos = BdvFunctions.showOverlay((BdvOverlay)this.rectangleOverlay, (String)"Rectangle_Selector_Overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)this.bdvh));
        this.iniCardState = CardHelper.getCardState(this.bdvh);
        this.bdvh.getSplitPanel().setCollapsed(false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", false);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"Rectangle Selection", (JComponent)this.pane, (boolean)true);
    }

    public void addBehaviour(Behaviour behaviour, String behaviourName, String[] triggers) {
        this.behaviours.behaviour(behaviour, behaviourName, triggers);
    }

    synchronized void uninstall() {
        this.isInstalled = false;
        this.bos.removeFromBdv();
        this.triggerbindings.removeBehaviourMap(RECTANGLE_SELECTOR_MAP);
        this.triggerbindings.removeInputTriggerMap(RECTANGLE_SELECTOR_MAP);
        this.bdvh.getKeybindings().removeInputMap("blocking-source-selector");
        this.bdvh.getCardPanel().removeCard((Object)"Rectangle Selection");
        CardHelper.restoreCardState(this.bdvh, this.iniCardState);
    }

    void processSelectionEvent(RealPoint start, RealPoint end) {
        this.rectangleSelected = true;
        this.startPt = start;
        this.endPt = end;
    }

    public List<RealPoint> waitForSelection() {
        return this.waitForSelection(-1);
    }

    public List<RealPoint> waitForSelection(int timeOutInMs) {
        int totalTime = 0;
        while (!this.userValidated) {
            if (timeOutInMs > 0) {
                while (this.endPt == null && totalTime < timeOutInMs) {
                    try {
                        Thread.sleep(33L);
                        totalTime += 33;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                while (this.endPt == null) {
                    try {
                        Thread.sleep(33L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(33L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.endPt == null) continue;
            this.rectangleOverlay.drawLastRectangle();
        }
        this.rectangleOverlay.removeLastRectangle();
        if (this.endPt == null) {
            return null;
        }
        ArrayList<RealPoint> pts = new ArrayList<RealPoint>();
        pts.add(this.startPt);
        pts.add(this.endPt);
        this.startPt = null;
        this.endPt = null;
        return pts;
    }
}

