/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.BdvOverlay;
import bdv.viewer.ViewerPanel;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.PointsSelectorBehaviour;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.util.Behaviours;

public class PointsSelectorOverlay
extends BdvOverlay
implements MouseMotionListener {
    final ViewerPanel viewer;
    RealPoint currentPt;
    final PointsSelectorBehaviour psb;

    public PointsSelectorOverlay(ViewerPanel viewer, PointsSelectorBehaviour psb) {
        this.psb = psb;
        this.viewer = viewer;
        this.currentPt = new RealPoint(3);
    }

    protected void addSelectionBehaviours(Behaviours behaviours) {
        behaviours.behaviour((Behaviour)new AddGlobalPointBehaviour(this.viewer, this.psb), "add_point_global_hack", new String[]{"shift alt ctrl P"});
        behaviours.behaviour((Behaviour)new AddPointBehaviour("SET"), "add_point_display", new String[]{"button1"});
    }

    public synchronized void draw(Graphics2D g) {
        this.psb.getGraphicalHandles().forEach(gh -> gh.draw(g));
    }

    public void setCanvasSize(int width, int height) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.psb.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.psb.mouseMoved(e);
    }

    public static class AddGlobalPointBehaviour
    implements Behaviour {
        final ViewerPanel viewer;
        final PointsSelectorBehaviour psb;

        public AddGlobalPointBehaviour(ViewerPanel viewer, PointsSelectorBehaviour psb) {
            this.viewer = viewer;
            this.psb = psb;
        }

        public void addGlobalPoint(double x, double y, double z) {
            RealPoint ptGlobalCoordinates = new RealPoint(3);
            ptGlobalCoordinates.setPosition(x, 0);
            ptGlobalCoordinates.setPosition(y, 1);
            ptGlobalCoordinates.setPosition(z, 2);
            this.psb.addPoint(ptGlobalCoordinates);
            this.viewer.getDisplay().repaint();
        }
    }

    class AddPointBehaviour
    implements ClickBehaviour {
        final String mode;

        public AddPointBehaviour(String mode) {
            this.mode = mode;
        }

        public void click(int x, int y) {
            RealPoint ptGlobalCoordinates = new RealPoint(3);
            PointsSelectorOverlay.this.viewer.displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)ptGlobalCoordinates);
            PointsSelectorOverlay.this.viewer.getDisplay().repaint();
            PointsSelectorOverlay.this.psb.addPoint(ptGlobalCoordinates);
        }
    }
}

