/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvOverlaySource;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import ch.epfl.biop.bdv.gui.card.CardHelper;
import ch.epfl.biop.bdv.gui.graphicalhandle.CircleGraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.PointsSelectorOverlay;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;

public class PointsSelectorBehaviour
implements GraphicalHandleListener {
    public static final String POINTS_SELECTOR_MAP = "points-selector";
    final PointsSelectorOverlay pointsOverlay;
    BdvOverlaySource bos;
    final BdvHandle bdvh;
    final TriggerBehaviourBindings triggerbindings;
    final ViewerPanel viewer;
    final Behaviours behaviours;
    boolean isInstalled;
    JPanel pane;
    private boolean navigationEnabled = false;
    AffineTransform3D initialView;
    final String userCardKey = "Points Selection";
    final Function<RealPoint, GraphicalHandle> graphicalHandleSupplier;
    Map<RealPoint, GraphicalHandle> ptToGraphicalHandle = new ConcurrentHashMap<RealPoint, GraphicalHandle>();
    volatile boolean userDone = false;
    CardHelper.CardState iniCardState;
    private volatile List<RealPoint> points = new ArrayList<RealPoint>();
    public static Integer[] defaultLandmarkColor = new Integer[]{210, 220, 24, 224};

    public PointsSelectorBehaviour(BdvHandle bdvh, String message, Function<RealPoint, GraphicalHandle> graphicalHandleSupplier) {
        this.bdvh = bdvh;
        this.triggerbindings = bdvh.getTriggerbindings();
        this.viewer = bdvh.getViewerPanel();
        this.graphicalHandleSupplier = graphicalHandleSupplier == null ? coords -> new DefaultCircularHandle(() -> coords, (ViewerState)bdvh.getViewerPanel().state(), 20) : graphicalHandleSupplier;
        this.pointsOverlay = new PointsSelectorOverlay(this.viewer, this);
        this.behaviours = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[]{"bdv"});
        this.initialView = bdvh.getViewerPanel().state().getViewerTransform();
        JButton navigationButton = new JButton("Enable navigation");
        navigationButton.addActionListener(e -> {
            if (this.navigationEnabled) {
                this.ptToGraphicalHandle.values().forEach(graphicalHandle -> graphicalHandle.enable());
                this.triggerbindings.addBehaviourMap(POINTS_SELECTOR_MAP, this.behaviours.getBehaviourMap());
                this.triggerbindings.addInputTriggerMap(POINTS_SELECTOR_MAP, this.behaviours.getInputTriggerMap(), new String[]{"transform", "bdv"});
                bdvh.getKeybindings().addInputMap("blocking-source-selector_rectangle", new InputMap(), new String[]{"bdv", "navigation"});
                this.navigationEnabled = false;
                navigationButton.setText("Re-enable navigation");
            } else {
                this.ptToGraphicalHandle.values().forEach(graphicalHandle -> graphicalHandle.disable());
                this.triggerbindings.removeBehaviourMap(POINTS_SELECTOR_MAP);
                this.triggerbindings.removeInputTriggerMap(POINTS_SELECTOR_MAP);
                bdvh.getKeybindings().removeInputMap("blocking-source-selector");
                this.navigationEnabled = true;
                navigationButton.setText("Enable point selection");
            }
        });
        JButton confirmationButton = new JButton("Confirm points");
        confirmationButton.addActionListener(e -> {
            this.userDone = true;
        });
        JButton clearAllPointsButton = new JButton("Clear points");
        clearAllPointsButton.addActionListener(e -> this.clearPoints());
        this.pane = RectangleSelectorBehaviour.box(false, new JLabel(message), RectangleSelectorBehaviour.box(false, navigationButton), clearAllPointsButton, confirmationButton);
    }

    public PointsSelectorOverlay getPointsSelectorOverlay() {
        return this.pointsOverlay;
    }

    public BdvHandle getBdvHandle() {
        return this.bdvh;
    }

    public synchronized void enable() {
        if (!this.isInstalled) {
            this.install();
        }
    }

    public synchronized void disable() {
        if (this.isInstalled) {
            this.uninstall();
        }
    }

    public synchronized boolean isEnabled() {
        return this.isInstalled;
    }

    public void remove() {
        this.disable();
    }

    synchronized void install() {
        this.isInstalled = true;
        this.pointsOverlay.addSelectionBehaviours(this.behaviours);
        this.behaviours.behaviour((Behaviour)((ClickBehaviour)(x, y) -> {
            this.bos.removeFromBdv();
            this.uninstall();
            this.userDone = true;
        }), "cancel-set-points", new String[]{"ESCAPE"});
        this.triggerbindings.addBehaviourMap(POINTS_SELECTOR_MAP, this.behaviours.getBehaviourMap());
        this.triggerbindings.addInputTriggerMap(POINTS_SELECTOR_MAP, this.behaviours.getInputTriggerMap(), new String[]{"transform", "bdv"});
        this.bos = BdvFunctions.showOverlay((BdvOverlay)this.pointsOverlay, (String)"Point_Selector_Overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)this.bdvh));
        this.bdvh.getKeybindings().addInputMap("blocking-source-selector_points", new InputMap(), new String[]{"bdv", "navigation"});
        this.iniCardState = CardHelper.getCardState(this.bdvh);
        this.bdvh.getSplitPanel().setCollapsed(false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv groups card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv viewer modes card", false);
        this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", false);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"Points Selection", (JComponent)this.pane, (boolean)true);
        this.bdvh.getViewerPanel().getDisplay().addHandler((Object)this.pointsOverlay);
    }

    public void addBehaviour(Behaviour behaviour, String behaviourName, String[] triggers) {
        this.behaviours.behaviour(behaviour, behaviourName, triggers);
    }

    synchronized void uninstall() {
        this.isInstalled = false;
        this.bos.removeFromBdv();
        this.triggerbindings.removeBehaviourMap(POINTS_SELECTOR_MAP);
        this.triggerbindings.removeInputTriggerMap(POINTS_SELECTOR_MAP);
        this.bdvh.getKeybindings().removeInputMap("blocking-source-selector");
        this.bdvh.getCardPanel().removeCard((Object)"Points Selection");
        CardHelper.restoreCardState(this.bdvh, this.iniCardState);
        this.bdvh.getViewerPanel().getDisplay().removeHandler((Object)this.pointsOverlay);
    }

    void addPoint(final RealPoint newPt) {
        GraphicalHandle gh = this.graphicalHandleSupplier.apply(newPt);
        if (gh.getBehaviours() != null) {
            gh.getBehaviours().behaviour((Behaviour)new DragBehaviour(){

                public void init(int x, int y) {
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)newPt);
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().requestRepaint();
                }

                public void drag(int x, int y) {
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)newPt);
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().requestRepaint();
                }

                public void end(int x, int y) {
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)newPt);
                    PointsSelectorBehaviour.this.bdvh.getViewerPanel().requestRepaint();
                }
            }, "drag_point", new String[]{"button1"});
        }
        gh.addGraphicalHandleListener(this);
        this.ptToGraphicalHandle.put(newPt, gh);
        this.points.add(newPt);
    }

    public Collection<GraphicalHandle> getGraphicalHandles() {
        return this.ptToGraphicalHandle.values();
    }

    void clearPoints() {
        this.ptToGraphicalHandle.values().forEach(gh -> gh.removeGraphicalHandleListener(this));
        this.ptToGraphicalHandle.clear();
        this.points.clear();
        this.bdvh.getBdvHandle().getViewerPanel().requestRepaint();
    }

    public List<RealPoint> waitForSelection(int timeOutInMs) {
        int totalTime = 0;
        if (timeOutInMs > 0) {
            while (!this.isUserDone() && totalTime < timeOutInMs) {
                try {
                    Thread.sleep(33L);
                    totalTime += 33;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            while (!this.isUserDone()) {
                try {
                    Thread.sleep(33L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.userDone = false;
        return this.points;
    }

    private boolean isUserDone() {
        return this.userDone;
    }

    @Override
    public void disabled(GraphicalHandle gh) {
    }

    @Override
    public void enabled(GraphicalHandle gh) {
    }

    @Override
    public void hover_in(GraphicalHandle gh) {
    }

    @Override
    public void hover_out(GraphicalHandle gh) {
    }

    @Override
    public void created(GraphicalHandle gh) {
    }

    @Override
    public void removed(GraphicalHandle gh) {
    }

    public void mouseDragged(MouseEvent e) {
        this.ptToGraphicalHandle.values().forEach(gh -> gh.mouseDragged(e));
    }

    public void mouseMoved(MouseEvent e) {
        this.ptToGraphicalHandle.values().forEach(gh -> gh.mouseMoved(e));
    }

    public static class DefaultCircularHandle
    extends CircleGraphicalHandle {
        public DefaultCircularHandle(Supplier<RealPoint> globalCoord, ViewerState vState, int radius) {
            super(null, null, null, null, () -> {
                RealPoint pt = new RealPoint(3);
                vState.getViewerTransform().apply((RealLocalizable)globalCoord.get(), (RealPositionable)pt);
                return new Integer[]{(int)pt.getDoublePosition(0), (int)pt.getDoublePosition(1), 0};
            }, () -> {
                RealPoint pt = new RealPoint(3);
                vState.getViewerTransform().apply((RealLocalizable)globalCoord.get(), (RealPositionable)pt);
                double distZ = pt.getDoublePosition(2);
                if (Math.abs(distZ) < (double)radius) {
                    return (int)(4.0 + Math.sqrt((double)(radius * radius) - distZ * distZ));
                }
                return 4;
            }, () -> defaultLandmarkColor);
        }
    }
}

