/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.BdvHandle;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.BdvSourcesDemo;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import java.util.List;
import net.imagej.ImageJ;
import net.imglib2.RealPoint;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDV>Get Bdv User Rectangle")
public class GetUserRectangleCommand
implements Command {
    @Parameter
    BdvHandle bdvh;
    @Parameter
    String message_for_user;
    @Parameter(required=false)
    int time_out_in_ms = -1;
    @Parameter(type=ItemIO.BOTH, required=false)
    RealPoint p1;
    @Parameter(type=ItemIO.BOTH, required=false)
    RealPoint p2;

    public void run() {
        RectangleSelectorBehaviour rsb = new RectangleSelectorBehaviour(this.bdvh, this.message_for_user, this.p1, this.p2);
        rsb.install();
        List<RealPoint> pts = rsb.waitForSelection(this.time_out_in_ms);
        rsb.uninstall();
        this.p1 = pts.get(0);
        this.p2 = pts.get(1);
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        BdvHandle bdvh = BdvSourcesDemo.initAndShowSources();
        RealPoint pB = new RealPoint(3);
        pB.setPosition(new double[]{800.0, 500.0, 80.0});
        ij.command().run(GetUserRectangleCommand.class, true, new Object[]{"bdvh", bdvh, "time_out_in_ms", -1, "message_for_user", "Please select a rectangle and confirm your input", "p1", new RealPoint(3), "p2", pB});
    }
}

