/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.BdvHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.XYRectangleGraphicalHandle;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.BdvSourcesDemo;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.PointsSelectorBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.imagej.ImageJ;
import net.imglib2.RealPoint;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDV>Get Bdv User Points")
public class GetUserPointsCommand
implements Command {
    @Parameter(required=false)
    Function<RealPoint, GraphicalHandle> graphical_handle_supplier;
    @Parameter
    BdvHandle bdvh;
    @Parameter
    String message_for_user;
    @Parameter(required=false)
    int time_out_in_ms = -1;
    @Parameter(type=ItemIO.OUTPUT)
    List<RealPoint> pts = new ArrayList<RealPoint>();

    public void run() {
        PointsSelectorBehaviour psb = new PointsSelectorBehaviour(this.bdvh, this.message_for_user, this.graphical_handle_supplier);
        psb.install();
        this.pts = psb.waitForSelection(this.time_out_in_ms);
        psb.uninstall();
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        BdvHandle bdvh = BdvSourcesDemo.initAndShowSources();
        ij.command().run(GetUserPointsCommand.class, true, new Object[]{"bdvh", bdvh, "time_out_in_ms", -1, "message_for_user", "Select your point of interest", "graphical_handle_supplier", realPoint -> new XYRectangleGraphicalHandle(new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]), bdvh.getTriggerbindings(), UUID.randomUUID().toString(), bdvh.getViewerPanel().state(), () -> realPoint, () -> 60.0, () -> 35.0, () -> PointsSelectorBehaviour.defaultLandmarkColor)});
    }
}

