/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.boundingbox.TransformedRealBoxSelectionDialog;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDV>Get Bdv User Box")
public class BoxSelectorCommand
implements Command {
    @Parameter
    BdvHandle bdvh;
    @Parameter
    String message;
    @Parameter(style="format:0.#####E0")
    double xmin;
    @Parameter(style="format:0.#####E0")
    double xmax;
    @Parameter(style="format:0.#####E0")
    double ymin;
    @Parameter(style="format:0.#####E0")
    double ymax;
    @Parameter(style="format:0.#####E0")
    double zmin;
    @Parameter(style="format:0.#####E0")
    double zmax;
    @Parameter(style="format:0.#####E0")
    double xmin_ini = 1.2;
    @Parameter(style="format:0.#####E0")
    double xmax_ini = 0.8;
    @Parameter(style="format:0.#####E0")
    double ymin_ini = Math.PI * -2;
    @Parameter(style="format:0.#####E0")
    double ymax_ini = Math.PI * 2;
    @Parameter(style="format:0.#####E0")
    double zmin_ini = Math.PI * -4;
    @Parameter(style="format:0.#####E0")
    double zmax_ini = Math.PI * 4;
    @Parameter(type=ItemIO.OUTPUT)
    RealInterval interval;
    @Parameter(type=ItemIO.OUTPUT)
    Boolean result;

    public void run() {
        FinalRealInterval initialInterval = Intervals.createMinMaxReal((double[])new double[]{this.xmin_ini, this.ymin_ini, this.zmin_ini, this.xmax_ini, this.ymax_ini, this.zmax_ini});
        FinalRealInterval rangeInterval = Intervals.createMinMaxReal((double[])new double[]{this.xmin, this.ymin, this.zmin, this.xmax, this.ymax, this.zmax});
        TransformedRealBoxSelectionDialog.Result result = BdvFunctions.selectRealBox((Bdv)this.bdvh, (AffineTransform3D)new AffineTransform3D(), (RealInterval)initialInterval, (RealInterval)rangeInterval, (BoxSelectionOptions)BoxSelectionOptions.options().title(this.message));
        this.result = result.isValid();
        if (this.result.booleanValue()) {
            this.interval = result.getInterval();
        }
    }
}

