/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv.userdefinedregion;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.RectangleSelectorBehaviour;
import ij.IJ;
import ij.ImagePlus;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class BdvSourcesDemo {
    public static void main(String ... args) throws Exception {
        BdvHandle bdvh = BdvSourcesDemo.initAndShowSources();
        RectangleSelectorBehaviour rsb = new RectangleSelectorBehaviour(bdvh, "Please select a rectangle");
        rsb.install();
        rsb.waitForSelection(10000);
        rsb.uninstall();
    }

    public static BdvHandle initAndShowSources() throws Exception {
        ImagePlus imp = IJ.openImage((String)"src/test/resources/blobs.tif");
        Img blob = ImageJFunctions.wrapReal((ImagePlus)imp);
        SpimData sd = (SpimData)new XmlIoSpimData().load("src/test/resources/mri-stack.xml");
        BdvStackSource bss = (BdvStackSource)BdvFunctions.show((AbstractSpimData)sd).get(0);
        bss.setDisplayRange(0.0, 255.0);
        BdvHandle bdvh = bss.getBdvHandle();
        SourceAndConverterServices.getBdvDisplayService().registerBdvHandle(bdvh);
        AffineTransform3D m = new AffineTransform3D();
        m.rotate(0, 0.7853981633974483);
        m.translate(new double[]{256.0, 0.0, 0.0});
        BdvFunctions.show((RandomAccessibleInterval)blob, (String)"Blobs Rot X", (BdvOptions)BdvOptions.options().sourceTransform(m).addTo((Bdv)bdvh));
        m.identity();
        m.rotate(2, 0.7853981633974483);
        m.translate(new double[]{0.0, 256.0, 0.0});
        BdvFunctions.show((RandomAccessibleInterval)blob, (String)"Blobs Rot Z ", (BdvOptions)BdvOptions.options().sourceTransform(m).addTo((Bdv)bdvh));
        m.identity();
        m.rotate(2, 0.5235987755982988);
        m.rotate(0, 0.004363323129985824);
        m.translate(new double[]{312.0, 256.0, 0.0});
        BdvFunctions.show((RandomAccessibleInterval)blob, (String)"Blobs Rot Z Y ", (BdvOptions)BdvOptions.options().sourceTransform(m).addTo((Bdv)bdvh));
        m.identity();
        m.scale(0.75);
        m.translate(new double[]{150.0, 100.0, 0.0});
        bdvh.getViewerPanel().state().setViewerTransform(m);
        bdvh.getViewerPanel().requestRepaint();
        return bdvh;
    }
}

