/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.opener.OpenerHelper;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import ch.epfl.biop.bdv.select.ToggleListener;
import ch.epfl.biop.scijava.command.source.ExportToMultipleImagePlusCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;
import org.scijava.Context;
import org.scijava.cache.CacheService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.behaviour.EditorBehaviourUnInstaller;
import sc.fiji.bdvpg.behaviour.SourceAndConverterContextMenuClickBehaviour;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.command.source.BrightnessAdjusterCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;
import sc.fiji.bdvpg.viewers.ViewerOrthoSyncStarter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Display Sources On Grid")
public class OverviewerCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    public SourceAndConverter[] sacs;
    @Parameter
    int timepoint_begin;
    @Parameter
    int n_columns;
    @Parameter(label="Split by dataset entites, comma separated (channel, fileseries)")
    String entities_split = "";
    Map<String, Class<? extends Entity>> entityClasses = OpenerHelper.getEntities();
    int currentIndex = 0;
    AffineTransform3D currentAffineTransform = new AffineTransform3D();
    Map<SourceAndConverter<?>, SourceAndConverter<?>> transformedToOriginal = new HashMap();
    @Parameter
    Context ctx;
    public Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter = sacslist -> SourceAndConverterHelper.sortDefaultGeneric((Collection)sacslist);

    public void run() {
        ArrayList<Class<? extends Entity>> entSplit = new ArrayList<Class<? extends Entity>>();
        for (String entity : this.entities_split.split(",")) {
            String ent = entity.trim().toUpperCase();
            if (!this.entityClasses.containsKey(ent)) {
                System.err.println("Unrecognized entity class " + ent);
                continue;
            }
            System.out.println("Splitting by " + ent);
            entSplit.add(this.entityClasses.get(ent));
        }
        List<SourceAndConverter<?>> sourceList = this.sorter.apply(Arrays.asList(this.sacs));
        Map<SacProperties, List<SourceAndConverter>> sacClasses = sourceList.stream().collect(Collectors.groupingBy(sac -> {
            SacProperties props = new SacProperties((SourceAndConverter)sac);
            for (Class entityClass : entSplit) {
                props.splitByEntity(entityClass);
            }
            return props;
        }));
        Map<SourceAndConverter, List<SacProperties>> keySetSac = sacClasses.keySet().stream().collect(Collectors.groupingBy(p -> p.sac));
        List<SourceAndConverter<?>> sortedSacs = this.sorter.apply(keySetSac.keySet());
        ArrayList sacsToDisplay = new ArrayList();
        sortedSacs.forEach(sacKey -> {
            SacProperties sacPropsKey = (SacProperties)((List)keySetSac.get(sacKey)).get(0);
            for (Class entityClass : entSplit) {
                sacPropsKey.splitByEntity(entityClass);
            }
            AffineTransform3D location = sacPropsKey.location;
            int xPos = this.currentIndex % this.n_columns;
            int yPos = this.currentIndex / this.n_columns;
            this.currentAffineTransform.identity();
            this.currentAffineTransform.preConcatenate(location.inverse());
            AffineTransform3D translator = new AffineTransform3D();
            translator.translate(new double[]{xPos, yPos, 0.0});
            ++this.currentIndex;
            List<SourceAndConverter<?>> sacs = this.sorter.apply((Collection<SourceAndConverter<?>>)sacClasses.get(sacPropsKey));
            long nPixX = sacs.get(0).getSpimSource().getSource(this.timepoint_begin, 0).dimension(0);
            long nPixY = sacs.get(0).getSpimSource().getSource(this.timepoint_begin, 0).dimension(1);
            long nPixZ = sacs.get(0).getSpimSource().getSource(this.timepoint_begin, 0).dimension(2);
            long sizeMax = Math.max(nPixX, nPixY);
            sizeMax = Math.max(sizeMax, nPixZ);
            this.currentAffineTransform.scale(1.0 / (double)sizeMax, 1.0 / (double)sizeMax, 1.0 / (double)sizeMax);
            this.currentAffineTransform.translate(new double[]{xPos, yPos, 0.0});
            SourceAffineTransformer sat = new SourceAffineTransformer(null, this.currentAffineTransform);
            List transformedSacs = sacs.stream().map(sac -> {
                SourceAndConverter trSac = sat.apply(sac);
                this.transformedToOriginal.put((SourceAndConverter<?>)trSac, (SourceAndConverter<?>)sac);
                SourceAndConverterServices.getSourceAndConverterService().register(trSac);
                ConverterSetup csOrigin = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sac);
                ConverterSetup csDestination = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(trSac);
                csOrigin.setupChangeListeners().add(setup -> {
                    if (csDestination.getDisplayRangeMin() != setup.getDisplayRangeMin() || csDestination.getDisplayRangeMax() != setup.getDisplayRangeMax()) {
                        csDestination.setDisplayRange(setup.getDisplayRangeMin(), setup.getDisplayRangeMax());
                    }
                    if (csDestination.supportsColor() && csDestination.getColor().get() != setup.getColor().get()) {
                        csDestination.setColor(new ARGBType(setup.getColor().get()));
                    }
                });
                csDestination.setupChangeListeners().add(setup -> {
                    if (csOrigin.getDisplayRangeMin() != setup.getDisplayRangeMin() || csOrigin.getDisplayRangeMax() != setup.getDisplayRangeMax()) {
                        csOrigin.setDisplayRange(csOrigin.getDisplayRangeMin(), csOrigin.getDisplayRangeMax());
                    }
                    if (csOrigin.supportsColor() && csOrigin.getColor().get() != setup.getColor().get()) {
                        csOrigin.setColor(new ARGBType(setup.getColor().get()));
                    }
                });
                return trSac;
            }).collect(Collectors.toList());
            sacsToDisplay.addAll(transformedSacs);
        });
        BdvHandle bdvh = SourceAndConverterServices.getBdvDisplayService().getNewBdv();
        SourceAndConverterServices.getBdvDisplayService().show(bdvh, sacsToDisplay.toArray(new SourceAndConverter[0]));
        AffineTransform3D currentViewLocation = new AffineTransform3D();
        bdvh.getViewerPanel().state().getViewerTransform(currentViewLocation);
        currentViewLocation.set(0.0, 2, 3);
        bdvh.getViewerPanel().state().setViewerTransform(currentViewLocation);
        SourceSelectorBehaviour ssb = (SourceSelectorBehaviour)SourceAndConverterServices.getBdvDisplayService().getDisplayMetadata(bdvh, SourceSelectorBehaviour.class.getSimpleName());
        new EditorBehaviourUnInstaller(bdvh).run();
        this.addEditorBehaviours(bdvh, ssb);
        bdvh.getViewerPanel().setNumTimepoints(SourceAndConverterHelper.getMaxTimepoint((SourceAndConverter)this.sacs[0]));
        BdvHandleHelper.setBdvHandleCloseOperation((BdvHandle)bdvh, (CacheService)((CacheService)this.ctx.getService(CacheService.class)), (SourceAndConverterBdvDisplayService)SourceAndConverterServices.getBdvDisplayService(), (boolean)false, () -> {
            this.sacs = null;
            this.transformedToOriginal = null;
            ((ObjectService)this.ctx.getService(ObjectService.class)).removeObject((Object)bdvh);
        });
    }

    void addEditorBehaviours(final BdvHandle bdvh, final SourceSelectorBehaviour ssb) {
        final Behaviours editor = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]);
        editor.behaviour((Behaviour)new SourceAndConverterContextMenuClickBehaviour(bdvh, () -> ssb.getSelectedSources().stream().map(sac -> this.transformedToOriginal.get(sac)).collect(Collectors.toSet()), OverviewerCommand.getPopupActionsOnWrappedSource()), "Sources Context Menu", new String[]{"button3"});
        ssb.addToggleListener(new ToggleListener(){

            public void isEnabled() {
                bdvh.getViewerPanel().showMessage("Selection Mode Enable");
                bdvh.getViewerPanel().showMessage(ssb.getSelectedSources().size() + " sources selected");
                editor.install(bdvh.getTriggerbindings(), "sources-editor");
            }

            public void isDisabled() {
                bdvh.getViewerPanel().showMessage("Selection Mode Disable");
                bdvh.getTriggerbindings().removeInputTriggerMap("sources-editor");
                bdvh.getTriggerbindings().removeBehaviourMap("sources-editor");
            }
        });
    }

    public static String[] getPopupActionsOnWrappedSource() {
        String[] editorPopupActions = new String[]{"Inspect Sources", SourceAndConverterService.getCommandName(BrightnessAdjusterCommand.class), SourceAndConverterService.getCommandName(ExportToMultipleImagePlusCommand.class)};
        return editorPopupActions;
    }

    public static Entity getEntityFromSource(SourceAndConverter<?> source, Class<? extends Entity> entityClass) {
        if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(source, "SPIMDATA") != null) {
            SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(source, "SPIMDATA");
            AbstractSpimData asd = sdi.asd;
            BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(sdi.setupId);
            return bvs.getAttribute(entityClass);
        }
        return null;
    }

    public static boolean haveSameEntity(SourceAndConverter<?> s1, SourceAndConverter<?> s2, Class<? extends Entity> entityClass) {
        Entity s1Entity = OverviewerCommand.getEntityFromSource(s1, entityClass);
        Entity s2Entity = OverviewerCommand.getEntityFromSource(s2, entityClass);
        if (s1Entity == null && s2Entity == null) {
            return true;
        }
        if (s1Entity == null || s2Entity == null) {
            return false;
        }
        return s1Entity.equals((Object)s2Entity);
    }

    public static class SacProperties {
        public final AffineTransform3D location;
        public long[] dims = new long[3];
        public final SourceAndConverter sac;
        public final boolean isRGB;
        List<Class<? extends Entity>> entitiesSplit = new ArrayList<Class<? extends Entity>>();

        public SacProperties(SourceAndConverter sac) {
            this.location = new AffineTransform3D();
            sac.getSpimSource().getSourceTransform(0, 0, this.location);
            sac.getSpimSource().getSource(0, 0).dimensions(this.dims);
            this.sac = sac;
            this.isRGB = sac.getSpimSource().getType() instanceof ARGBType || sac.getSpimSource().getType() instanceof VolatileARGBType;
        }

        public SourceAndConverter getSource() {
            return this.sac;
        }

        public void splitByEntity(Class<? extends Entity> entityClass) {
            this.entitiesSplit.add(entityClass);
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (int)this.dims[0] + 17 * (int)this.dims[1] + 57 * (int)this.dims[2];
            return hash += (int)(10.0 * this.location.get(0, 0));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SacProperties) {
                SacProperties other = (SacProperties)obj;
                if (this.isRGB) {
                    return other.sac == this.sac;
                }
                if (ViewerOrthoSyncStarter.MatrixApproxEquals((double[])this.location.getRowPackedCopy(), (double[])other.location.getRowPackedCopy()) && this.dims[0] == other.dims[0] && this.dims[1] == other.dims[1] && this.dims[2] == other.dims[2]) {
                    for (Class<? extends Entity> entityClass : this.entitiesSplit) {
                        if (OverviewerCommand.haveSameEntity(other.sac, this.sac, entityClass)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

