/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv;

import bdv.tools.transformation.TransformedSource;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvStackSource;
import bdv.viewer.InteractiveDisplayCanvas;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.RayCastPositionerSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.SourceNavigatorSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.TimepointAdapterAdder;
import sc.fiji.bdvpg.bdv.overlay.SourceNameOverlayAdder;
import sc.fiji.bdvpg.bdv.supplier.BdvSupplierHelper;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.biop.BiopSerializableBdvOptions;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.BdvTransferHandler;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

public class GridBdvSupplier
implements IBdvSupplier {
    public final BiopSerializableBdvOptions sOptions;

    public GridBdvSupplier(BiopSerializableBdvOptions sOptions) {
        this.sOptions = sOptions;
    }

    public GridBdvSupplier() {
        this.sOptions = BiopSerializableBdvOptions.options();
    }

    public BdvHandle get() {
        BdvOptions options = this.sOptions.getBdvOptions();
        ArrayImg dummyImg = ArrayImgs.bytes((long[])new long[]{2L, 2L, 2L});
        options = options.sourceTransform(new AffineTransform3D());
        BdvStackSource bss = BdvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BdvOptions)options);
        BdvHandle bdvh = bss.getBdvHandle();
        if (this.sOptions.interpolate) {
            bdvh.getViewerPanel().setInterpolation(Interpolation.NLINEAR);
        }
        bdvh.getViewerPanel().state().removeSource(bdvh.getViewerPanel().state().getCurrentSource());
        bdvh.getViewerPanel().setNumTimepoints(this.sOptions.numTimePoints);
        SourceSelectorBehaviour ssb = BdvSupplierHelper.addEditorMode((BdvHandle)bdvh, (String)"");
        GridBdv gBdv = new GridBdv(bdvh, ssb, 1.0, 1.0);
        bdvh.getViewerPanel().setTransferHandler((TransferHandler)((Object)new GridTransferHandler(bdvh, gBdv)));
        bdvh.getSplitPanel().setCollapsed(false);
        JPanel editorModeToggle = new JPanel();
        JButton editorToggle = new JButton("Editor Mode");
        editorToggle.addActionListener(e -> {
            if (ssb.isEnabled()) {
                ssb.disable();
                editorToggle.setText("Editor Mode 'E'");
            } else {
                ssb.enable();
                editorToggle.setText("Navigation Mode 'E'");
            }
        });
        editorModeToggle.add(editorToggle);
        JButton nameToggle = new JButton("Display sources name");
        AtomicBoolean nameOverlayEnabled = new AtomicBoolean();
        nameOverlayEnabled.set(true);
        SourceNameOverlayAdder nameOverlayAdder = new SourceNameOverlayAdder(bdvh, new Font(this.sOptions.font, 0, this.sOptions.fontSize));
        nameToggle.addActionListener(e -> {
            if (nameOverlayEnabled.get()) {
                nameOverlayEnabled.set(false);
                nameToggle.setText("Display sources names");
                nameOverlayAdder.removeFromBdv();
            } else {
                nameOverlayEnabled.set(true);
                nameToggle.setText("Hide sources name");
                nameOverlayAdder.addToBdv();
            }
        });
        editorModeToggle.add(nameToggle);
        SwingUtilities.invokeLater(() -> {
            nameOverlayAdder.run();
            BdvHandleHelper.addCenterCross((BdvHandle)bdvh);
            new RayCastPositionerSliderAdder(bdvh).run();
            new SourceNavigatorSliderAdder(bdvh).run();
            new TimepointAdapterAdder(bdvh).run();
        });
        BdvHandleHelper.addCard((BdvHandle)bdvh, (String)"Mode", (JComponent)editorModeToggle, (boolean)true);
        return bdvh;
    }

    public static class GridBdv
    implements ViewerStateChangeListener {
        final BdvHandle bdvh;
        double gridSizeX;
        double gridSizeY;
        Map<SourceAndConverter<?>, CenterAndGridPosition> sourceToCenter = new ConcurrentHashMap();
        final SourceSelectorBehaviour ssb;

        public GridBdv(BdvHandle bdvh, SourceSelectorBehaviour ssb, double gridSizeX, double gridSizeY) {
            this.bdvh = bdvh;
            this.ssb = ssb;
            this.setGridSize(gridSizeX, gridSizeY);
            bdvh.getViewerPanel().state().changeListeners().add((Object)this);
            BdvHandleHelper.addCard((BdvHandle)bdvh, (String)"Grid Size", (JComponent)this.getGridSizeSelector(gridSizeX, gridSizeY), (boolean)true);
        }

        private JComponent getGridSizeSelector(double iniX, double iniY) {
            JTextField widthField = new JTextField(Double.toString(iniX), 5);
            JTextField heightField = new JTextField(Double.toString(iniY), 5);
            widthField.addActionListener(e -> {
                double width = Double.parseDouble(widthField.getText());
                double height = Double.parseDouble(heightField.getText());
                this.setGridSize(width, height);
            });
            heightField.addActionListener(e -> {
                double width = Double.parseDouble(widthField.getText());
                double height = Double.parseDouble(heightField.getText());
                this.setGridSize(width, height);
            });
            JButton increaseButton = new JButton("+");
            JButton decreaseButton = new JButton("-");
            DecimalFormat df = new DecimalFormat("0.000");
            increaseButton.addActionListener(e -> {
                double width = Double.parseDouble(widthField.getText());
                double height = Double.parseDouble(heightField.getText());
                widthField.setText(df.format(width *= 1.1));
                heightField.setText(df.format(height *= 1.1));
                this.setGridSize(width, height);
            });
            decreaseButton.addActionListener(e -> {
                double width = Double.parseDouble(widthField.getText());
                double height = Double.parseDouble(heightField.getText());
                widthField.setText(df.format(width /= 1.1));
                heightField.setText(df.format(height /= 1.1));
                this.setGridSize(width, height);
            });
            JLabel widthLabel = new JLabel("Width:");
            JLabel heightLabel = new JLabel("Height:");
            JPanel fieldPanel = new JPanel(new GridLayout(2, 2));
            fieldPanel.add(widthLabel);
            fieldPanel.add(widthField);
            fieldPanel.add(heightLabel);
            fieldPanel.add(heightField);
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.add(increaseButton);
            buttonPanel.add(decreaseButton);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)fieldPanel, "Center");
            mainPanel.add((Component)buttonPanel, "South");
            JPanel moveButton = new JPanel();
            JButton moveUp = new JButton("/\\");
            moveUp.addActionListener(e -> this.moveSelectedSources(0, -1));
            moveButton.add(moveUp);
            JButton moveDown = new JButton("\\/");
            moveDown.addActionListener(e -> this.moveSelectedSources(0, 1));
            moveButton.add(moveDown);
            JButton moveRight = new JButton(">");
            moveRight.addActionListener(e -> this.moveSelectedSources(1, 0));
            moveButton.add(moveRight);
            JButton moveLeft = new JButton("<");
            moveLeft.addActionListener(e -> this.moveSelectedSources(-1, 0));
            moveButton.add(moveLeft);
            mainPanel.add((Component)moveButton, "North");
            return mainPanel;
        }

        private void moveSelectedSources(int dx, int dy) {
            Set selectedSources = this.ssb.getSelectedSources();
            this.sourceToCenter.forEach((source, cpxy) -> {
                if (selectedSources.contains(source)) {
                    cpxy.px += (double)dx;
                    cpxy.py += (double)dy;
                }
            });
            this.updatePositions();
            this.bdvh.getViewerPanel().requestRepaint();
        }

        private void updatePositions() {
            this.sourceToCenter.forEach((source, cpxy) -> {
                AffineTransform3D transform3D = new AffineTransform3D();
                double[] coords = cpxy.center.positionAsDoubleArray();
                transform3D.translate(new double[]{-coords[0], -coords[1], -coords[2]});
                transform3D.translate(new double[]{cpxy.px * this.gridSizeX, cpxy.py * this.gridSizeY, 0.0});
                ((TransformedSource)source.getSpimSource()).setFixedTransform(transform3D);
            });
            this.bdvh.getViewerPanel().requestRepaint();
        }

        public synchronized void setGridSize(double gridSizeX, double gridSizeY) {
            if (gridSizeX != this.gridSizeX || gridSizeY != gridSizeY) {
                this.gridSizeX = gridSizeX;
                this.gridSizeY = gridSizeY;
                this.updatePositions();
            }
        }

        public double getGridX() {
            return this.gridSizeX;
        }

        public double getGridY() {
            return this.gridSizeY;
        }

        public synchronized void addSources(List<SourceAndConverter<?>> sacs, int px, int py) {
            RealPoint center = SourceAndConverterHelper.getSourceAndConverterCenterPoint(sacs.get(0), (int)0);
            AffineTransform3D transform3D = new AffineTransform3D();
            double[] coords = center.positionAsDoubleArray();
            transform3D.translate(new double[]{-coords[0], -coords[1], -coords[2]});
            transform3D.translate(new double[]{(double)px * this.gridSizeX, (double)py * this.gridSizeY, 0.0});
            SourceAffineTransformer sat = new SourceAffineTransformer(null, transform3D);
            for (SourceAndConverter<?> source : sacs) {
                SourceAndConverter transformed = sat.apply(source);
                this.sourceToCenter.put(transformed, new CenterAndGridPosition(center, px, py));
                SourceAndConverterServices.getBdvDisplayService().show(this.bdvh, new SourceAndConverter[]{transformed});
            }
        }

        public void viewerStateChanged(ViewerStateChange change) {
            switch (change) {
                default: 
            }
        }

        public static class CenterAndGridPosition {
            RealPoint center;
            double px;
            double py;

            public CenterAndGridPosition(RealPoint center, int px, int py) {
                this.center = center;
                this.px = px;
                this.py = py;
            }
        }
    }

    static class GridTransferHandler
    extends BdvTransferHandler {
        final BdvHandle bdvh;
        final GridBdv gBdv;
        int iX;
        int iY;

        public GridTransferHandler(BdvHandle bdvh, GridBdv gBdv) {
            this.bdvh = bdvh;
            this.gBdv = gBdv;
            BdvFunctions.showOverlay((BdvOverlay)new InnerOverlay(), (String)"DnD Grid Overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
        }

        public void updateDropLocation(TransferHandler.TransferSupport support, TransferHandler.DropLocation dl) {
            Point pt;
            RealPoint pt3d = new RealPoint(3);
            InteractiveDisplayCanvas display = this.bdvh.getViewerPanel().getDisplay();
            if (display != null && (pt = display.getMousePosition()) != null) {
                this.bdvh.getViewerPanel().displayToGlobalCoordinates(this.bdvh.getViewerPanel().getDisplay().getMousePosition().getX(), this.bdvh.getViewerPanel().getDisplay().getMousePosition().getY(), (RealPositionable)pt3d);
                this.iX = (int)Math.floor((pt3d.getDoublePosition(0) + 0.5) / this.gBdv.getGridX());
                this.iY = (int)Math.floor((pt3d.getDoublePosition(1) + 0.5) / this.gBdv.getGridY());
                this.bdvh.getViewerPanel().getDisplay().repaint();
            }
        }

        public void importSourcesAndConverters(TransferHandler.TransferSupport support, List<SourceAndConverter<?>> sacs) {
            Optional bdvh_local = this.getBdvHandleFromViewerPanel((ViewerPanel)support.getComponent());
            if (bdvh_local.isPresent()) {
                this.gBdv.addSources(sacs, this.iX, this.iY);
            }
        }

        private void drawDragAndDropRectangle(Graphics2D g, AffineTransform3D bdvAt3D) {
            int colorCode = ARGBType.rgba((int)120, (int)250, (int)50, (int)128);
            Color color = new Color(ARGBType.red((int)colorCode), ARGBType.green((int)colorCode), ARGBType.blue((int)colorCode), ARGBType.alpha((int)colorCode));
            g.setColor(color);
            RealPoint[][] ptRectWorld = new RealPoint[2][2];
            Point[][] ptRectScreen = new Point[2][2];
            double sX = this.gBdv.getGridX();
            double sY = this.gBdv.getGridY();
            for (int xp = 0; xp < 2; ++xp) {
                for (int yp = 0; yp < 2; ++yp) {
                    ptRectWorld[xp][yp] = new RealPoint(3);
                    RealPoint pt = ptRectWorld[xp][yp];
                    pt.setPosition(sX * ((double)this.iX - 0.5 + (double)xp), 0);
                    pt.setPosition(sY * ((double)this.iY - 0.5 + (double)yp), 1);
                    pt.setPosition(0, 2);
                    bdvAt3D.apply((RealLocalizable)pt, (RealPositionable)pt);
                    ptRectScreen[xp][yp] = new Point((int)pt.getDoublePosition(0), (int)pt.getDoublePosition(1));
                }
            }
            g.drawLine(ptRectScreen[0][0].x, ptRectScreen[0][0].y, ptRectScreen[1][0].x, ptRectScreen[1][0].y);
            g.drawLine(ptRectScreen[1][0].x, ptRectScreen[1][0].y, ptRectScreen[1][1].x, ptRectScreen[1][1].y);
            g.drawLine(ptRectScreen[1][1].x, ptRectScreen[1][1].y, ptRectScreen[0][1].x, ptRectScreen[0][1].y);
            g.drawLine(ptRectScreen[0][1].x, ptRectScreen[0][1].y, ptRectScreen[0][0].x, ptRectScreen[0][0].y);
            g.setColor(color);
        }

        class InnerOverlay
        extends BdvOverlay {
            final Color color = new Color(128, 112, 50, 200);
            final Stroke stroke = new BasicStroke(4.0f);

            InnerOverlay() {
            }

            protected void draw(Graphics2D g) {
                AffineTransform3D bdvAt3D = new AffineTransform3D();
                GridTransferHandler.this.bdvh.getViewerPanel().state().getViewerTransform(bdvAt3D);
                GridTransferHandler.this.drawDragAndDropRectangle(g, bdvAt3D);
                g.setColor(this.color);
                g.setStroke(this.stroke);
            }
        }
    }
}

