/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusSampler;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Export>Current BDV View To ImagePlus")
public class BdvViewToImagePlusExportCommand
implements BdvPlaygroundActionCommand {
    private static final Logger logger = LoggerFactory.getLogger(BdvViewToImagePlusExportCommand.class);
    @Parameter(label="BigDataViewer Frame")
    public BdvHandle bdv_h;
    @Parameter(label="Capture Name")
    String capturename = "Capture_00";
    @Parameter(required=false)
    SourceAndConverter[] sacs;
    @Parameter(label="Match bdv frame window size", persist=false, callback="matchXYBDVFrame")
    public boolean matchwindowsize = false;
    @Parameter(label="Total Size X (physical unit)", callback="matchXYBDVFrame", style="format:0.#####E0")
    public double xsize = 100.0;
    @Parameter(label="Total Size Y (physical unit)", callback="matchXYBDVFrame", style="format:0.#####E0")
    public double ysize = 100.0;
    @Parameter(label="Half Thickness Z (above and below, physical unit, 0 for a single slice)", style="format:0.#####E0")
    public double zsize = 100.0;
    @Parameter(label="Select Range", callback="updateMessage", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String range = "You can use commas or colons to separate ranges. eg. '1:10' or '1,3,5,8' ";
    @Parameter(label="Selected Timepoints. Leave blank for all", required=false)
    private String selected_timepoints_str = "";
    @Parameter(label="XY Pixel size sampling (physical unit)", callback="changePhysicalSampling", style="format:0.#####E0")
    public double samplingxyinphysicalunit = 1.0;
    @Parameter(label="Z Pixel size sampling (physical unit)", callback="changePhysicalSampling", style="format:0.#####E0")
    public double samplingzinphysicalunit = 1.0;
    @Parameter(label="Interpolate")
    boolean interpolate = true;
    @Parameter(label="Export mode", choices={"Normal", "Virtual", "Virtual no-cache"}, required=false)
    String export_mode = "Non virtual";
    @Parameter(label="Acquire channels in parallel (Normal only)", required=false)
    Boolean parallel_c = false;
    @Parameter(label="Acquire slices in parallel (Normal only)", required=false)
    Boolean parallel_z = false;
    @Parameter(label="Acquire timepoints in parallel (Normal only)", required=false)
    Boolean parallel_t = false;
    private Boolean monitor = true;
    @Parameter
    String unit = "px";
    @Parameter(type=ItemIO.OUTPUT)
    public List<ImagePlus> images;
    @Parameter
    TaskService taskService;

    public void run() {
        boolean virtual;
        if (this.sacs == null || this.sacs.length == 0) {
            logger.info("No selected source. Abort command.");
            return;
        }
        SourceAndConverter<?> model = this.createModelSource();
        boolean cacheImage = false;
        switch (this.export_mode) {
            case "Normal": {
                virtual = false;
                break;
            }
            case "Virtual": {
                virtual = true;
                cacheImage = true;
                break;
            }
            case "Virtual no-cache": {
                virtual = true;
                cacheImage = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized export mode " + this.export_mode);
            }
        }
        boolean cacheImageFinal = cacheImage;
        boolean virtualFinal = virtual;
        this.images = new ArrayList<ImagePlus>();
        ArrayList sourceList = new ArrayList();
        Arrays.asList(this.sacs).forEach(sac -> sourceList.add(sac));
        Map<Class, List<SourceAndConverter>> typeToSources = sourceList.stream().collect(Collectors.groupingBy(src -> src.getSpimSource().getType().getClass()));
        typeToSources.keySet().forEach(pixelType -> {
            try {
                if (pixelType.equals(ARGBType.class) || pixelType.equals(VolatileARGBType.class)) {
                    ((List)typeToSources.get(pixelType)).forEach(source -> {
                        Task task = null;
                        if (this.monitor.booleanValue()) {
                            task = this.taskService.createTask("Bdv View export:" + this.capturename);
                        }
                        try {
                            this.images.add(ImagePlusSampler.Builder().cache(cacheImageFinal).virtual(virtualFinal).unit(this.unit).monitor(task).title(this.capturename).parallelC(this.parallel_c).parallelZ(this.parallel_z).parallelT(this.parallel_t).setModel(model).interpolate(this.interpolate).rangeT(this.selected_timepoints_str).sources(new SourceAndConverter[]{source}).get());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    Task task = null;
                    if (this.monitor.booleanValue()) {
                        task = this.taskService.createTask("Bdv View export:" + this.capturename);
                    }
                    this.images.add(ImagePlusSampler.Builder().cache(cacheImageFinal).virtual(virtualFinal).unit(this.unit).monitor(task).title(this.capturename).setModel(model).parallelC(this.parallel_c).parallelZ(this.parallel_z).parallelT(this.parallel_t).interpolate(this.interpolate).rangeT(this.selected_timepoints_str).sources(((List)typeToSources.get(pixelType)).toArray(new SourceAndConverter[0])).get());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private SourceAndConverter<?> createModelSource() {
        AffineTransform3D at3D = new AffineTransform3D();
        this.bdv_h.getViewerPanel().state().getViewerTransform(at3D);
        double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
        double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
        at3D.translate(new double[]{-w / 2.0, -h / 2.0, 0.0});
        double xNorm = BdvViewToImagePlusExportCommand.getNormTransform(0, at3D);
        at3D.scale(1.0 / xNorm);
        at3D.scale(1.0 / this.samplingxyinphysicalunit, 1.0 / this.samplingxyinphysicalunit, 1.0 / this.samplingzinphysicalunit);
        at3D.translate(new double[]{this.xsize / (2.0 * this.samplingxyinphysicalunit), this.ysize / (2.0 * this.samplingxyinphysicalunit), this.zsize / this.samplingzinphysicalunit});
        long nPx = (long)(this.xsize / this.samplingxyinphysicalunit);
        long nPy = (long)(this.ysize / this.samplingxyinphysicalunit);
        long nPz = this.samplingzinphysicalunit == 0.0 ? 1L : 1L + (long)(this.zsize / (this.samplingzinphysicalunit / 2.0));
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        return new EmptySourceAndConverterCreator(this.capturename, at3D.inverse(), nPx, nPy, nPz).get();
    }

    public static double getNormTransform(int axis, AffineTransform3D t) {
        double f0 = t.get(axis, 0);
        double f1 = t.get(axis, 1);
        double f2 = t.get(axis, 2);
        return Math.sqrt(f0 * f0 + f1 * f1 + f2 * f2);
    }

    public static double distance(RealPoint pt1, RealPoint pt2) {
        assert (pt1.numDimensions() == pt2.numDimensions());
        double dsquared = 0.0;
        for (int i = 0; i < pt1.numDimensions(); ++i) {
            double diff = pt1.getDoublePosition(i) - pt2.getDoublePosition(i);
            dsquared += diff * diff;
        }
        return Math.sqrt(dsquared);
    }

    public void matchXYBDVFrame() {
        if (this.matchwindowsize) {
            double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
            double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
            RealPoint ptTopLeft = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, 0.0, (RealPositionable)ptTopLeft);
            RealPoint ptTopRight = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, w, (RealPositionable)ptTopRight);
            RealPoint ptBottomLeft = new RealPoint(3);
            this.bdv_h.getViewerPanel().displayToGlobalCoordinates(h, 0.0, (RealPositionable)ptBottomLeft);
            this.xsize = BdvViewToImagePlusExportCommand.distance(ptTopLeft, ptTopRight);
            this.ysize = BdvViewToImagePlusExportCommand.distance(ptTopLeft, ptBottomLeft);
        }
    }
}

