/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.bdv;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.scijava.command.bdv.BdvViewToImagePlusExportCommand;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusSampler;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Export>Current BDV View To ImagePlus (Basic)")
public class BasicBdvViewToImagePlusExportCommand<T extends RealType<T>>
implements BdvPlaygroundActionCommand {
    private static Logger logger = LoggerFactory.getLogger(BasicBdvViewToImagePlusExportCommand.class);
    @Parameter(label="BigDataViewer Frame")
    public BdvHandle bdv_h;
    @Parameter(label="Capture Name")
    String capturename = "Capture_00";
    @Parameter(label="Half Thickness Z (above and below, physical unit, 0 for a single slice)", style="format:0.#####E0")
    public double zsize = 100.0;
    @Parameter(label="Output pixel size (physical unit)", style="format:0.#####E0")
    public double samplingxyinphysicalunit = 1.0;
    @Parameter(label="Z Pixel size sampling (physical unit)", style="format:0.#####E0")
    public double samplingzinphysicalunit = 1.0;
    @Parameter(label="Interpolate")
    public boolean interpolate = true;
    @Parameter(label="Select Range", callback="updateMessage", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String range = "You can use commas or colons to separate ranges. eg. '0:10' or '0,2,4,6' ";
    @Parameter(label="Selected Timepoints. Leave blank for all", required=false)
    String selected_timepoints_str = "";
    @Parameter(label="Export mode", choices={"Normal", "Virtual", "Virtual no-cache"}, required=false)
    String export_mode = "Non virtual";
    @Parameter(label="Acquire channels in parallel (Normal only)", required=false)
    Boolean parallel_c = false;
    @Parameter(label="Acquire slices in parallel (Normal only)", required=false)
    Boolean parallel_z = false;
    @Parameter(label="Acquire timepoints in parallel (Normal only)", required=false)
    Boolean parallel_t = false;
    private Boolean monitor = true;
    @Parameter
    String unit = "px";
    @Parameter(type=ItemIO.OUTPUT)
    public List<ImagePlus> images;
    @Parameter
    TaskService taskService;
    double xSize;
    double ySize;

    public void run() {
        boolean virtual;
        if (this.bdv_h.getViewerPanel().state().getSources().size() == 0) {
            logger.info("No source present in Bdv. Abort command.");
            return;
        }
        List sourceList = this.bdv_h.getViewerPanel().state().getSources();
        sourceList = sourceList.stream().filter(source -> {
            if (source.getSpimSource() == null) {
                IJ.log((String)"Null source excluded");
                return false;
            }
            if (source.getSpimSource().getType() instanceof UnsignedShortType || source.getSpimSource().getType() instanceof UnsignedByteType || source.getSpimSource().getType() instanceof FloatType || source.getSpimSource().getType() instanceof ARGBType) {
                return true;
            }
            IJ.log((String)("Unsupported export for source " + source.getSpimSource().getName()));
            return false;
        }).collect(Collectors.toList());
        this.matchXYBDVFrame();
        SourceAndConverter<?> model = this.createModelSource();
        boolean cacheImage = false;
        switch (this.export_mode) {
            case "Normal": {
                virtual = false;
                break;
            }
            case "Virtual": {
                virtual = true;
                cacheImage = true;
                break;
            }
            case "Virtual no-cache": {
                virtual = true;
                cacheImage = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized export mode " + this.export_mode);
            }
        }
        boolean cacheImageFinal = cacheImage;
        boolean virtualFinal = virtual;
        this.images = new ArrayList<ImagePlus>();
        Map<Class, List<SourceAndConverter>> typeToSources = sourceList.stream().collect(Collectors.groupingBy(src -> src.getSpimSource().getType().getClass()));
        typeToSources.keySet().forEach(pixelType -> {
            try {
                if (pixelType.equals(ARGBType.class) || pixelType.equals(VolatileARGBType.class)) {
                    ((List)typeToSources.get(pixelType)).forEach(source -> {
                        Task task = null;
                        if (this.monitor.booleanValue()) {
                            task = this.taskService.createTask("Bdv View export:" + this.capturename);
                        }
                        try {
                            this.images.add(ImagePlusSampler.Builder().cache(cacheImageFinal).virtual(virtualFinal).unit(this.unit).monitor(task).title(this.capturename).setModel(model).parallelC(this.parallel_c).parallelZ(this.parallel_z).parallelT(this.parallel_t).interpolate(this.interpolate).rangeT(this.selected_timepoints_str).sources(new SourceAndConverter[]{source}).get());
                        }
                        catch (Exception e) {
                            if (task != null) {
                                task.cancel(e.getMessage());
                            }
                            e.printStackTrace();
                        }
                    });
                } else {
                    Task task = null;
                    if (this.monitor.booleanValue()) {
                        task = this.taskService.createTask("Bdv View export:" + this.capturename);
                    }
                    this.images.add(ImagePlusSampler.Builder().cache(cacheImageFinal).virtual(virtualFinal).unit(this.unit).monitor(task).title(this.capturename).setModel(model).parallelC(this.parallel_c).parallelZ(this.parallel_z).parallelT(this.parallel_t).interpolate(this.interpolate).rangeT(this.selected_timepoints_str).sources(((List)typeToSources.get(pixelType)).toArray(new SourceAndConverter[0])).get());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private SourceAndConverter<?> createModelSource() {
        AffineTransform3D at3D = new AffineTransform3D();
        this.bdv_h.getViewerPanel().state().getViewerTransform(at3D);
        double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
        double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
        at3D.translate(new double[]{-w / 2.0, -h / 2.0, 0.0});
        double xNorm = BdvViewToImagePlusExportCommand.getNormTransform(0, at3D);
        at3D.scale(1.0 / xNorm);
        at3D.scale(1.0 / this.samplingxyinphysicalunit, 1.0 / this.samplingxyinphysicalunit, 1.0 / this.samplingzinphysicalunit);
        at3D.translate(new double[]{this.xSize / (2.0 * this.samplingxyinphysicalunit), this.ySize / (2.0 * this.samplingxyinphysicalunit), this.zsize / this.samplingzinphysicalunit});
        long nPx = (long)(this.xSize / this.samplingxyinphysicalunit);
        long nPy = (long)(this.ySize / this.samplingxyinphysicalunit);
        long nPz = this.samplingzinphysicalunit == 0.0 ? 1L : 1L + (long)(this.zsize / (this.samplingzinphysicalunit / 2.0));
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        return new EmptySourceAndConverterCreator(this.capturename, at3D.inverse(), nPx, nPy, nPz).get();
    }

    public void matchXYBDVFrame() {
        double w = this.bdv_h.getViewerPanel().getDisplay().getWidth();
        double h = this.bdv_h.getViewerPanel().getDisplay().getHeight();
        RealPoint ptTopLeft = new RealPoint(3);
        this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, 0.0, (RealPositionable)ptTopLeft);
        RealPoint ptTopRight = new RealPoint(3);
        this.bdv_h.getViewerPanel().displayToGlobalCoordinates(0.0, w, (RealPositionable)ptTopRight);
        RealPoint ptBottomLeft = new RealPoint(3);
        this.bdv_h.getViewerPanel().displayToGlobalCoordinates(h, 0.0, (RealPositionable)ptBottomLeft);
        this.xSize = BdvViewToImagePlusExportCommand.distance(ptTopLeft, ptTopRight);
        this.ySize = BdvViewToImagePlusExportCommand.distance(ptTopLeft, ptBottomLeft);
    }
}

