/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.sourceandconverter.spline;

import bdv.util.BoundedRealTransform;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.registration.sourceandconverter.SourceAndConverterRegistration;
import java.util.ArrayList;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.persist.ScijavaGsonHelper;

public abstract class RealTransformSourceAndConverterRegistration
extends SourceAndConverterRegistration {
    static final Logger logger = LoggerFactory.getLogger(RealTransformSourceAndConverterRegistration.class);
    protected RealTransform rt;

    @Override
    public SourceAndConverter[] getTransformedImageMovingToFixed(SourceAndConverter[] img) {
        SourceAndConverter[] out = new SourceAndConverter[img.length];
        SourceRealTransformer srt = new SourceRealTransformer(this.rt);
        for (int idx = 0; idx < img.length; ++idx) {
            out[idx] = srt.apply(img[idx]);
        }
        return out;
    }

    @Override
    public RealPointList getTransformedPtsFixedToMoving(RealPointList pts) {
        RealTransform innerRT = this.rt;
        if (this.rt instanceof BoundedRealTransform) {
            innerRT = ((BoundedRealTransform)this.rt).getTransform().copy();
        }
        ArrayList<RealPoint> cvtList = new ArrayList<RealPoint>();
        for (RealPoint p : pts.ptList) {
            RealPoint pt3d = new RealPoint(3);
            pt3d.setPosition(new double[]{p.getDoublePosition(0), p.getDoublePosition(1), 0.0});
            innerRT.apply((RealLocalizable)pt3d, (RealPositionable)pt3d);
            RealPoint cpt = new RealPoint(new double[]{pt3d.getDoublePosition(0), pt3d.getDoublePosition(1)});
            cvtList.add(cpt);
        }
        return new RealPointList(cvtList);
    }

    public RealTransform getRealTransform() {
        return this.rt;
    }

    public void setRealTransform(RealTransform transform) {
        this.rt = transform.copy();
    }

    @Override
    public final String getTransform() {
        String transform = ScijavaGsonHelper.getGson((Context)this.context).toJson((Object)this.rt, RealTransform.class);
        return transform;
    }

    @Override
    public final void setTransform(String serialized_transform) {
        this.setRealTransform((RealTransform)ScijavaGsonHelper.getGson((Context)this.context).fromJson(serialized_transform, RealTransform.class));
        this.isDone = true;
    }

    @Override
    public RealTransform getTransformAsRealTransform() {
        return this.rt.copy();
    }
}

