/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.sourceandconverter.spline;

import bdv.util.BdvHandle;
import bdv.util.RealTransformHelper;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.plugin.IRegistrationPlugin;
import ch.epfl.biop.registration.plugin.RegistrationTypeProperties;
import ch.epfl.biop.registration.sourceandconverter.spline.RealTransformSourceAndConverterRegistration;
import ch.epfl.biop.scijava.command.source.register.Elastix2DSplineRegisterCommand;
import ij.gui.WaitForUserDialog;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinPlateSplineTransformAdapter;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.IntegerType;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;

@Plugin(type=IRegistrationPlugin.class)
@RegistrationTypeProperties(isManual=false, isEditable=true)
public class Elastix2DSplineRegistration
extends RealTransformSourceAndConverterRegistration {
    protected static final Logger logger = LoggerFactory.getLogger(Elastix2DSplineRegistration.class);
    Future<CommandModule> task;
    String errorMessage = "";
    Runnable waitForUser = () -> {
        WaitForUserDialog dialog = new WaitForUserDialog("Choose slice", "Please perform carefully your registration then press ok.");
        dialog.show();
    };
    BigWarpLauncher bwl;

    @Override
    public void setFixedImage(SourceAndConverter[] fimg) {
        if (fimg.length == 0) {
            logger.error("Error, no fixed image set in class " + this.getClass().getSimpleName());
        }
        super.setFixedImage(fimg);
    }

    @Override
    public void setMovingImage(SourceAndConverter[] mimg) {
        if (mimg.length == 0) {
            logger.error("Error, no fixed image set in class " + this.getClass().getSimpleName());
        }
        super.setMovingImage(mimg);
    }

    @Override
    public boolean register() {
        try {
            boolean success = true;
            Class<Elastix2DSplineRegisterCommand> registrationCommandClass = Elastix2DSplineRegisterCommand.class;
            ArrayList<Object> flatParameters = new ArrayList<Object>(this.parameters.size() * 2 + 4);
            double voxSizeInMm = Double.parseDouble((String)this.parameters.get("px_size_in_current_unit"));
            this.parameters.keySet().forEach(k -> {
                flatParameters.add(k);
                flatParameters.add(this.parameters.get(k));
            });
            Elastix2DSplineRegistration.addToFlatParameters(flatParameters, "sacs_fixed", this.fimg, "sacs_moving", this.mimg, "interpolate", true, "min_image_size_pix", 32, "max_iteration_per_scale", 100, "verbose", false, "automatic_transform_initialization", false, "tp_fixed", 0, "level_fixed_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.fimg[0], (int)this.timePoint, (double)voxSizeInMm), "tp_moving", this.timePoint, "level_moving_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.mimg[0], (int)this.timePoint, (double)voxSizeInMm));
            this.task = ((CommandService)this.context.getService(CommandService.class)).run(registrationCommandClass, false, flatParameters.toArray(new Object[0]));
            try {
                CommandModule module = this.task.get();
                if (module.getOutputs().containsKey("success")) {
                    success = (Boolean)module.getOutput("success");
                }
                if (success) {
                    this.rt = (RealTransform)module.getOutput("rt");
                    this.rt = this.pruneLandMarksOutsideAtlas(this.rt);
                } else if (module.getOutputs().containsKey("error")) {
                    this.errorMessage = (String)module.getOutput("error");
                }
                this.isDone = true;
                return success;
            }
            catch (Exception e) {
                this.isDone = true;
                this.errorMessage = e.getMessage();
                return success;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getExceptionMessage() {
        return this.errorMessage;
    }

    private RealTransform pruneLandMarksOutsideAtlas(RealTransform rt_in) {
        RealTransform input = rt_in;
        boolean wrapped2d3d = false;
        boolean wrappedInvertible = false;
        if (rt_in instanceof Wrapped2DTransformAs3D) {
            rt_in = ((Wrapped2DTransformAs3D)rt_in).transform;
            wrapped2d3d = true;
        }
        if (rt_in instanceof WrappedIterativeInvertibleRealTransform) {
            rt_in = ((WrappedIterativeInvertibleRealTransform)rt_in).getTransform();
            wrappedInvertible = true;
        }
        if (!(rt_in instanceof ThinplateSplineTransform)) {
            System.err.println("Cannot edit the transform : it's not of class thinplatesplinetransform");
            return input;
        }
        if (this.fimg_mask != null) {
            RealRandomAccessible rawMask;
            ThinplateSplineTransform tst = (ThinplateSplineTransform)rt_in;
            ThinPlateR2LogRSplineKernelTransform kernel = ThinPlateSplineTransformAdapter.getKernel((ThinplateSplineTransform)tst);
            double[][] srcPts = ThinPlateSplineTransformAdapter.getSrcPts((ThinPlateR2LogRSplineKernelTransform)kernel);
            double[][] tgtPts = ThinPlateSplineTransformAdapter.getTgtPts((ThinPlateR2LogRSplineKernelTransform)kernel);
            int nbLandmarks = kernel.getNumLandmarks();
            int nbDimensions = kernel.getNumDims();
            ArrayList<RealPoint> ptsSource = new ArrayList<RealPoint>();
            ArrayList<RealPoint> ptsTarget = new ArrayList<RealPoint>();
            for (int i = 0; i < nbLandmarks; ++i) {
                int d;
                RealPoint ptSource = new RealPoint(3);
                RealPoint ptTarget = new RealPoint(3);
                for (d = 0; d < nbDimensions; ++d) {
                    ptTarget.setPosition(tgtPts[d][i], d);
                }
                ptTarget.setPosition(0, 2);
                for (d = 0; d < nbDimensions; ++d) {
                    ptSource.setPosition(srcPts[d][i], d);
                }
                ptSource.setPosition(0, 2);
                ptsSource.add(ptSource);
                ptsTarget.add(ptTarget);
            }
            RealRandomAccessible mask = rawMask = this.fimg_mask[0].getSpimSource().getInterpolatedSource(this.timePoint, 0, Interpolation.NEARESTNEIGHBOR);
            AffineTransform3D at3D = new AffineTransform3D();
            this.fimg_mask[0].getSpimSource().getSourceTransform(this.timePoint, 0, at3D);
            ArrayList<Integer> landMarksToKeep = new ArrayList<Integer>();
            for (int i = 0; i < nbLandmarks; ++i) {
                at3D.inverse().apply((RealLocalizable)ptsTarget.get(i), (RealPositionable)ptsTarget.get(i));
                at3D.inverse().apply((RealLocalizable)ptsSource.get(i), (RealPositionable)ptsSource.get(i));
                if (((IntegerType)mask.getAt((RealLocalizable)ptsSource.get(i))).getInteger() == 0 && ((IntegerType)mask.getAt((RealLocalizable)ptsTarget.get(i))).getInteger() == 0) continue;
                landMarksToKeep.add(i);
            }
            if (landMarksToKeep.size() < 4) {
                System.err.println("Too few landmarks after pruning - skip pruning");
                return input;
            }
            double[][] srcPtsKept = new double[nbDimensions][landMarksToKeep.size()];
            double[][] tgtPtsKept = new double[nbDimensions][landMarksToKeep.size()];
            for (int i = 0; i < landMarksToKeep.size(); ++i) {
                for (int d = 0; d < nbDimensions; ++d) {
                    srcPtsKept[d][i] = srcPts[d][(Integer)landMarksToKeep.get(i)];
                    tgtPtsKept[d][i] = tgtPts[d][(Integer)landMarksToKeep.get(i)];
                }
            }
            ThinplateSplineTransform pruned = new ThinplateSplineTransform(srcPtsKept, tgtPtsKept);
            if (wrappedInvertible) {
                pruned = new WrappedIterativeInvertibleRealTransform((RealTransform)pruned);
            }
            if (wrapped2d3d) {
                pruned = new Wrapped2DTransformAs3D((RealTransform)((InvertibleRealTransform)pruned));
            }
            return pruned;
        }
        return input;
    }

    @Override
    public boolean edit() {
        try {
            EventQueue.invokeAndWait(() -> {
                List movingSacs = Arrays.stream(this.mimg).collect(Collectors.toList());
                List fixedSacs = Arrays.stream(this.fimg).collect(Collectors.toList());
                List converterSetups = Arrays.stream(this.mimg).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList());
                converterSetups.addAll(Arrays.stream(this.fimg).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList()));
                this.bwl = new BigWarpLauncher(movingSacs, fixedSacs, "Big Warp", converterSetups);
                this.bwl.set2d();
                this.bwl.run();
                BdvHandle bdvhQ = this.bwl.getBdvHandleQ();
                BdvHandle bdvhP = this.bwl.getBdvHandleP();
                bdvhP.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhP, (double[])new double[]{0.0, 0.0, 0.0}));
                bdvhQ.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhQ, (double[])new double[]{0.0, 0.0, 0.0}));
                bdvhQ.getViewerPanel().state().setDisplayMode(DisplayMode.FUSED);
                bdvhP.getViewerPanel().state().setDisplayMode(DisplayMode.FUSED);
                SourceAndConverterServices.getBdvDisplayService().pairClosing(bdvhQ, bdvhP);
                bdvhP.getViewerPanel().requestRepaint();
                bdvhQ.getViewerPanel().requestRepaint();
                this.bwl.getBigWarp().getLandmarkFrame().repaint();
                if (this.rt != null) {
                    this.bwl.getBigWarp().loadLandmarks(RealTransformHelper.BigWarpFileFromRealTransform(this.rt));
                    this.bwl.getBigWarp().setIsMovingDisplayTransformed(true);
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.waitForUser.run();
        this.rt = this.bwl.getBigWarp().getBwTransform().getTransformation();
        this.bwl.getBigWarp().closeAll();
        this.isDone = true;
        return true;
    }

    @Override
    public void abort() {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public String toString() {
        return "Elastix 2D Spline";
    }
}

