/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.sourceandconverter.bigwarp;

import bdv.util.BdvHandle;
import bdv.util.RealTransformHelper;
import bdv.viewer.DisplayMode;
import ch.epfl.biop.registration.plugin.IRegistrationPlugin;
import ch.epfl.biop.registration.plugin.RegistrationTypeProperties;
import ch.epfl.biop.registration.sourceandconverter.spline.RealTransformSourceAndConverterRegistration;
import ij.gui.WaitForUserDialog;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;

@Plugin(type=IRegistrationPlugin.class)
@RegistrationTypeProperties(isManual=true, isEditable=true)
public class SacBigWarp2DRegistration
extends RealTransformSourceAndConverterRegistration {
    BigWarpLauncher bwl;
    Runnable waitForUser = () -> {
        WaitForUserDialog dialog = new WaitForUserDialog("Big Warp registration", "Please perform carefully your registration then press ok. Do not forget to press 't' when 4 landmarks are placed.");
        dialog.show();
    };

    public void setWaitForUserMethod(Runnable r) {
        this.waitForUser = r;
    }

    @Override
    public boolean register() {
        try {
            EventQueue.invokeAndWait(() -> {
                String bigWarpFile;
                List movingSacs = Arrays.stream(this.mimg).collect(Collectors.toList());
                List fixedSacs = Arrays.stream(this.fimg).collect(Collectors.toList());
                List converterSetups = Arrays.stream(this.mimg).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList());
                converterSetups.addAll(Arrays.stream(this.fimg).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList()));
                this.bwl = new BigWarpLauncher(movingSacs, fixedSacs, "Big Warp", converterSetups);
                this.bwl.set2d();
                this.bwl.run();
                BdvHandle bdvhQ = this.bwl.getBdvHandleQ();
                BdvHandle bdvhP = this.bwl.getBdvHandleP();
                bdvhQ.getViewerPanel().state().setDisplayMode(DisplayMode.FUSED);
                bdvhP.getViewerPanel().state().setDisplayMode(DisplayMode.FUSED);
                bdvhP.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhP, (double[])new double[]{0.0, 0.0, 0.0}));
                bdvhQ.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhQ, (double[])new double[]{0.0, 0.0, 0.0}));
                SourceAndConverterServices.getBdvDisplayService().pairClosing(bdvhQ, bdvhP);
                bdvhP.getViewerPanel().requestRepaint();
                bdvhQ.getViewerPanel().requestRepaint();
                this.bwl.getBigWarp().getLandmarkFrame().repaint();
                if (this.rt != null && (bigWarpFile = RealTransformHelper.BigWarpFileFromRealTransform(this.rt)) != null) {
                    this.bwl.getBigWarp().loadLandmarks(bigWarpFile);
                    this.bwl.getBigWarp().setInLandmarkMode(true);
                    this.bwl.getBigWarp().setIsMovingDisplayTransformed(true);
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.waitForUser.run();
        switch (this.bwl.getBigWarp().getBwTransform().getTransformType()) {
            case "Thin Plate Spline": {
                this.rt = this.bwl.getBigWarp().getBwTransform().getTransformation();
                break;
            }
            default: {
                this.rt = this.bwl.getBigWarp().getBwTransform().affine3d();
            }
        }
        this.bwl.getBigWarp().closeAll();
        this.isDone = true;
        return true;
    }

    @Override
    public boolean edit() {
        this.register();
        return true;
    }

    @Override
    public void abort() {
    }

    public String toString() {
        return "Big Warp";
    }
}

