/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.sourceandconverter.affine;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.plugin.IRegistrationPlugin;
import ch.epfl.biop.registration.plugin.RegistrationTypeProperties;
import ch.epfl.biop.registration.sourceandconverter.affine.AffineTransformSourceAndConverterRegistration;
import ch.epfl.biop.scijava.command.source.register.Elastix2DAffineRegisterCommand;
import java.util.ArrayList;
import java.util.concurrent.Future;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

@Plugin(type=IRegistrationPlugin.class)
@RegistrationTypeProperties(isManual=false, isEditable=false)
public class Elastix2DAffineRegistration
extends AffineTransformSourceAndConverterRegistration {
    protected static final Logger logger = LoggerFactory.getLogger(Elastix2DAffineRegistration.class);
    Future<CommandModule> task;
    String errorMessage = "";

    @Override
    public void setFixedImage(SourceAndConverter[] fimg) {
        if (fimg.length == 0) {
            logger.error("Error, no fixed image set in class " + this.getClass().getSimpleName());
        }
        super.setFixedImage(fimg);
    }

    @Override
    public void setMovingImage(SourceAndConverter[] mimg) {
        if (mimg.length == 0) {
            logger.error("Error, no fixed image set in class " + this.getClass().getSimpleName());
        }
        super.setMovingImage(mimg);
    }

    @Override
    public boolean register() {
        try {
            Class<Elastix2DAffineRegisterCommand> registrationCommandClass = Elastix2DAffineRegisterCommand.class;
            boolean success = true;
            ArrayList<Object> flatParameters = new ArrayList<Object>(this.parameters.size() * 2 + 4);
            double voxSizeInMm = Double.parseDouble((String)this.parameters.get("px_size_in_current_unit"));
            this.parameters.keySet().forEach(k -> {
                flatParameters.add(k);
                flatParameters.add(this.parameters.get(k));
            });
            Elastix2DAffineRegistration.addToFlatParameters(flatParameters, "sacs_fixed", this.fimg, "sacs_moving", this.mimg, "interpolate", false, "min_image_size_pix", 4, "max_iteration_per_scale", 100, "verbose", false, "automatic_transform_initialization", true, "tp_fixed", 0, "level_fixed_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.fimg[0], (int)this.timePoint, (double)voxSizeInMm), "tp_moving", this.timePoint, "level_moving_source", SourceAndConverterHelper.bestLevel((SourceAndConverter)this.mimg[0], (int)this.timePoint, (double)voxSizeInMm));
            this.task = ((CommandService)this.context.getService(CommandService.class)).run(registrationCommandClass, false, flatParameters.toArray(new Object[0]));
            CommandModule module = this.task.get();
            if (module.getOutputs().containsKey("success")) {
                success = (Boolean)module.getOutput("success");
            }
            if (success) {
                this.at3d = (AffineTransform3D)module.getOutput("at3d");
            } else if (module.getOutputs().containsKey("error")) {
                this.errorMessage = (String)module.getOutput("error");
            }
            this.isDone = true;
            return success;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getExceptionMessage() {
        return this.errorMessage;
    }

    @Override
    public void abort() {
        if (this.task != null) {
            logger.info(this.getClass().getSimpleName() + ": Attempt to interrupt registration...");
            this.task.cancel(true);
        }
    }

    public String toString() {
        return "Elastix 2D Affine";
    }
}

