/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.sourceandconverter.affine;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.registration.sourceandconverter.SourceAndConverterRegistration;
import java.util.ArrayList;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import org.scijava.Context;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;
import sc.fiji.persist.ScijavaGsonHelper;

public abstract class AffineTransformSourceAndConverterRegistration
extends SourceAndConverterRegistration {
    protected AffineTransform3D at3d = new AffineTransform3D();
    public int timePoint = 0;

    @Override
    public SourceAndConverter<?>[] getTransformedImageMovingToFixed(SourceAndConverter<?>[] img) {
        SourceAndConverter[] out = new SourceAndConverter[img.length];
        for (int idx = 0; idx < img.length; ++idx) {
            out[idx] = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)this.at3d, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(img[idx], this.timePoint));
        }
        return out;
    }

    @Override
    public RealPointList getTransformedPtsFixedToMoving(RealPointList pts) {
        ArrayList<RealPoint> cvtList = new ArrayList<RealPoint>();
        for (RealPoint p : pts.ptList) {
            RealPoint pt3d = new RealPoint(3);
            pt3d.setPosition(new double[]{p.getDoublePosition(0), p.getDoublePosition(1), 0.0});
            this.at3d.inverse().apply((RealLocalizable)pt3d, (RealPositionable)pt3d);
            RealPoint cpt = new RealPoint(new double[]{pt3d.getDoublePosition(0), pt3d.getDoublePosition(1)});
            cvtList.add(cpt);
        }
        return new RealPointList(cvtList);
    }

    @Override
    public String getTransform() {
        return ScijavaGsonHelper.getGson((Context)this.context).toJson((Object)this.at3d, AffineTransform3D.class);
    }

    @Override
    public void setTransform(String serialized_transform) {
        this.at3d = (AffineTransform3D)ScijavaGsonHelper.getGson((Context)this.context).fromJson(serialized_transform, AffineTransform3D.class);
        this.isDone = true;
    }

    @Override
    public boolean edit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RealTransform getTransformAsRealTransform() {
        return this.at3d.inverse().copy();
    }
}

