/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.scijava.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ch.epfl.biop.registration.RegistrationPair;
import ch.epfl.biop.registration.scijava.command.AbstractPairRegistration2DCommand;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ij.IJ;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import ome.units.UNITS;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.TaskService;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Export>Register Pair - Export registration to OME-TIFF", description="If properly defined, exports the current registration as an OME-TIFF file.")
public class PairRegistrationExportToOMETIFFCommand
implements Command {
    @Parameter
    Context ctx;
    @Parameter
    RegistrationPair registration_pair;
    @Parameter(label="Interpolate pixels values")
    boolean interpolate;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "If you include channels of the fixed image, the pixel type should match those of the moving one";
    @Parameter(label="Fixed image channels (comma separated, empty for none, '*' for all)")
    String channels_fixed_csv;
    @Parameter(label="Moving image channels (comma separated, empty for none, '*' for all)")
    String channels_moving_csv;
    @Parameter(style="save")
    File file_path;
    @Parameter
    LogService ls;
    @Parameter(label="Number of resolution levels")
    int n_resolution_levels = 4;
    @Parameter(label="Scaling factor between resolution levels")
    int downscaling = 2;
    @Parameter(label="Tile Size X (negative: no tiling)")
    int tile_size_x = 512;
    @Parameter(label="Tile Size Y (negative: no tiling)")
    int tile_size_y = 512;
    @Parameter(label="Number of threads (0 = serial)")
    int n_threads = 8;
    @Parameter(label="Compression type", choices={"LZW", "Uncompressed", "JPEG-2000", "JPEG-2000 Lossy", "JPEG"})
    String compression = "LZW";
    @Parameter(label="Compress temporary files (save space on drive during pyramid building)")
    boolean compress_temp_files = false;
    @Parameter
    TaskService taskService;

    public void run() {
        int nSources;
        int i;
        if (this.file_path.exists()) {
            this.ls.warn((Object)"Export file path already exists, the export will not be performed.");
            return;
        }
        if (this.channels_fixed_csv.trim().equals("*")) {
            this.channels_fixed_csv = "0";
            for (i = 1; i < this.registration_pair.getFixedSources().length; ++i) {
                this.channels_fixed_csv = this.channels_fixed_csv + "," + i;
            }
        }
        if (this.channels_moving_csv.trim().equals("*")) {
            this.channels_moving_csv = "0";
            for (i = 1; i < this.registration_pair.getMovingSourcesOrigin().length; ++i) {
                this.channels_moving_csv = this.channels_moving_csv + "," + i;
            }
        }
        SourceAndConverter[] fixed_sources = null;
        SourceAndConverter[] moving_sources = null;
        if (this.channels_fixed_csv != null && !this.channels_fixed_csv.trim().isEmpty()) {
            fixed_sources = (SourceAndConverter[])this.getSourcesProcessorFixed().apply(this.registration_pair.getFixedSources());
        }
        if (this.channels_moving_csv != null && !this.channels_moving_csv.trim().isEmpty()) {
            moving_sources = (SourceAndConverter[])this.getSourcesProcessorMoving().apply(this.registration_pair.getMovingSourcesRegistered());
        }
        if ((nSources = (fixed_sources == null ? 0 : fixed_sources.length) + (moving_sources == null ? 0 : moving_sources.length)) == 0) {
            this.ls.warn((Object)"No source is defined in the export command - skipping export.");
            return;
        }
        ArrayList<Object> exportedSources = fixed_sources != null ? new ArrayList<SourceAndConverter>(Arrays.asList(fixed_sources)) : new ArrayList();
        SourceAndConverter<?> modelSource = this.registration_pair.getFixedSources()[0];
        if (moving_sources != null) {
            for (SourceAndConverter source : moving_sources) {
                exportedSources.add(new SourceResampler(source, modelSource, source.getSpimSource().getName() + "_Registered", false, false, this.interpolate, 0).get());
            }
        }
        try {
            String imageName = FilenameUtils.removeExtension((String)this.file_path.getName());
            if (imageName.endsWith(".ome")) {
                imageName = FilenameUtils.removeExtension((String)imageName);
            }
            OMETiffExporter.builder().put(exportedSources.toArray(new SourceAndConverter[0])).defineMetaData(FilenameUtils.removeExtension((String)imageName)).putMetadataFromSources(exportedSources.toArray(new SourceAndConverter[0]), UNITS.MILLIMETER).defineWriteOptions().maxTilesInQueue(200).compression(this.compression).compressTemporaryFiles(this.compress_temp_files).nThreads(this.n_threads).downsample(this.downscaling).nResolutionLevels(this.n_resolution_levels).rangeT("").rangeC("").rangeZ("").monitor(this.taskService).savePath(this.file_path.getAbsolutePath()).tileSize(this.tile_size_x, this.tile_size_y).create().export();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IJ.log((String)"Export warpy registered image done.");
    }

    protected SourcesProcessor getSourcesProcessorFixed() {
        return AbstractPairRegistration2DCommand.getChannelProcessorFromCsv(this.channels_fixed_csv, this.registration_pair.getFixedSources().length);
    }

    protected SourcesProcessor getSourcesProcessorMoving() {
        return AbstractPairRegistration2DCommand.getChannelProcessorFromCsv(this.channels_moving_csv, this.registration_pair.getMovingSourcesOrigin().length);
    }
}

