/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.scijava.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.RegistrationPair;
import java.util.List;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Create registration pair", description="Defines a registration pair")
public class PairRegistrationCreateCommand
implements Command {
    @Parameter(label="Fixed source for registration", description="fixed sources", style="sorted")
    SourceAndConverter<?>[] fixed_sources;
    @Parameter(label="Moving source for registration", description="moving sources", style="sorted")
    SourceAndConverter<?>[] moving_sources;
    @Parameter
    String registration_name;
    @Parameter(type=ItemIO.OUTPUT)
    RegistrationPair registration_pair;
    @Parameter
    ObjectService objectService;

    public void run() {
        List allRegistrations = this.objectService.getObjects(RegistrationPair.class);
        if (allRegistrations.stream().anyMatch(rps -> rps.getName().equals(this.registration_name))) {
            System.err.println("A registration sequence named " + this.registration_name + " already exists! Please name it differently or delete the existing one.");
            return;
        }
        this.registration_pair = new RegistrationPair(this.fixed_sources, 0, this.moving_sources, 0, this.registration_name, true);
        this.objectService.addObject((Object)this.registration_pair);
    }
}

