/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.scijava.command;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import ch.epfl.biop.registration.RegistrationPair;
import ch.epfl.biop.registration.scijava.command.PairRegistrationBigWarp2DSplineCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationCenterCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationEditLastRegistrationCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationElastix2DAffineCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationElastix2DSplineCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationExportToOMETIFFCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationExportToQuPathCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationRemoveLastRegistrationCommand;
import ch.epfl.biop.registration.scijava.command.PairRegistrationSift2DAffineCommand;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.BdvScijavaHelper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Registration pair - Add GUI", description="Delete a registration pair")
public class PairRegistrationAddGUICommand
implements Command {
    @Parameter
    RegistrationPair registration_pair;
    @Parameter
    ObjectService objectService;
    @Parameter
    Context ctx;
    RegistrationPair.RegistrationPairListener listener;
    boolean closeAlreadyActivated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BdvStackSource bdvStack = BdvFunctions.show(this.registration_pair.getFixedSources()[0], (int)1, (BdvOptions)BdvOptions.options().is2D());
        final BdvHandle bdvh = bdvStack.getBdvHandle();
        RegistrationPair registrationPair = this.registration_pair;
        synchronized (registrationPair) {
            for (SourceAndConverter<?> source : this.registration_pair.getFixedSources()) {
                BdvFunctions.show(source, (int)1, (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
            }
            for (SourceAndConverter<?> source : this.registration_pair.getMovingSourcesOrigin()) {
                BdvFunctions.show(source, (int)1, (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
            }
            SourceGroup fixedGroup = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(0);
            bdvh.getViewerPanel().state().setGroupName(fixedGroup, "Fixed sources");
            bdvh.getViewerPanel().state().setGroupActive(fixedGroup, true);
            bdvh.getViewerPanel().state().addSourcesToGroup(Arrays.asList(this.registration_pair.getFixedSources()), fixedGroup);
            SourceGroup movingOriginGroup = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(1);
            bdvh.getViewerPanel().state().setGroupActive(movingOriginGroup, false);
            bdvh.getViewerPanel().state().setGroupName(movingOriginGroup, "Moving sources - origin");
            bdvh.getViewerPanel().state().addSourcesToGroup(Arrays.asList(this.registration_pair.getMovingSourcesOrigin()), movingOriginGroup);
            this.updateBdvSourceGroups(bdvh);
            bdvh.getViewerPanel().setDisplayMode(DisplayMode.FUSEDGROUP);
            new ViewerTransformAdjuster(bdvh, new SourceAndConverter[]{this.registration_pair.getFixedSources()[0], this.registration_pair.getMovingSourcesRegistered()[0]}).run();
        }
        this.listener = new RegistrationPair.RegistrationPairListener(){

            @Override
            public void newEvent(RegistrationPair.RegistrationEvents event) {
                switch (event) {
                    case STEP_REMOVED: {
                        int nSteps = PairRegistrationAddGUICommand.this.registration_pair.getAllSourcesPerStep().size();
                        SourceGroup group = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(nSteps);
                        bdvh.getViewerPanel().state().removeSources((Collection)bdvh.getViewerPanel().state().getSourcesInGroup(group));
                        PairRegistrationAddGUICommand.this.updateBdvSourceGroups(bdvh);
                        break;
                    }
                    case STEP_ADDED: {
                        PairRegistrationAddGUICommand.this.updateBdvSourceGroups(bdvh);
                        break;
                    }
                    case CLOSED: {
                        bdvh.close();
                    }
                }
            }
        };
        this.registration_pair.addListener(this.listener);
        this.addConfirmationCloseHook(bdvh);
        int hierarchyLevelsSkipped = 3;
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationCenterCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationSift2DAffineCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationElastix2DAffineCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationElastix2DSplineCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationBigWarp2DSplineCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationExportToQuPathCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationExportToOMETIFFCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationEditLastRegistrationCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)bdvh, (Context)this.ctx, PairRegistrationRemoveLastRegistrationCommand.class, (int)hierarchyLevelsSkipped, (Object[])new Object[]{"registration_pair", this.registration_pair});
    }

    private void updateBdvSourceGroups(BdvHandle bdvh) {
        for (int g = 2; g < bdvh.getViewerPanel().state().getGroups().size(); ++g) {
            bdvh.getViewerPanel().state().setGroupName((SourceGroup)bdvh.getViewerPanel().state().getGroups().get(g), "+ " + this.registration_pair.getRegistrationName(g - 2));
        }
        List<SourceAndConverter<?>[]> sourcesPerStep = this.registration_pair.getAllSourcesPerStep();
        for (int step = 0; step < sourcesPerStep.size(); ++step) {
            SourceGroup group = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(step + 2);
            bdvh.getViewerPanel().state().removeSources((Collection)bdvh.getViewerPanel().state().getSourcesInGroup(group));
            bdvh.getViewerPanel().state().setGroupActive(group, false);
            List<Object> sources = Arrays.asList((Object[])sourcesPerStep.get(step));
            for (SourceAndConverter sourceAndConverter : sources) {
                BdvFunctions.show((SourceAndConverter)sourceAndConverter, (int)1, (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
            }
            bdvh.getViewerPanel().state().addSourcesToGroup(sources, group);
        }
        for (SourceAndConverter<?> source : this.registration_pair.getFixedSources()) {
            BdvFunctions.show(source, (int)1, (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
        }
        for (SourceAndConverter<?> source : this.registration_pair.getMovingSourcesOrigin()) {
            BdvFunctions.show(source, (int)1, (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
        }
        SourceGroup fixedGroup = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(0);
        bdvh.getViewerPanel().state().addSourcesToGroup(Arrays.asList(this.registration_pair.getFixedSources()), fixedGroup);
        SourceGroup movingOriginGroup = (SourceGroup)bdvh.getViewerPanel().state().getGroups().get(1);
        bdvh.getViewerPanel().state().addSourcesToGroup(Arrays.asList(this.registration_pair.getMovingSourcesOrigin()), movingOriginGroup);
        if (sourcesPerStep.isEmpty()) {
            bdvh.getViewerPanel().state().setGroupActive((SourceGroup)bdvh.getViewerPanel().state().getGroups().get(1), true);
        } else {
            bdvh.getViewerPanel().state().setGroupActive((SourceGroup)bdvh.getViewerPanel().state().getGroups().get(1), false);
            bdvh.getViewerPanel().state().setGroupActive((SourceGroup)bdvh.getViewerPanel().state().getGroups().get(sourcesPerStep.size() + 1), true);
        }
    }

    private void addConfirmationCloseHook(BdvHandle bdvh) {
        WindowListener[] listeners;
        final JFrame frame = BdvHandleHelper.getJFrame((BdvHandle)bdvh);
        for (WindowListener listener : listeners = frame.getWindowListeners()) {
            frame.removeWindowListener(listener);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!PairRegistrationAddGUICommand.this.closeAlreadyActivated) {
                    String message = "Are you sure you want to exit the registration GUI?";
                    int confirmed = JOptionPane.showConfirmDialog(frame, message, "Close window ?", 0);
                    if (confirmed == 0) {
                        PairRegistrationAddGUICommand.this.registration_pair.removeListener(PairRegistrationAddGUICommand.this.listener);
                        PairRegistrationAddGUICommand.this.closeAlreadyActivated = true;
                        int clearRegistration = JOptionPane.showConfirmDialog(frame, "Keep registration pair in memory?", "Keep registration in memory.", 0);
                        if (clearRegistration == 1) {
                            try {
                                PairRegistrationAddGUICommand.this.registration_pair.close();
                                PairRegistrationAddGUICommand.this.objectService.removeObject((Object)PairRegistrationAddGUICommand.this.registration_pair);
                                PairRegistrationAddGUICommand.this.registration_pair = null;
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        for (WindowListener listener : listeners) {
                            listener.windowClosing(e);
                        }
                        PairRegistrationAddGUICommand.this.registration_pair = null;
                    } else {
                        frame.setDefaultCloseOperation(0);
                    }
                }
            }
        });
    }
}

