/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.scijava.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.scijava.command.AbstractPairRegistration2DCommand;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Parameter;

public abstract class AbstractPairRegistrationInROI2DCommand
extends AbstractPairRegistration2DCommand {
    @Parameter(label="ROI for registration (select custom in order to use the parameters below)", choices={"intersection", "union", "custom"})
    String bounds = "intersection";
    @Parameter(label="ROI for registration (position x)", style="format:0.#####E0", required=false)
    double px;
    @Parameter(label="ROI for registration (position y)", style="format:0.#####E0", required=false)
    double py;
    @Parameter(label="ROI for registration (size x)", style="format:0.#####E0", required=false)
    double sx;
    @Parameter(label="ROI for registration (size y)", style="format:0.#####E0", required=false)
    double sy;

    @Override
    protected final void addRegistrationParameters(Map<String, Object> parameters) {
        switch (this.bounds) {
            case "intersection": {
                this.setIntersectionAsROI();
                break;
            }
            case "union": {
                this.setUnionAsROI();
                break;
            }
            case "custom": {
                break;
            }
            default: {
                System.err.println("Invalid bounds parameter, choose custom");
            }
        }
        parameters.put("px", this.px);
        parameters.put("py", this.py);
        parameters.put("sx", this.sx);
        parameters.put("sy", this.sy);
        this.addRegistrationSpecificParametersExceptRoi(parameters);
    }

    protected abstract void addRegistrationSpecificParametersExceptRoi(Map<String, Object> var1);

    void setIntersectionAsROI() {
        if (this.registration_pair == null) {
            return;
        }
        RealInterval boundMoving = AbstractPairRegistrationInROI2DCommand.getBoundingBox(this.registration_pair.getMovingSourcesRegistered());
        RealInterval boundFixed = AbstractPairRegistrationInROI2DCommand.getBoundingBox(this.registration_pair.getFixedSources());
        this.px = Math.max(boundMoving.realMin(0), boundFixed.realMin(0));
        this.py = Math.max(boundMoving.realMin(1), boundFixed.realMin(1));
        this.sx = Math.min(boundMoving.realMax(0), boundFixed.realMax(0)) - this.px;
        this.sy = Math.min(boundMoving.realMax(1), boundFixed.realMax(1)) - this.py;
    }

    void setUnionAsROI() {
        if (this.registration_pair == null) {
            return;
        }
        RealInterval boundMoving = AbstractPairRegistrationInROI2DCommand.getBoundingBox(this.registration_pair.getMovingSourcesRegistered());
        RealInterval boundFixed = AbstractPairRegistrationInROI2DCommand.getBoundingBox(this.registration_pair.getFixedSources());
        this.px = Math.min(boundMoving.realMin(0), boundFixed.realMin(0));
        this.py = Math.min(boundMoving.realMin(1), boundFixed.realMin(1));
        this.sx = Math.max(boundMoving.realMax(0), boundFixed.realMax(0)) - this.px;
        this.sy = Math.max(boundMoving.realMax(1), boundFixed.realMax(1)) - this.py;
        if (this.sx < 0.0 || this.sy < 0.0) {
            System.err.println("Warning, null intersection!");
        }
    }

    static RealInterval getBoundingBox(SourceAndConverter<?>[] sources) {
        List intervalList = Arrays.stream(sources).map(sourceAndConverter -> {
            RandomAccessibleInterval interval = sourceAndConverter.getSpimSource().getSource(0, 0);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sourceAndConverter.getSpimSource().getSourceTransform(0, 0, sourceTransform);
            RealPoint corner0 = new RealPoint(new float[]{interval.min(0), interval.min(1), interval.min(2)});
            RealPoint corner1 = new RealPoint(new float[]{interval.max(0), interval.max(1), interval.max(2)});
            sourceTransform.apply((RealLocalizable)corner0, (RealPositionable)corner0);
            sourceTransform.apply((RealLocalizable)corner1, (RealPositionable)corner1);
            return new FinalRealInterval(new double[]{Math.min(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.min(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.min(corner0.getDoublePosition(2), corner1.getDoublePosition(2))}, new double[]{Math.max(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.max(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.max(corner0.getDoublePosition(2), corner1.getDoublePosition(2))});
        }).collect(Collectors.toList());
        RealInterval maxInterval = (RealInterval)intervalList.stream().reduce((i1, i2) -> new FinalRealInterval(new double[]{Math.min(i1.realMin(0), i2.realMin(0)), Math.min(i1.realMin(1), i2.realMin(1)), Math.min(i1.realMin(2), i2.realMin(2))}, new double[]{Math.max(i1.realMax(0), i2.realMax(0)), Math.max(i1.realMax(1), i2.realMax(1)), Math.max(i1.realMax(2), i2.realMax(2))})).get();
        return maxInterval;
    }
}

