/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.scijava.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.RegistrationPair;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.convert.ConvertService;
import org.scijava.plugin.Parameter;

public abstract class AbstractPairRegistration2DCommand
implements Command {
    @Parameter
    Context ctx;
    @Parameter
    RegistrationPair registration_pair;
    @Parameter(type=ItemIO.OUTPUT)
    boolean success = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        RegistrationPair registrationPair = this.registration_pair;
        synchronized (registrationPair) {
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                Registration<SourceAndConverter<?>[]> registration = this.getRegistration();
                registration.setScijavaContext(this.ctx);
                registration.setTimePoint(0);
                this.addRegistrationParameters(parameters);
                boolean ok = this.validate();
                if (!ok) {
                    System.err.println("Validation failed.");
                    return;
                }
                this.success = this.registration_pair.executeRegistration(registration, AbstractPairRegistration2DCommand.convertToString(this.ctx, parameters), this.getSourcesProcessorFixed(), this.getSourcesProcessorMoving());
                if (!this.success) {
                    System.err.println("Registration unsuccessful: " + this.registration_pair.getLastErrorMessage());
                }
            }
            catch (Exception e) {
                System.err.println("Error during registration: " + e.getMessage());
                e.printStackTrace();
                this.success = false;
            }
        }
    }

    protected abstract void addRegistrationParameters(Map<String, Object> var1);

    abstract Registration<SourceAndConverter<?>[]> getRegistration();

    protected abstract SourcesProcessor getSourcesProcessorFixed();

    protected abstract SourcesProcessor getSourcesProcessorMoving();

    protected abstract boolean validate();

    public static Map<String, String> convertToString(Context ctx, Map<String, Object> params) {
        HashMap<String, String> convertedParams = new HashMap<String, String>();
        ConvertService cs = (ConvertService)ctx.getService(ConvertService.class);
        params.keySet().forEach(k -> {
            String cfr_ignored_0 = (String)convertedParams.put((String)k, (String)cs.convert(params.get(k), String.class));
        });
        return convertedParams;
    }

    protected static SourcesChannelsSelect getChannelProcessorFromCsv(String channelsCsv, int nChannels) throws NumberFormatException, IndexOutOfBoundsException {
        List<Integer> channels = Arrays.stream(channelsCsv.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        int maxIndex = (Integer)Collections.max(channels);
        int minIndex = (Integer)Collections.min(channels);
        if (minIndex < 0) {
            System.err.println("All channels indices should be positive");
            throw new IndexOutOfBoundsException();
        }
        if (maxIndex >= nChannels) {
            System.err.println("The max index (" + maxIndex + ") is above its maximum (" + nChannels + ")");
            throw new IndexOutOfBoundsException();
        }
        return new SourcesChannelsSelect(channels);
    }
}

