/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration.plugin;

import bdv.util.BoundedRealTransform;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.registration.plugin.ExternalRegistrationPlugin;
import ch.epfl.biop.registration.plugin.SimpleRegistrationPlugin;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import org.scijava.Context;
import org.scijava.command.Command;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;
import sc.fiji.persist.ScijavaGsonHelper;

public class SimpleRegistrationWrapper
implements ExternalRegistrationPlugin {
    final String registrationTypeName;
    final SimpleRegistrationPlugin registration;
    Context context;
    Map<String, String> parameters;
    boolean isDone = false;
    protected RealTransform rt;
    ImagePlus fixedImage;
    ImagePlus movingImage;
    ImagePlus fixedMask;
    ImagePlus movingMask;

    @Override
    public String getRegistrationTypeName() {
        return this.registrationTypeName;
    }

    public SimpleRegistrationWrapper(String registrationTypeName, SimpleRegistrationPlugin simpleRegistration) {
        this.registration = simpleRegistration;
        this.registrationTypeName = registrationTypeName;
    }

    @Override
    public boolean isManual() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public Class<? extends Command>[] userInterface() {
        return new Class[0];
    }

    @Override
    public void setScijavaContext(Context context) {
        this.context = context;
    }

    @Override
    public void setRegistrationParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, String> getRegistrationParameters() {
        return this.parameters;
    }

    @Override
    public void setFixedImage(SourceAndConverter<?>[] fimg) {
        this.fixedImage = SimpleRegistrationWrapper.export("Fixed-", Arrays.asList(fimg), Double.parseDouble(this.parameters.get("px")), Double.parseDouble(this.parameters.get("py")), Double.parseDouble(this.parameters.get("sx")), Double.parseDouble(this.parameters.get("sy")), this.registration.getVoxelSizeInMicron() / 1000.0, 0, false);
    }

    @Override
    public void setMovingImage(SourceAndConverter<?>[] mimg) {
        this.movingImage = SimpleRegistrationWrapper.export("Moving-", Arrays.asList(mimg), Double.parseDouble(this.parameters.get("px")), Double.parseDouble(this.parameters.get("py")), Double.parseDouble(this.parameters.get("sx")), Double.parseDouble(this.parameters.get("sy")), this.registration.getVoxelSizeInMicron() / 1000.0, 0, false);
    }

    @Override
    public void setFixedMask(SourceAndConverter<?>[] fimg_mask) {
        this.fixedMask = SimpleRegistrationWrapper.export("FixedMask-", Arrays.asList(fimg_mask), Double.parseDouble(this.parameters.get("px")), Double.parseDouble(this.parameters.get("py")), Double.parseDouble(this.parameters.get("sx")), Double.parseDouble(this.parameters.get("sy")), this.registration.getVoxelSizeInMicron() / 1000.0, 0, false);
    }

    @Override
    public void setMovingMask(SourceAndConverter<?>[] mimg_mask) {
        this.movingMask = SimpleRegistrationWrapper.export("MovingMask-", Arrays.asList(mimg_mask), Double.parseDouble(this.parameters.get("px")), Double.parseDouble(this.parameters.get("py")), Double.parseDouble(this.parameters.get("sx")), Double.parseDouble(this.parameters.get("sy")), this.registration.getVoxelSizeInMicron() / 1000.0, 0, false);
    }

    @Override
    public void resetRegistration() {
        this.isDone = false;
    }

    @Override
    public void setTimePoint(int timePoint) {
    }

    @Override
    public boolean register() {
        InvertibleRealTransform inner_rt = this.registration.register(this.fixedImage, this.movingImage, this.fixedMask, this.movingMask);
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        AffineTransform3D m = new AffineTransform3D();
        double px = Double.parseDouble(this.parameters.get("px"));
        double py = Double.parseDouble(this.parameters.get("py"));
        double voxSize = this.registration.getVoxelSizeInMicron();
        m.scale(voxSize / 1000.0);
        m.translate(new double[]{px, py, 0.0});
        irts.add((RealTransform)m.inverse());
        irts.add((RealTransform)inner_rt);
        irts.add((RealTransform)m);
        this.rt = irts;
        this.isDone = true;
        return true;
    }

    @Override
    public boolean edit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRegistrationDone() {
        return this.isDone;
    }

    @Override
    public SourceAndConverter<?>[] getTransformedImageMovingToFixed(SourceAndConverter<?>[] img) {
        SourceAndConverter[] out = new SourceAndConverter[img.length];
        SourceRealTransformer srt = new SourceRealTransformer(this.rt);
        for (int idx = 0; idx < img.length; ++idx) {
            out[idx] = srt.apply(img[idx]);
        }
        return out;
    }

    @Override
    public RealPointList getTransformedPtsFixedToMoving(RealPointList pts) {
        RealTransform innerRT = this.rt;
        if (this.rt instanceof BoundedRealTransform) {
            innerRT = ((BoundedRealTransform)this.rt).getTransform().copy();
        }
        ArrayList<RealPoint> cvtList = new ArrayList<RealPoint>();
        for (RealPoint p : pts.ptList) {
            RealPoint pt3d = new RealPoint(3);
            pt3d.setPosition(new double[]{p.getDoublePosition(0), p.getDoublePosition(1), 0.0});
            innerRT.apply((RealLocalizable)pt3d, (RealPositionable)pt3d);
            RealPoint cpt = new RealPoint(new double[]{pt3d.getDoublePosition(0), pt3d.getDoublePosition(1)});
            cvtList.add(cpt);
        }
        return new RealPointList(cvtList);
    }

    @Override
    public void abort() {
    }

    public RealTransform getRealTransform() {
        return this.rt;
    }

    public void setRealTransform(RealTransform transform) {
        this.rt = transform.copy();
    }

    @Override
    public final String getTransform() {
        String transform = ScijavaGsonHelper.getGson((Context)this.context).toJson((Object)this.rt, RealTransform.class);
        return transform;
    }

    @Override
    public final void setTransform(String serialized_transform) {
        this.setRealTransform((RealTransform)ScijavaGsonHelper.getGson((Context)this.context).fromJson(serialized_transform, RealTransform.class));
        this.isDone = true;
    }

    @Override
    public RealTransform getTransformAsRealTransform() {
        return this.rt.copy();
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus export(String name, List<SourceAndConverter<?>> sourceList, double px, double py, double sx, double sy, double pixelSizeMillimeter, int timepoint, boolean interpolate) {
        AffineTransform3D at3D = new AffineTransform3D();
        SourceAndConverter model = SimpleRegistrationWrapper.createModelSource(px, py, sx, sy, pixelSizeMillimeter, at3D);
        List resampledSourceList = sourceList.stream().map(sac -> new SourceResampler(sac, model, sac.getSpimSource().getName() + "_ResampledLike_" + model.getSpimSource().getName(), true, false, interpolate, 0).get()).collect(Collectors.toList());
        if (sourceList.size() > 1) {
            HashMap mapMipmap = new HashMap();
            sourceList.forEach(src -> {
                int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)src, (int)timepoint, (double)pixelSizeMillimeter);
                mapMipmap.put(resampledSourceList.get(sourceList.indexOf(src)), mipmapLevel);
            });
            ImagePlus resultImage = ImagePlusHelper.wrap(resampledSourceList, mapMipmap, (int)timepoint, (int)1, (int)1);
            resultImage.setTitle(name + "-[" + px + ":" + (px + sx) + " | " + py + ":" + (py + sy) + "]");
            ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)resultImage, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
            return resultImage;
        }
        SourceAndConverter source = (SourceAndConverter)resampledSourceList.get(0);
        int mipmapLevel = SourceAndConverterHelper.bestLevel(sourceList.get(0), (int)timepoint, (double)pixelSizeMillimeter);
        ImagePlus singleChannel = ImagePlusHelper.wrap((SourceAndConverter)source, (int)mipmapLevel, (int)timepoint, (int)1, (int)1);
        singleChannel.setTitle(source.getSpimSource().getName());
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)singleChannel, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
        return singleChannel;
    }

    private static SourceAndConverter createModelSource(double px, double py, double sx, double sy, double pixel_size_mm, AffineTransform3D transform) {
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.translate(new double[]{-px, -py, 0.0});
        at3D.scale(1.0 / pixel_size_mm);
        long nPx = (long)(sx / pixel_size_mm);
        long nPy = (long)(sy / pixel_size_mm);
        long nPz = 1L;
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        transform.set(at3D);
        return new EmptySourceAndConverterCreator("model", at3D.inverse(), nPx, nPy, nPz).get();
    }

    public String toString() {
        return this.registrationTypeName;
    }
}

