/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.registration;

import bdv.util.QuPathBdvHelper;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.plugin.RegistrationPluginHelper;
import ch.epfl.biop.sourceandconverter.processor.SourcesAffineTransformer;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.Named;
import sc.fiji.persist.ScijavaGsonHelper;

public class RegistrationPair
implements Named,
Closeable {
    final SourceAndConverter<?>[] movingSourcesOrigin;
    final SourceAndConverter<?>[] fixedSources;
    final int timepointMoving;
    final int timepointFixed;
    final String name;
    SourceAndConverter<?>[] movingSourcesRegistered;
    final List<RegistrationStep> registrationPairSteps = new ArrayList<RegistrationStep>();
    String errorMessage = "";
    final List<RegistrationPairListener> listeners = new ArrayList<RegistrationPairListener>();

    public RegistrationPair(SourceAndConverter<?>[] fixedSources, int timepointFixed, SourceAndConverter<?>[] movingSources, int timepointMoving, String name, boolean removezOffset) {
        if (removezOffset) {
            this.fixedSources = new SourcesAffineTransformer(RegistrationPair.findZ0Transform(fixedSources[0], timepointFixed)).apply(fixedSources);
            this.movingSourcesOrigin = new SourcesAffineTransformer(RegistrationPair.findZ0Transform(movingSources[0], timepointMoving)).apply(movingSources);
        } else {
            this.fixedSources = fixedSources;
            this.movingSourcesOrigin = movingSources;
        }
        this.movingSourcesRegistered = this.movingSourcesOrigin;
        this.timepointFixed = timepointFixed;
        this.timepointMoving = timepointMoving;
        this.name = name;
    }

    public SourceAndConverter<?>[] getFixedSources() {
        return this.fixedSources;
    }

    public SourceAndConverter<?>[] getMovingSourcesOrigin() {
        return this.movingSourcesOrigin;
    }

    public synchronized SourceAndConverter<?>[] getMovingSourcesRegistered() {
        return this.movingSourcesRegistered;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    public synchronized boolean executeRegistration(Registration<SourceAndConverter<?>[]> reg, Map<String, String> parameters, SourcesProcessor fixedProcessorForRegistration, SourcesProcessor movingProcessorForRegistration) {
        reg.setRegistrationParameters(parameters);
        reg.setMovingImage((SourceAndConverter<?>[])movingProcessorForRegistration.apply(this.getMovingSourcesRegistered()));
        reg.setFixedImage((SourceAndConverter<?>[])fixedProcessorForRegistration.apply(this.getFixedSources()));
        boolean success = reg.register();
        if (!success) {
            this.errorMessage = reg.getExceptionMessage();
            return false;
        }
        this.appendRegistration(reg, fixedProcessorForRegistration, movingProcessorForRegistration);
        return true;
    }

    private void appendRegistration(Registration<SourceAndConverter<?>[]> reg, SourcesProcessor fixedProcessorForRegistration, SourcesProcessor movingProcessorForRegistration) {
        this.movingSourcesRegistered = reg.getTransformedImageMovingToFixed(this.getMovingSourcesRegistered());
        RegistrationStep rp = new RegistrationStep(reg, this.getMovingSourcesRegistered(), fixedProcessorForRegistration, movingProcessorForRegistration);
        this.registrationPairSteps.add(rp);
        this.listeners.forEach(listener -> listener.newEvent(RegistrationEvents.STEP_ADDED));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("You can't rename a registration pair sequence object");
    }

    public synchronized void removeLastRegistration() {
        if (this.registrationPairSteps.isEmpty()) {
            return;
        }
        if (this.registrationPairSteps.size() == 1) {
            this.registrationPairSteps.remove(0);
            this.movingSourcesRegistered = this.movingSourcesOrigin;
        } else {
            RegistrationStep rs = this.registrationPairSteps.get(this.registrationPairSteps.size() - 2);
            this.registrationPairSteps.remove(this.registrationPairSteps.size() - 1);
            this.movingSourcesRegistered = rs.sacs;
        }
        this.listeners.forEach(listener -> listener.newEvent(RegistrationEvents.STEP_REMOVED));
    }

    public synchronized void editLastRegistration() {
        if (this.registrationPairSteps.isEmpty()) {
            System.err.println("There is no registration to edit");
            return;
        }
        RegistrationStep lastStep = this.registrationPairSteps.get(this.registrationPairSteps.size() - 1);
        if (!RegistrationPluginHelper.isEditable(lastStep.reg)) {
            System.err.println("The last registration is not editable");
            return;
        }
        this.removeLastRegistration();
        lastStep.reg.edit();
        this.appendRegistration(lastStep.reg, lastStep.fixedProcessor, lastStep.movingProcessor);
    }

    public int getFixedTimepoint() {
        return this.timepointFixed;
    }

    public int getMovingTimepoint() {
        return this.timepointMoving;
    }

    public boolean checkQuPathCompatibility() {
        int i;
        int entryIdMoving;
        if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.fixedSources[0])) {
            this.errorMessage = "The first fixed source is not linked to a QuPath project";
            return false;
        }
        if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.movingSourcesOrigin[0])) {
            this.errorMessage = "The first moving source is not linked to a QuPath project";
            return false;
        }
        File quPathProject = QuPathBdvHelper.getProjectFile(this.fixedSources[0]);
        if (!quPathProject.equals(QuPathBdvHelper.getProjectFile(this.movingSourcesOrigin[0]))) {
            this.errorMessage = "Moving and fixed sources do not belong to the same QuPath project.";
            return false;
        }
        int entryIdFixed = QuPathBdvHelper.getEntryId(this.fixedSources[0]);
        if (entryIdFixed == (entryIdMoving = QuPathBdvHelper.getEntryId(this.movingSourcesOrigin[0]))) {
            this.errorMessage = "The first moving source and the first fixed source belong to the same QuPath entry";
            return false;
        }
        for (i = 1; i < this.fixedSources.length; ++i) {
            if (QuPathBdvHelper.isSourceLinkedToQuPath(this.fixedSources[i])) {
                if (QuPathBdvHelper.getEntryId(this.fixedSources[i]) == entryIdFixed) continue;
                System.out.println("Warning: all fixed sources do not belong to the same QuPath entry");
                break;
            }
            System.out.println("Warning: some sources do not belong to a QuPath project.");
        }
        for (i = 1; i < this.movingSourcesOrigin.length; ++i) {
            if (QuPathBdvHelper.isSourceLinkedToQuPath(this.movingSourcesOrigin[i])) {
                if (QuPathBdvHelper.getEntryId(this.movingSourcesOrigin[i]) == entryIdMoving) continue;
                System.out.println("Warning: all moving sources do not belong to the same QuPath entry");
                break;
            }
            System.out.println("Warning: some sources do not belong to a QuPath project.");
        }
        File fixedEntryFolder = QuPathBdvHelper.getDataEntryFolder(this.fixedSources[0]);
        fixedEntryFolder.mkdirs();
        if (!fixedEntryFolder.exists()) {
            this.errorMessage = "Could not create fixed entry folder " + fixedEntryFolder.getAbsolutePath();
            return false;
        }
        File movingEntryFolder = QuPathBdvHelper.getDataEntryFolder(this.movingSourcesOrigin[0]);
        movingEntryFolder.mkdirs();
        if (!movingEntryFolder.exists()) {
            this.errorMessage = "Could not create moving entry folder " + movingEntryFolder.getAbsolutePath();
            return false;
        }
        return true;
    }

    public synchronized boolean exportToQuPath(boolean allowOverwrite, Context scijavaCtx) {
        boolean result = this.checkQuPathCompatibility();
        if (!result) {
            return false;
        }
        SourceAndConverter<?> moving_source = this.movingSourcesOrigin[0];
        SourceAndConverter<?> fixed_source = this.fixedSources[0];
        AffineTransform3D movingToPixel = new AffineTransform3D();
        moving_source.getSpimSource().getSourceTransform(0, 0, movingToPixel);
        AffineTransform3D fixedToPixel = new AffineTransform3D();
        fixed_source.getSpimSource().getSourceTransform(0, 0, fixedToPixel);
        InvertibleRealTransformSequence rt = new InvertibleRealTransformSequence();
        for (int iReg = 0; iReg < this.registrationPairSteps.size(); ++iReg) {
            RegistrationStep rp = this.registrationPairSteps.get(this.registrationPairSteps.size() - iReg - 1);
            RealTransform rt_temp = rp.reg.getTransformAsRealTransform();
            if (!(rt_temp instanceof InvertibleRealTransform)) {
                this.errorMessage = "A transformation within the sequence is not invertible!";
                return false;
            }
            rt.add((RealTransform)((InvertibleRealTransform)rt_temp));
        }
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        irts.add((RealTransform)fixedToPixel);
        irts.add((RealTransform)rt);
        irts.add((RealTransform)movingToPixel.inverse());
        String jsonMovingToFixed = ScijavaGsonHelper.getGson((Context)scijavaCtx).toJson((Object)irts, RealTransform.class);
        int moving_series_entry_id = QuPathBdvHelper.getEntryId(moving_source);
        int fixed_series_entry_id = QuPathBdvHelper.getEntryId(fixed_source);
        String movingToFixedLandmarkName = "transform_" + moving_series_entry_id + "_" + fixed_series_entry_id + ".json";
        File moving_entry_folder = QuPathBdvHelper.getDataEntryFolder(this.movingSourcesOrigin[0]);
        File resultFile = new File(moving_entry_folder.getAbsolutePath(), movingToFixedLandmarkName);
        if (resultFile.exists() && !allowOverwrite) {
            this.errorMessage = "The registration file already exists, overwrite not allowed.";
            return false;
        }
        try {
            FileUtils.writeStringToFile((File)resultFile, (String)jsonMovingToFixed, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        System.out.println("Fixed: " + fixed_source.getSpimSource().getName() + " | Moving: " + moving_source.getSpimSource().getName());
        System.out.println("Transformation file successfully written to QuPath project: " + result);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.listeners.forEach(listener -> listener.newEvent(RegistrationEvents.CLOSED));
        this.listeners.clear();
    }

    public synchronized List<SourceAndConverter<?>[]> getAllSourcesPerStep() {
        ArrayList<SourceAndConverter<?>[]> sourcesPerStep = new ArrayList<SourceAndConverter<?>[]>();
        for (RegistrationStep rs : this.registrationPairSteps) {
            sourcesPerStep.add(rs.sacs);
        }
        return sourcesPerStep;
    }

    public String getRegistrationName(int step) {
        if (step >= 0 && step < this.registrationPairSteps.size()) {
            Registration<SourceAndConverter<?>[]> reg = this.registrationPairSteps.get((int)step).reg;
            if (RegistrationPluginHelper.isEditable(reg)) {
                return reg + " (editable)";
            }
            return reg.toString();
        }
        return "";
    }

    public String toString() {
        return this.name;
    }

    private static AffineTransform3D findZ0Transform(SourceAndConverter<?> source, int timePoint) {
        long sz = source.getSpimSource().getSource(timePoint, 0).dimension(2);
        AffineTransform3D at3D = new AffineTransform3D();
        source.getSpimSource().getSourceTransform(timePoint, 0, at3D);
        AffineTransform3D at3DCenter = new AffineTransform3D();
        at3DCenter.concatenate(at3D.inverse());
        at3DCenter.translate(new double[]{0.0, 0.0, (double)(-sz) / 2.0 + 0.5});
        at3D.set(0.0, 2, 3);
        at3DCenter.preConcatenate(at3D);
        return at3DCenter;
    }

    public void addListener(RegistrationPairListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RegistrationPairListener listener) {
        this.listeners.remove(listener);
    }

    public static interface RegistrationPairListener {
        public void newEvent(RegistrationEvents var1);
    }

    public static enum RegistrationEvents {
        STEP_ADDED,
        STEP_REMOVED,
        CLOSED;

    }

    private static class RegistrationStep {
        final Registration<SourceAndConverter<?>[]> reg;
        final SourceAndConverter<?>[] sacs;
        final SourcesProcessor fixedProcessor;
        final SourcesProcessor movingProcessor;

        public RegistrationStep(Registration<SourceAndConverter<?>[]> reg, SourceAndConverter<?>[] sacs, SourcesProcessor fixedProcessor, SourcesProcessor movingProcessor) {
            this.reg = reg;
            this.sacs = sacs;
            this.fixedProcessor = fixedProcessor;
            this.movingProcessor = movingProcessor;
        }
    }
}

