/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.mastodon;

import bdv.util.Elliptical3DTransform;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.io.TmXmlWriter;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.mastodon.graph.Edge;
import org.mastodon.mamut.ProjectModel;
import org.mastodon.mamut.model.Model;
import org.mastodon.mamut.model.ModelGraph;
import org.mastodon.model.tag.TagSetStructure;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import sc.fiji.persist.ScijavaGsonHelper;

public class MamutWarperCommand
implements Command {
    @Parameter
    private ProjectModel app_model;
    @Parameter(label="Select the image plus projected image")
    ImagePlus image;
    @Parameter(label="Select the transformation file")
    File elliptical_transform_file;
    @Parameter(label="Trackmate file to save", style="save")
    File tm_file;
    @Parameter(label="Output cell size (pixel)")
    double cell_size;
    @Parameter
    RoiManager roi_manager;
    @Parameter(label="Create a combined tag, for instance 'A,Somite_6'")
    String combine_create_tag = "";
    @Parameter(type=ItemIO.OUTPUT)
    fiji.plugin.trackmate.Model tm_model;
    @Parameter
    Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AffineTransform3D proj_matrix = ImagePlusHelper.getMatrixFromImagePlus((ImagePlus)this.image);
        double angle_inc = proj_matrix.get(0, 0);
        double phi_0 = -proj_matrix.get(0, 3);
        double theta_0 = -proj_matrix.get(1, 3);
        double r_inc = -proj_matrix.get(2, 2);
        double r_0 = proj_matrix.get(2, 3);
        double[] matrix_double = new double[]{0.0, 0.0, r_inc, r_0, 0.0, angle_inc, 0.0, theta_0, angle_inc, 0.0, 0.0, phi_0};
        proj_matrix.set(matrix_double);
        System.out.println("Projected matrix = " + proj_matrix);
        String tag1 = null;
        String tag2 = null;
        if (this.combine_create_tag != null && !this.combine_create_tag.equals("") && this.combine_create_tag.split(",").length == 2) {
            tag1 = this.combine_create_tag.split(",")[0].trim();
            tag2 = this.combine_create_tag.split(",")[1].trim();
            IJ.log((String)("Creating combined tag tag_" + tag1 + " and " + tag2));
        } else {
            IJ.log((String)"Do not create combined tags");
        }
        try {
            this.roi_manager.reset();
            Elliptical3DTransform e3Dt = (Elliptical3DTransform)ScijavaGsonHelper.getGson((Context)this.context).fromJson((Reader)new FileReader(this.elliptical_transform_file), Elliptical3DTransform.class);
            Model model = (Model)this.app_model.getModel();
            ReentrantReadWriteLock.WriteLock lock = ((ModelGraph)model.getGraph()).getLock().writeLock();
            this.tm_model = new fiji.plugin.trackmate.Model();
            this.tm_model.setLogger(Logger.IJ_LOGGER);
            Settings settings = new Settings(this.image);
            settings.addAllAnalyzers();
            this.tm_model.beginUpdate();
            ArrayList allTags = new ArrayList();
            ArrayList<String> allTagsString = new ArrayList<String>();
            HashMap idToTags = new HashMap();
            try {
                lock.lock();
                RealPoint spotLocation = new RealPoint(3);
                HashMap<Integer, Spot> mastodonToTM = new HashMap<Integer, Spot>();
                model.getTagSetModel().getTagSetStructure().getTagSets().forEach(ts -> ts.getTags().forEach(tag -> {
                    allTags.add(tag);
                    allTagsString.add(tag.label());
                }));
                if (tag1 != null) {
                    allTagsString.add(tag1 + "_" + tag2);
                }
                MamutWarperCommand.declareFeatures(this.tm_model, allTagsString);
                allTags.forEach(tag -> model.getTagSetModel().getVertexTags().getTaggedWith(tag).forEach(spot -> {
                    int idx = spot.getInternalPoolIndex();
                    if (!idToTags.containsKey(spot.getInternalPoolIndex())) {
                        idToTags.put(idx, new ArrayList());
                    }
                    ((List)idToTags.get(idx)).add(tag);
                }));
                for (org.mastodon.mamut.model.Spot spot : ((ModelGraph)model.getGraph()).vertices()) {
                    spot.localize((RealPositionable)spotLocation);
                    int t = spot.getTimepoint();
                    e3Dt.inverse().apply((RealLocalizable)spotLocation, (RealPositionable)spotLocation);
                    proj_matrix.inverse().apply((RealLocalizable)spotLocation, (RealPositionable)spotLocation);
                    double x = spotLocation.getDoublePosition(0);
                    double y = spotLocation.getDoublePosition(1);
                    double z = spotLocation.getDoublePosition(2);
                    OvalRoi ovalRoi = new OvalRoi(x - this.cell_size / 2.0, y - this.cell_size / 2.0, this.cell_size, this.cell_size);
                    ovalRoi.setImage(this.image);
                    ovalRoi.setPosition(1, (int)(Math.round(z) + 1L), t + 1);
                    Spot tm_spot = new Spot(x * this.image.getCalibration().pixelHeight, y * this.image.getCalibration().pixelWidth, z * this.image.getCalibration().pixelDepth * 0.0, this.cell_size * this.image.getCalibration().pixelHeight, -1.0);
                    allTags.forEach(tag -> tm_spot.putFeature("tag_" + tag.label(), Double.valueOf(0.0)));
                    if (idToTags.containsKey(spot.getInternalPoolIndex())) {
                        ((List)idToTags.get(spot.getInternalPoolIndex())).forEach(tag -> tm_spot.putFeature("tag_" + tag.label(), Double.valueOf(1.0)));
                    }
                    if (tag1 != null) {
                        if (idToTags.containsKey(spot.getInternalPoolIndex())) {
                            List tags = (List)idToTags.get(spot.getInternalPoolIndex());
                            Set stringTags = tags.stream().map(TagSetStructure.Tag::label).collect(Collectors.toSet());
                            if (stringTags.contains(tag1) && stringTags.contains(tag2)) {
                                tm_spot.putFeature("tag_" + tag1 + "_" + tag2, Double.valueOf(1.0));
                            } else {
                                tm_spot.putFeature("tag_" + tag1 + "_" + tag2, Double.valueOf(0.0));
                            }
                        } else {
                            tm_spot.putFeature("tag_" + tag1 + "_" + tag2, Double.valueOf(0.0));
                        }
                    }
                    this.tm_model.addSpotTo(tm_spot, Integer.valueOf(t));
                    mastodonToTM.put(spot.getInternalPoolIndex(), tm_spot);
                    ovalRoi.setName(spot.getLabel() + "_T" + t);
                    this.roi_manager.addRoi((Roi)ovalRoi);
                }
                for (Edge edge : ((ModelGraph)model.getGraph()).edges()) {
                    int source_idx = ((org.mastodon.mamut.model.Spot)edge.getSource()).getInternalPoolIndex();
                    int target_idx = ((org.mastodon.mamut.model.Spot)edge.getTarget()).getInternalPoolIndex();
                    if (mastodonToTM.containsKey(source_idx) && mastodonToTM.containsKey(target_idx)) {
                        this.tm_model.addEdge((Spot)mastodonToTM.get(source_idx), (Spot)mastodonToTM.get(target_idx), -1.0);
                        continue;
                    }
                    IJ.log((String)"Missing source or target");
                }
                this.tm_model.notifyFeaturesComputed();
                ((ModelGraph)model.getGraph()).notifyGraphChanged();
                model.setUndoPoint();
                this.tm_model.endUpdate();
                SelectionModel tm_sm = new SelectionModel(this.tm_model);
                DisplaySettings ds = DisplaySettingsIO.readUserDefault();
                ds.setTrackColorBy(DisplaySettings.TrackMateObject.TRACKS, "TRACK_INDEX");
                ds.setSpotColorBy(DisplaySettings.TrackMateObject.TRACKS, "TRACK_INDEX");
                ds.setTrackDisplayMode(DisplaySettings.TrackDisplayMode.LOCAL_BACKWARD);
                ds.setLineThickness(3.0);
                TmXmlWriter writer = new TmXmlWriter(this.tm_file);
                writer.appendDisplaySettings(ds);
                writer.appendModel(this.tm_model);
                writer.appendSettings(settings);
                writer.writeToFile();
                HyperStackDisplayer view = new HyperStackDisplayer(this.tm_model, tm_sm, this.image, ds);
                view.render();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void declareFeatures(fiji.plugin.trackmate.Model tmModel, List<String> allTags) {
        ArrayList features = new ArrayList();
        HashMap featureNames = new HashMap();
        HashMap featureShortNames = new HashMap();
        HashMap featureDimensions = new HashMap();
        HashMap isIntFeature = new HashMap();
        allTags.forEach(tag -> {
            System.out.println("Declaring feature " + tag);
            features.add("tag_" + tag);
            featureNames.put("tag_" + tag, "tag_" + tag);
            featureShortNames.put("tag_" + tag, "tag_" + tag);
            featureDimensions.put("tag_" + tag, Dimension.NONE);
            isIntFeature.put("tag_" + tag, Boolean.TRUE);
        });
        tmModel.getFeatureModel().declareSpotFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
    }

    private static Elliptical3DTransform getEllipticalTransformFromImagePlus(ImagePlus image) throws UnsupportedOperationException {
        Elliptical3DTransform e3Dt = new Elliptical3DTransform();
        if (image.getInfoProperty() == null) {
            throw new UnsupportedOperationException("No elliptic transform found in image info");
        }
        if (image.getInfoProperty() != null) {
            Pattern pattern = Pattern.compile("(\"ellipse_params\":)((?s).*)(})");
            Matcher matcher = pattern.matcher(image.getInfoProperty());
            if (matcher.find()) {
                String ellipticalTransformString = matcher.group(2).replace("{", "").replace("}", "");
                HashMap<String, Double> parameters = new HashMap<String, Double>();
                String[] linesParam = ellipticalTransformString.split(",");
                HashSet<String> params = new HashSet<String>();
                params.addAll(e3Dt.getParameters().keySet());
                for (String line : linesParam) {
                    String[] args = line.split(":");
                    if (args.length != 2) {
                        throw new UnsupportedOperationException("Error in parsing elliptical transform. Invalid number of args in line " + line);
                    }
                    Double value = Double.parseDouble(args[1]);
                    Optional<String> key = params.stream().filter(k -> args[0].contains((CharSequence)k)).findFirst();
                    if (!key.isPresent()) {
                        throw new UnsupportedOperationException("No matching elliptical parameter found with line " + args[0]);
                    }
                    parameters.put(key.get(), value);
                }
                e3Dt.setParameters(parameters);
            } else {
                throw new UnsupportedOperationException("No elliptic transform found in image info");
            }
        }
        return e3Dt;
    }
}

