/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.gui.graphicalhandle;

import bdv.viewer.SynchronizedViewerState;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.function.Supplier;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class XYRectangleGraphicalHandle
extends GraphicalHandle {
    final SynchronizedViewerState state;
    final Supplier<RealPoint> globalCoord;
    final Supplier<Double> sizeX;
    final Supplier<Double> sizeY;
    final Supplier<Integer[]> color;
    RealPoint pta;
    RealPoint ptb;
    RealPoint ptc;
    RealPoint ptd;
    Stroke normalStroke = new BasicStroke(2.5f);
    Integer r = 4;

    public XYRectangleGraphicalHandle(Behaviours behaviours, TriggerBehaviourBindings bindings, String nameMap, SynchronizedViewerState state, Supplier<RealPoint> globalCoord, Supplier<Double> sizeX, Supplier<Double> sizeY, Supplier<Integer[]> color) {
        super(null, behaviours, bindings, nameMap);
        this.state = state;
        this.globalCoord = globalCoord;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.color = color;
        this.pta = new RealPoint(3);
        this.ptb = new RealPoint(3);
        this.ptc = new RealPoint(3);
        this.ptd = new RealPoint(3);
    }

    public XYRectangleGraphicalHandle(SynchronizedViewerState state, Supplier<RealPoint> globalCoord, Supplier<Double> sizeX, Supplier<Double> sizeY, Supplier<Integer[]> color) {
        this(null, null, null, state, globalCoord, sizeX, sizeY, color);
    }

    @Override
    protected void enabledDraw(Graphics2D g) {
        RealPoint pt = new RealPoint(3);
        RealPoint ori = this.globalCoord.get();
        this.state.getViewerTransform().apply((RealLocalizable)ori, (RealPositionable)pt);
        int[] centerPos = new int[]{(int)pt.getDoublePosition(0), (int)pt.getDoublePosition(1), 0};
        Integer[] c = this.color.get();
        g.setColor(new Color(c[0], c[1], c[2], c[3]));
        double displayR = this.r.intValue();
        if (this.mouseAbove) {
            displayR *= 1.6;
        }
        g.fillOval((int)((double)centerPos[0] - displayR), (int)((double)centerPos[1] - displayR), (int)(2.0 * displayR), (int)(2.0 * displayR));
        double sx = this.sizeX.get();
        double sy = this.sizeY.get();
        this.pta.setPosition((RealLocalizable)ori);
        this.pta.setPosition(this.pta.getDoublePosition(0) + sx / 2.0, 0);
        this.pta.setPosition(this.pta.getDoublePosition(1) + sy / 2.0, 1);
        this.ptb.setPosition((RealLocalizable)ori);
        this.ptb.setPosition(this.ptb.getDoublePosition(0) + sx / 2.0, 0);
        this.ptb.setPosition(this.ptb.getDoublePosition(1) - sy / 2.0, 1);
        this.ptc.setPosition((RealLocalizable)ori);
        this.ptc.setPosition(this.ptc.getDoublePosition(0) - sx / 2.0, 0);
        this.ptc.setPosition(this.ptc.getDoublePosition(1) - sy / 2.0, 1);
        this.ptd.setPosition((RealLocalizable)ori);
        this.ptd.setPosition(this.ptd.getDoublePosition(0) - sx / 2.0, 0);
        this.ptd.setPosition(this.ptd.getDoublePosition(1) + sy / 2.0, 1);
        this.state.getViewerTransform().apply((RealLocalizable)this.pta, (RealPositionable)this.pta);
        this.state.getViewerTransform().apply((RealLocalizable)this.ptb, (RealPositionable)this.ptb);
        this.state.getViewerTransform().apply((RealLocalizable)this.ptc, (RealPositionable)this.ptc);
        this.state.getViewerTransform().apply((RealLocalizable)this.ptd, (RealPositionable)this.ptd);
        g.setStroke(this.normalStroke);
        g.drawLine((int)this.pta.getDoublePosition(0), (int)this.pta.getDoublePosition(1), (int)this.ptb.getDoublePosition(0), (int)this.ptb.getDoublePosition(1));
        g.drawLine((int)this.ptc.getDoublePosition(0), (int)this.ptc.getDoublePosition(1), (int)this.ptb.getDoublePosition(0), (int)this.ptb.getDoublePosition(1));
        g.drawLine((int)this.ptc.getDoublePosition(0), (int)this.ptc.getDoublePosition(1), (int)this.ptd.getDoublePosition(0), (int)this.ptd.getDoublePosition(1));
        g.drawLine((int)this.pta.getDoublePosition(0), (int)this.pta.getDoublePosition(1), (int)this.ptd.getDoublePosition(0), (int)this.ptd.getDoublePosition(1));
    }

    @Override
    protected void disabledDraw(Graphics2D g) {
        this.enabledDraw(g);
    }

    @Override
    boolean isPresentAt(int x, int y) {
        double r;
        int[] pos = this.getScreenCoordinates();
        double d = (pos[0] - x) * (pos[0] - x) + (pos[1] - y) * (pos[1] - y);
        return d < (r = (double)this.r.intValue()) * r;
    }

    @Override
    public int[] getScreenCoordinates() {
        RealPoint pt = new RealPoint(3);
        this.state.getViewerTransform().apply((RealLocalizable)this.globalCoord.get(), (RealPositionable)pt);
        return new int[]{(int)pt.getDoublePosition(0), (int)pt.getDoublePosition(1), 0};
    }
}

