/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.gui.graphicalhandle;

import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.function.Supplier;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class SquareGraphicalHandle
extends GraphicalHandle {
    Supplier<Integer[]> coords;
    Supplier<Integer> radius;
    Supplier<Integer[]> color;

    public SquareGraphicalHandle(GraphicalHandleListener ghl, Behaviours behaviours, TriggerBehaviourBindings bindings, String nameMap, Supplier<Integer[]> coords, Supplier<Integer> radius, Supplier<Integer[]> color) {
        super(ghl, behaviours, bindings, nameMap);
        this.radius = radius;
        this.color = color;
        this.coords = coords;
    }

    public SquareGraphicalHandle(GraphicalHandleListener ghl, Behaviour behaviour, String behaviourName, String trigger, TriggerBehaviourBindings bindings, Supplier<Integer[]> coords, Supplier<Integer> radius, Supplier<Integer[]> color) {
        super(ghl, SquareGraphicalHandle.wrapBehaviours(behaviour, behaviourName, trigger), bindings, behaviour.toString());
        this.radius = radius;
        this.color = color;
        this.coords = coords;
    }

    static Behaviours wrapBehaviours(Behaviour behaviour, String behaviourName, String trigger) {
        Behaviours behaviours = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]);
        behaviours.behaviour(behaviour, behaviourName, new String[]{trigger});
        return behaviours;
    }

    @Override
    public synchronized void enabledDraw(Graphics2D g) {
        Integer r = this.radius.get();
        Integer[] pos = this.coords.get();
        Integer[] c = this.color.get();
        g.setColor(new Color(c[0], c[1], c[2], c[3]));
        if (this.mouseAbove) {
            r = (int)((double)r.intValue() * 1.2);
        }
        g.fillRect(pos[0] - r, pos[1] - r, 2 * r, 2 * r);
    }

    @Override
    public synchronized void disabledDraw(Graphics2D g) {
    }

    @Override
    synchronized boolean isPresentAt(int x, int y) {
        Integer[] pos = this.coords.get();
        double r = this.radius.get().intValue();
        if (pos == null || pos[0] == null || pos[1] == null) {
            return false;
        }
        return (double)x > (double)pos[0].intValue() - r && (double)x < (double)pos[0].intValue() + r && (double)y > (double)pos[1].intValue() - r && (double)y < (double)pos[1].intValue() + r;
    }

    @Override
    public int[] getScreenCoordinates() {
        int[] unboxed = new int[3];
        Integer[] c = this.coords.get();
        for (int i = 0; i < 3; ++i) {
            unboxed[i] = c[i];
        }
        return unboxed;
    }
}

