/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.gui.graphicalhandle;

import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;

public class GraphicalHandleToolTip
extends GraphicalHandle
implements GraphicalHandleListener {
    final GraphicalHandle gh;
    Supplier<String> toolTipText;
    int shiftX;
    int shiftY;

    public GraphicalHandleToolTip(GraphicalHandle gh, Supplier<String> toolTip, int shiftX, int shiftY) {
        super(null, null, null, null);
        this.gh = gh;
        this.toolTipText = toolTip;
        this.gh.addGraphicalHandleListener(this);
        this.shiftX = shiftX;
        this.shiftY = shiftY;
    }

    public GraphicalHandleToolTip(GraphicalHandle gh, String text, int shiftX, int shiftY) {
        super(null, null, null, null);
        this.gh = gh;
        this.toolTipText = () -> text;
        this.gh.addGraphicalHandleListener(this);
        this.shiftX = shiftX;
        this.shiftY = shiftY;
    }

    @Override
    public void disabled(GraphicalHandle src) {
        if (src == this.gh) {
            this.disable();
        }
    }

    @Override
    public void enabled(GraphicalHandle src) {
        if (src == this.gh) {
            this.enable();
        }
    }

    @Override
    public void hover_in(GraphicalHandle src) {
    }

    @Override
    public void hover_out(GraphicalHandle src) {
    }

    @Override
    public void created(GraphicalHandle src) {
    }

    @Override
    public void removed(GraphicalHandle src) {
    }

    @Override
    protected void enabledDraw(Graphics2D g) {
        Rectangle bounds = g.getClip().getBounds();
        int[] pos = this.gh.getScreenCoordinates();
        Integer[] c = new Integer[]{255, 255, 255, 128};
        g.setColor(new Color(c[0], c[1], c[2], c[3]));
        g.setFont(new Font("TimesRoman", 0, 16));
        int xPos = pos[0] - 40 + this.shiftX;
        int yPos = pos[1] - 50 + this.shiftY;
        if (xPos > bounds.width - 70) {
            xPos = bounds.width - 70;
        }
        if (xPos < 0) {
            xPos = 0;
        }
        if (yPos > bounds.height - 30) {
            yPos = bounds.height - 30;
        }
        if (yPos < 30) {
            yPos = 30;
        }
        g.drawString(this.toolTipText.get(), xPos, yPos);
    }

    @Override
    protected void disabledDraw(Graphics2D g) {
    }

    @Override
    boolean isPresentAt(int x, int y) {
        return false;
    }

    @Override
    public int[] getScreenCoordinates() {
        return this.gh.getScreenCoordinates();
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
    }
}

