/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.gui.graphicalhandle;

import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphicalHandle
extends MouseMotionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(GraphicalHandle.class);
    final List<GraphicalHandleListener> ghls = new ArrayList<GraphicalHandleListener>();
    final Behaviours behaviours;
    final TriggerBehaviourBindings bindings;
    final String nameMap;
    boolean mouseAbove = false;
    protected boolean isDisabled = false;

    public GraphicalHandle(GraphicalHandleListener ghl, Behaviours behaviours, TriggerBehaviourBindings bindings, String nameMap) {
        this.addGraphicalHandleListener(ghl);
        this.behaviours = behaviours;
        this.bindings = bindings;
        this.nameMap = nameMap;
        if (ghl != null) {
            ghl.created(this);
        }
    }

    public void addGraphicalHandleListener(GraphicalHandleListener ghl) {
        if (ghl != null) {
            this.ghls.add(ghl);
        }
    }

    public void removeGraphicalHandleListener(GraphicalHandleListener ghl) {
        this.ghls.remove(ghl);
    }

    public void draw(Graphics2D g) {
        if (!this.isDisabled) {
            this.enabledDraw(g);
        } else {
            this.disabledDraw(g);
        }
    }

    protected abstract void enabledDraw(Graphics2D var1);

    protected abstract void disabledDraw(Graphics2D var1);

    public void remove() {
        this.ghls.forEach(ghl -> ghl.removed(this));
    }

    abstract boolean isPresentAt(int var1, int var2);

    public boolean isMouseOver() {
        return this.mouseAbove;
    }

    public synchronized void disable() {
        if (!this.isDisabled) {
            if (this.mouseAbove) {
                this.mouseAbove = false;
                this.ghls.forEach(ghl -> ghl.hover_out(this));
            }
            this.isDisabled = true;
            this.ghls.forEach(ghl -> ghl.disabled(this));
            logger.debug("Removing " + this.nameMap + " from " + this + " (disable called) ");
            if (this.bindings != null) {
                this.bindings.removeBehaviourMap(this.nameMap);
                this.bindings.removeInputTriggerMap(this.nameMap);
            }
        }
    }

    public Behaviours getBehaviours() {
        return this.behaviours;
    }

    public abstract int[] getScreenCoordinates();

    public synchronized void enable() {
        if (this.isDisabled) {
            this.isDisabled = false;
            this.ghls.forEach(ghl -> ghl.enabled(this));
        }
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX();
        if (this.isPresentAt(x, y = e.getY())) {
            if (!this.mouseAbove && !this.isDisabled) {
                this.mouseAbove = true;
                this.ghls.forEach(ghl -> ghl.hover_in(this));
                if (this.bindings != null && this.behaviours != null) {
                    this.behaviours.install(this.bindings, this.nameMap);
                }
                logger.debug("Installing " + this.nameMap + " from " + this + " (x = " + x + " and y = " + y + ")");
            }
        } else if (this.mouseAbove) {
            this.mouseAbove = false;
            this.ghls.forEach(ghl -> ghl.hover_out(this));
            logger.debug("Removing " + this.nameMap + " from " + this + " (x = " + x + " and y = " + y + ")");
            if (this.bindings != null) {
                this.bindings.removeBehaviourMap(this.nameMap);
                this.bindings.removeInputTriggerMap(this.nameMap);
            }
        }
    }
}

