/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.gui.graphicalhandle;

import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.function.Supplier;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class CircleGraphicalHandle
extends GraphicalHandle {
    Supplier<Integer[]> coords;
    Supplier<Integer> radius;
    Supplier<Integer[]> color;

    public CircleGraphicalHandle(GraphicalHandleListener ghl, Behaviours behaviours, TriggerBehaviourBindings bindings, String nameMap, Supplier<Integer[]> coords, Supplier<Integer> radius, Supplier<Integer[]> color) {
        super(ghl, behaviours, bindings, nameMap);
        this.radius = radius;
        this.color = color;
        this.coords = coords;
    }

    public CircleGraphicalHandle(GraphicalHandleListener ghl, Behaviour behaviour, String behaviourName, String trigger, TriggerBehaviourBindings bindings, Supplier<Integer[]> coords, Supplier<Integer> radius, Supplier<Integer[]> color) {
        super(ghl, CircleGraphicalHandle.wrapBehaviours(behaviour, behaviourName, trigger), bindings, behaviour.toString());
        this.radius = radius;
        this.color = color;
        this.coords = coords;
    }

    static Behaviours wrapBehaviours(Behaviour behaviour, String behaviourName, String trigger) {
        Behaviours behaviours = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]);
        behaviours.behaviour(behaviour, behaviourName, new String[]{trigger});
        return behaviours;
    }

    @Override
    public synchronized void enabledDraw(Graphics2D g) {
        Integer r = this.radius.get();
        Integer[] pos = this.coords.get();
        Integer[] c = this.color.get();
        g.setColor(new Color(c[0], c[1], c[2], c[3]));
        if (this.mouseAbove) {
            r = (int)((double)r.intValue() * 1.2);
        }
        g.fillOval(pos[0] - r, pos[1] - r, 2 * r, 2 * r);
    }

    @Override
    public synchronized void disabledDraw(Graphics2D g) {
    }

    @Override
    synchronized boolean isPresentAt(int x, int y) {
        double dy;
        Integer[] pos = this.coords.get();
        double r = this.radius.get().intValue();
        if (pos == null || pos[0] == null || pos[1] == null) {
            return false;
        }
        double dx = (double)pos[0].intValue() - (double)x;
        double d2 = dx * dx + (dy = (double)pos[1].intValue() - (double)y) * dy;
        return d2 < r * r;
    }

    @Override
    public int[] getScreenCoordinates() {
        int[] unboxed = new int[3];
        Integer[] c = this.coords.get();
        for (int i = 0; i < 3; ++i) {
            unboxed[i] = c[i];
        }
        return unboxed;
    }
}

