/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.ImagePlusToOMETiff;
import ch.epfl.biop.bdv.img.legacy.bioformats.command.BasicOpenFilesWithBigdataviewerBioformatsBridgeCommand;
import ch.epfl.biop.bdv.img.legacy.bioformats.command.BioformatsBigdataviewerBridgeDatasetCommand;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.SeriesNumber;
import ch.epfl.biop.scijava.command.source.ExportToMultipleImagePlusCommand;
import ch.epfl.biop.sourceandconverter.exporter.IntRangeParser;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.Scaler;
import ij.plugin.ZProjector;
import ij.process.ImageConverter;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.Context;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterServiceUI;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

public class OMETiffMultiSeriesProcessorExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> export(Builder builder) throws Exception {
        TaskService taskService = (TaskService)builder.ctx.getService(TaskService.class);
        File image_file = new File(builder.image_file_path);
        Task task = taskService.createTask("OME TIFF conversion " + image_file.getName());
        task.setStatusMessage("Parsing file metadata...");
        SourceAndConverterService sac_service = (SourceAndConverterService)builder.ctx.getService(SourceAndConverterService.class);
        CommandService command = (CommandService)builder.ctx.getService(CommandService.class);
        String datasetName = builder.image_file_path;
        Map options = BioformatsBigdataviewerBridgeDatasetCommand.getDefaultParameters();
        options.put("datasetname", datasetName);
        options.put("unit", "MICROMETER");
        options.put("files", new File[]{image_file});
        options.put("splitrgbchannels", false);
        options.put("numberofblockskeptinmemory", 1);
        if (builder.cacheSizeX > 0 && builder.cacheSizeY > 0) {
            options.put("usebioformatscacheblocksize", false);
            options.put("cachesizex", builder.cacheSizeX);
            options.put("cachesizey", builder.cacheSizeY);
            options.put("cachesizez", 1);
        }
        AbstractSpimData spimdata = (AbstractSpimData)((CommandModule)command.run(BasicOpenFilesWithBigdataviewerBioformatsBridgeCommand.class, true, options).get()).getOutput("spimdata");
        List allSources = sac_service.getSourceAndConverterFromSpimdata(spimdata);
        if (builder.removeZOffset.booleanValue()) {
            for (SourceAndConverter source : allSources) {
                RealPoint center = SourceAndConverterHelper.getSourceAndConverterCenterPoint((SourceAndConverter)source, (int)0);
                AffineTransform3D zOffset = new AffineTransform3D();
                zOffset.translate(new double[]{0.0, 0.0, center.getDoublePosition(2)});
                int maxTimePoint = SourceAndConverterHelper.getMaxTimepoint((Source)source.getSpimSource());
                SourceTransformHelper.append((AffineTransform3D)zOffset.inverse(), (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(source, 0, maxTimePoint));
            }
        }
        SourceAndConverterServiceUI.Node seriesNode = sac_service.getUI().getRoot().child(datasetName).child(SeriesNumber.class.getSimpleName());
        System.out.println("nSeries = " + seriesNode.children().size());
        List<Integer> rangeSeries = new IntRangeParser(builder.rangeS).get(seriesNode.children().size());
        int number_of_series = rangeSeries.size();
        task.setProgressMaximum((long)number_of_series);
        AtomicInteger iImage = new AtomicInteger();
        Instant start = Instant.now();
        task.setStatusMessage("Conversion in progress");
        ConcurrentHashMap<String, String> outputMap = new ConcurrentHashMap<String, String>();
        ForkJoinPool pool = new ForkJoinPool(builder.n_threads);
        Callable<Object> c = () -> {
            rangeSeries.parallelStream().forEach(index -> {
                SourceAndConverterServiceUI.Node currentSeriesNode = seriesNode.child(index.intValue());
                try {
                    Calibration cal;
                    String iniTitle;
                    List ij1_images = (List)((CommandModule)command.run(ExportToMultipleImagePlusCommand.class, false, new Object[]{"sacs", currentSeriesNode.sources(), "level", 0, "range_frames", builder.rangeT, "range_channels", builder.rangeC, "range_slices", builder.rangeZ, "export_mode", "Virtual no-cache", "parallel", Boolean.TRUE, "verbose", Boolean.TRUE}).get()).getOutput("imps_out");
                    if (ij1_images.size() != 1) {
                        IJ.log((String)"ERROR : ONE IMAGE EXPECTED, MULTIPLE ONES FOUND");
                    }
                    ImagePlus image = (ImagePlus)ij1_images.get(0);
                    image.setTitle(currentSeriesNode.name());
                    IJ.log((String)("Processing " + image.getTitle()));
                    if (builder.z_project.booleanValue()) {
                        iniTitle = image.getTitle();
                        cal = image.getCalibration().copy();
                        int initialBitDepth = image.getBitDepth();
                        if (image.getNFrames() > 1 && image.getNSlices() == 1) {
                            image = ZProjector.run((ImagePlus)image, (String)"max");
                        } else {
                            ZProjector zp = new ZProjector();
                            zp.setImage(image);
                            zp.setMethod(Arrays.asList(ZProjector.METHODS).indexOf(builder.z_project_method));
                            zp.setStopSlice(image.getNSlices());
                            if (image.getNSlices() > 1 || image.getNFrames() > 1) {
                                zp.doHyperStackProjection(true);
                            }
                            image = zp.getProjection();
                        }
                        image.setTitle(iniTitle + "_ZProj_" + builder.z_project_method);
                        cal.zOrigin = 0.0;
                        image.setCalibration(cal);
                        if (image.getBitDepth() != initialBitDepth) {
                            ImageConverter ic = new ImageConverter(image);
                            ImageConverter.setDoScaling((boolean)false);
                            switch (initialBitDepth) {
                                case 8: {
                                    ic.convertToGray8();
                                    break;
                                }
                                case 16: {
                                    ic.convertToGray16();
                                    break;
                                }
                                default: {
                                    IJ.log((String)("Conversion from " + image.getBitDepth() + " to " + initialBitDepth + " unsupported"));
                                }
                            }
                        }
                    }
                    if (builder.resize_xy != 1) {
                        iniTitle = image.getTitle();
                        cal = image.getCalibration().copy();
                        cal.pixelWidth *= (double)builder.resize_xy.intValue();
                        cal.pixelHeight *= (double)builder.resize_xy.intValue();
                        cal.xOrigin /= (double)builder.resize_xy.intValue();
                        cal.yOrigin /= (double)builder.resize_xy.intValue();
                        image = Scaler.resize((ImagePlus)image, (int)(image.getWidth() / builder.resize_xy), (int)(image.getHeight() / builder.resize_xy), (int)image.getNSlices(), (String)"bilinear");
                        image.setTitle(iniTitle + "_RescaledXY_" + builder.resize_xy);
                        image.setCalibration(cal);
                    }
                    String prefix = "";
                    if (builder.appendFileName) {
                        prefix = image_file.getName() + "-";
                    }
                    String totalPath = builder.output_directory + File.separator + prefix + image.getTitle() + ".ome.tiff";
                    if (builder.overrideCalibration.containsKey(index)) {
                        image.setCalibration(builder.overrideCalibration.get(index));
                    }
                    ImagePlus finalImage = image;
                    new Thread(() -> {
                        try {
                            ImagePlusToOMETiff.writeToOMETiff((ImagePlus)finalImage, (File)new File(totalPath), (String)builder.compression, (TaskService)taskService);
                            outputMap.put(finalImage.getTitle(), totalPath);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Class<OMETiffMultiSeriesProcessorExporter> clazz = OMETiffMultiSeriesProcessorExporter.class;
                        synchronized (OMETiffMultiSeriesProcessorExporter.class) {
                            OMETiffMultiSeriesProcessorExporter.printTimingMessage(start, (double)iImage.incrementAndGet() / (double)number_of_series * 100.0);
                            long currentProgress = iImage.get();
                            task.setProgressValue(currentProgress);
                            if (currentProgress == (long)number_of_series) {
                                task.run(() -> {});
                            }
                            AtomicInteger atomicInteger = iImage;
                            synchronized (atomicInteger) {
                                iImage.notify();
                            }
                            // ** MonitorExit[var9_10] (shouldn't be in output)
                            return;
                        }
                    }).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            return null;
        };
        ((ForkJoinTask)pool.submit(c)).get();
        while (iImage.get() != number_of_series) {
            AtomicInteger atomicInteger = iImage;
            synchronized (atomicInteger) {
                iImage.wait();
            }
        }
        sac_service.remove(allSources.toArray(new SourceAndConverter[0]));
        return outputMap;
    }

    public static void printTimingMessage(Instant start, double percentageCompleteness) {
        long s = Duration.between(start, Instant.now()).getSeconds();
        String elapsedTime = String.format("%d:%02d:%02d", (int)(s / 3600L), (int)(s % 3600L / 60L), (int)(s % 60L));
        double sPerPC = (double)s / percentageCompleteness;
        long sRemaining = (long)((100.0 - percentageCompleteness) * sPerPC);
        String remainingTime = String.format("%d:%02d:%02d", (int)(sRemaining / 3600L), (int)(sRemaining % 3600L / 60L), (int)(sRemaining % 60L));
        LocalDateTime estimateDoneJob = LocalDateTime.now().plus(Duration.ofSeconds(sRemaining));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        long nDays = sRemaining / 86400L;
        String daysMessage = "";
        if (nDays == 1L) {
            daysMessage = daysMessage + " tomorrow.";
        }
        if (nDays == 1L) {
            daysMessage = daysMessage + " in " + nDays + " days.";
        }
        String formatDateTime = estimateDoneJob.format(formatter);
        if ((int)percentageCompleteness == 100) {
            String message = " -  Task completed. Elapsed time:" + elapsedTime + ".";
            IJ.log((String)message);
        } else {
            String message = " -  Task " + (int)percentageCompleteness + " % completed. Elapsed time:" + elapsedTime + ". Estimated remaining time: " + remainingTime + ". Job done at around " + formatDateTime + daysMessage;
            IJ.log((String)message);
        }
    }

    public static Builder builder(Context ctx) {
        Builder builder = new Builder();
        builder.ctx = ctx;
        return builder;
    }

    public static class Builder {
        String image_file_path;
        Boolean z_project = false;
        String z_project_method = "";
        Integer resize_xy = 1;
        String output_directory;
        Integer n_threads = 0;
        Integer nResolutionLevels = 1;
        Integer downscaleFactor = 1;
        String compression = "Uncompressed";
        Boolean removeZOffset = false;
        Context ctx;
        int cacheSizeX = -1;
        int cacheSizeY = -1;
        String rangeS = "";
        String rangeC = "";
        String rangeZ = "";
        String rangeT = "";
        Map<Integer, Calibration> overrideCalibration = new HashMap<Integer, Calibration>();
        boolean appendFileName = false;

        public Builder file(File f) {
            this.image_file_path = f.getAbsolutePath();
            if (this.output_directory == null) {
                this.output_directory = f.getParent();
            }
            return this;
        }

        public Builder appendFileName() {
            this.appendFileName = true;
            return this;
        }

        public Builder outputFolder(String path) {
            this.output_directory = path;
            return this;
        }

        public Builder rangeS(String rangeS) {
            this.rangeS = rangeS;
            return this;
        }

        public Builder setCalibration(int series, Calibration calibration) {
            this.overrideCalibration.put(series, calibration);
            return this;
        }

        public Builder rangeC(String rangeC) {
            this.rangeC = rangeC;
            return this;
        }

        public Builder cacheSize(int cacheSizeX, int cacheSizeY) {
            this.cacheSizeX = cacheSizeX;
            this.cacheSizeY = cacheSizeY;
            return this;
        }

        public Builder rangeZ(String rangeZ) {
            this.rangeZ = rangeZ;
            return this;
        }

        public Builder rangeT(String rangeT) {
            this.rangeT = rangeT;
            return this;
        }

        public Builder nThreads(int nThreads) {
            this.n_threads = nThreads;
            return this;
        }

        public Builder nResolutionLevels(int nResolutionLevels) {
            this.nResolutionLevels = nResolutionLevels;
            return this;
        }

        public Builder downscaleFactorLevels(int downscaleFactor) {
            this.downscaleFactor = downscaleFactor;
            return this;
        }

        public Builder projectMax() {
            this.z_project = true;
            this.z_project_method = "Max Intensity";
            this.removeZOffset = true;
            return this;
        }

        public Builder removeZOffsets() {
            this.removeZOffset = true;
            return this;
        }

        public Builder projectMin() {
            this.z_project = true;
            this.z_project_method = "Min Intensity";
            this.removeZOffset = true;
            return this;
        }

        public Builder projectSum() {
            this.z_project = true;
            this.z_project_method = "Sum Slices";
            this.removeZOffset = true;
            return this;
        }

        public Builder projectStDev() {
            this.z_project = true;
            this.z_project_method = "Standard Deviation";
            this.removeZOffset = true;
            return this;
        }

        public Builder projectMedian() {
            this.z_project = true;
            this.z_project_method = "Median";
            this.removeZOffset = true;
            return this;
        }

        public Builder projectAverage() {
            this.z_project = true;
            this.z_project_method = "Average Intensity";
            this.removeZOffset = true;
            return this;
        }

        public Builder lzw() {
            this.compression = "LZW";
            return this;
        }

        public Map<String, String> export() {
            try {
                return OMETiffMultiSeriesProcessorExporter.export(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

