/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.time;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.function.Function;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;

public class MappedTimeSource<T>
implements Source<T> {
    final Source<T> origin;
    Function<Integer, Integer> mappedTime;
    final String name;

    public MappedTimeSource(Source<T> origin, String name, Function<Integer, Integer> mappedTime) {
        this.origin = origin;
        this.mappedTime = mappedTime;
        this.name = name;
    }

    public boolean isPresent(int t) {
        return this.origin.isPresent(this.mappedTime.apply(t).intValue());
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return this.origin.getSource(this.mappedTime.apply(t).intValue(), level);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.origin.getInterpolatedSource(this.mappedTime.apply(t).intValue(), level, method);
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.origin.getSourceTransform(this.mappedTime.apply(t).intValue(), level, transform);
    }

    public T getType() {
        return (T)this.origin.getType();
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.origin.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.origin.getNumMipmapLevels();
    }
}

