/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.process;

import bdv.util.DefaultInterpolators;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class VoxelProcessedSource<I, O extends NumericType<O>>
implements Source<O> {
    protected final DefaultInterpolators<O> interpolators = new DefaultInterpolators();
    final Processor<I, O> processor;
    final Source<I> origin;
    final String name;
    final O o;

    public VoxelProcessedSource(String name, Source<I> origin, Processor<I, O> processor, O o) {
        this.name = name;
        this.origin = origin;
        this.processor = processor;
        this.o = o;
    }

    public boolean isPresent(int t) {
        return this.origin.isPresent(t);
    }

    public RandomAccessibleInterval<O> getSource(int t, int level) {
        return this.processor.process(this.origin.getSource(t, level), t, level);
    }

    public RealRandomAccessible<O> getInterpolatedSource(int t, int level, Interpolation method) {
        O zero = this.getType();
        zero.setZero();
        ExtendedRandomAccessibleInterval eView = Views.extend(this.getSource(t, level), (OutOfBoundsFactory)new OutOfBoundsConstantValueFactory(zero));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
        return realRandomAccessible;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.origin.getSourceTransform(t, level, transform);
    }

    public O getType() {
        return (O)((NumericType)this.o.createVariable());
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.origin.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.origin.getNumMipmapLevels();
    }

    public static interface Processor<I, O> {
        public RandomAccessibleInterval<O> process(RandomAccessibleInterval<I> var1, int var2, int var3);
    }
}

