/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.process;

import bdv.util.DefaultInterpolators;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.cache.GlobalLoaderCache;

public class LazyDownscaledXY2Source<T extends RealType<T> & NativeType<T>>
implements Source<T> {
    protected final DefaultInterpolators<T> interpolators = new DefaultInterpolators();
    final Source<T> origin;
    final String name;
    final int nResolutionLevels;
    Map<Integer, Map<Integer, RandomAccessibleInterval<T>>> sources = new HashMap<Integer, Map<Integer, RandomAccessibleInterval<T>>>();

    public LazyDownscaledXY2Source(String name, Source<T> origin) {
        int nResolutionLevels;
        this.name = name;
        this.origin = origin;
        long maxX = origin.getSource(0, 0).max(0);
        long maxY = origin.getSource(0, 0).max(1);
        for (nResolutionLevels = 1; nResolutionLevels < 6 && maxX > 64L && maxY > 64L; ++nResolutionLevels) {
            maxX = (long)((double)maxX / 2.0);
            maxY = (long)((double)maxY / 2.0);
        }
        this.nResolutionLevels = nResolutionLevels;
    }

    public boolean isPresent(int t) {
        return this.origin.isPresent(t);
    }

    private static int tileSize(int level) {
        return (int)Math.pow(2.0, 8 - level);
    }

    private void buildSources(int t) {
        this.sources.put(t, new HashMap());
        this.sources.get(t).put(0, this.origin.getSource(t, 0));
        for (int level = 1; level < this.nResolutionLevels; ++level) {
            int tileSizeLevel = LazyDownscaledXY2Source.tileSize(level);
            int[] cellDimensions = new int[]{tileSizeLevel, tileSizeLevel, 1};
            RandomAccessibleInterval<T> raiBelow = this.sources.get(t).get(level - 1);
            long[] newDimensions = new long[]{raiBelow.dimensionsAsLongArray()[0] / 2L, raiBelow.dimensionsAsLongArray()[1] / 2L, raiBelow.dimensionsAsLongArray()[2]};
            CellGrid grid = new CellGrid(newDimensions, cellDimensions);
            IntervalView rai = Views.expandBorder(raiBelow, (long[])new long[]{1L, 1L, 0L});
            SubsampleIntervalView rai00 = Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L});
            SubsampleIntervalView rai01 = Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])raiBelow.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L});
            SubsampleIntervalView rai10 = Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])raiBelow.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L});
            SubsampleIntervalView rai11 = Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])raiBelow.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L});
            LoadedCellCacheLoader loader = LoadedCellCacheLoader.get((CellGrid)grid, arg_0 -> LazyDownscaledXY2Source.lambda$buildSources$0((RandomAccessibleInterval)rai00, (RandomAccessibleInterval)rai01, (RandomAccessibleInterval)rai10, (RandomAccessibleInterval)rai11, arg_0), (NativeType)((NativeType)this.getType().createVariable()), (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE));
            Cache cache = new GlobalLoaderCache((Object)this, t, level).withLoader((CacheLoader)loader);
            CachedCellImg img = new CachedCellImg(grid, (NativeType)this.getType(), cache, (DataAccess)ArrayDataAccessFactory.get((NativeType)((NativeType)this.getType()), (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
            this.sources.get(t).put(level, (RandomAccessibleInterval<T>)img);
        }
    }

    public synchronized RandomAccessibleInterval<T> getSource(int t, int level) {
        if (!this.sources.containsKey(t)) {
            this.buildSources(t);
        }
        return this.sources.get(t).get(level);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        T zero = this.getType();
        zero.setZero();
        return Views.interpolate((EuclideanSpace)Views.extendZero(this.getSource(t, level)), (InterpolatorFactory)this.interpolators.get(method));
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        if (level == 0) {
            this.origin.getSourceTransform(t, level, transform);
        } else {
            this.origin.getSourceTransform(t, 0, transform);
            double[] tr = transform.getTranslation();
            transform.translate(new double[]{-tr[0], -tr[1], -tr[2]});
            transform.scale(Math.pow(2.0, level), Math.pow(2.0, level), 1.0);
            transform.translate(tr);
        }
    }

    public T getType() {
        return (T)((RealType)this.origin.getType());
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.origin.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.nResolutionLevels;
    }

    private static /* synthetic */ void lambda$buildSources$0(RandomAccessibleInterval rai00, RandomAccessibleInterval rai01, RandomAccessibleInterval rai10, RandomAccessibleInterval rai11, SingleCellArrayImg cell) throws Exception {
        Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)rai00, (Interval)cell)).cursor();
        Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)rai01, (Interval)cell)).cursor();
        Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)rai10, (Interval)cell)).cursor();
        Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)rai11, (Interval)cell)).cursor();
        Cursor out = Views.flatIterable((RandomAccessibleInterval)cell).cursor();
        while (out.hasNext()) {
            float val = ((RealType)c00.next()).getRealFloat() + ((RealType)c01.next()).getRealFloat() + ((RealType)c10.next()).getRealFloat() + ((RealType)c11.next()).getRealFloat();
            ((RealType)out.next()).setReal((double)val / 4.0);
        }
    }
}

