/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.fused;

import bdv.util.source.fused.SubSetFusedRandomAccess;
import java.util.function.Supplier;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.FloatType;

public class SumAlphaFused3DRandomAccess<T extends NumericType<T>>
implements SubSetFusedRandomAccess<T> {
    long[] position = new long[3];
    final int nRandomAccesses;
    final RandomAccess<T>[] ra_origins;
    final RandomAccess<FloatType>[] ra_origins_alpha;
    final Supplier<T> pixelSupplier;
    protected final T pixel;
    final FloatType alpha;

    public SumAlphaFused3DRandomAccess(SumAlphaFused3DRandomAccess<T> randomAccess) {
        this.nRandomAccesses = randomAccess.nRandomAccesses;
        this.ra_origins = new RandomAccess[this.nRandomAccesses];
        this.ra_origins_alpha = new RandomAccess[this.nRandomAccesses];
        this.pixelSupplier = randomAccess.pixelSupplier;
        this.pixel = (NumericType)this.pixelSupplier.get();
        this.alpha = new FloatType();
        this.position[0] = randomAccess.getLongPosition(0);
        this.position[1] = randomAccess.getLongPosition(1);
        this.position[2] = randomAccess.getLongPosition(2);
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i] = randomAccess.ra_origins[i].copyRandomAccess();
            this.ra_origins_alpha[i] = randomAccess.ra_origins_alpha[i].copyRandomAccess();
            this.ra_origins[i].setPosition(this.position);
            this.ra_origins_alpha[i].setPosition(this.position);
        }
    }

    public SumAlphaFused3DRandomAccess(RandomAccess<T>[] ra_origins, RandomAccess<FloatType>[] ra_origins_alpha, Supplier<T> pixelSupplier) {
        this.nRandomAccesses = ra_origins.length;
        this.ra_origins = ra_origins;
        this.ra_origins_alpha = ra_origins_alpha;
        this.pixelSupplier = pixelSupplier;
        this.pixel = (NumericType)pixelSupplier.get();
        this.alpha = new FloatType();
    }

    public SumAlphaFused3DRandomAccess(SumAlphaFused3DRandomAccess<T> randomAccess, boolean[] subset) {
        int nRandomAccesses = 0;
        for (int i = 0; i < subset.length; ++i) {
            if (!subset[i]) continue;
            ++nRandomAccesses;
        }
        this.nRandomAccesses = nRandomAccesses;
        this.ra_origins = new RandomAccess[nRandomAccesses];
        this.ra_origins_alpha = new RandomAccess[nRandomAccesses];
        this.pixelSupplier = randomAccess.pixelSupplier;
        this.pixel = (NumericType)this.pixelSupplier.get();
        this.alpha = new FloatType();
        this.position[0] = randomAccess.getLongPosition(0);
        this.position[1] = randomAccess.getLongPosition(1);
        this.position[2] = randomAccess.getLongPosition(2);
        int iSource = 0;
        for (int i = 0; i < subset.length; ++i) {
            if (!subset[i]) continue;
            this.ra_origins[iSource] = randomAccess.ra_origins[i].copyRandomAccess();
            this.ra_origins_alpha[iSource] = randomAccess.ra_origins_alpha[i].copyRandomAccess();
            this.ra_origins[iSource].setPosition(this.position);
            this.ra_origins_alpha[iSource].setPosition(this.position);
            ++iSource;
        }
    }

    public RandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public long getLongPosition(int d) {
        return this.position[d];
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].fwd(d);
            this.ra_origins_alpha[i].fwd(d);
        }
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].bck(d);
            this.ra_origins_alpha[i].bck(d);
        }
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].move(distance, d);
            this.ra_origins_alpha[i].move(distance, d);
        }
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].move(distance, d);
            this.ra_origins_alpha[i].move(distance, d);
        }
    }

    public void move(Localizable distance) {
        this.position[0] = this.position[0] + distance.getLongPosition(0);
        this.position[1] = this.position[1] + distance.getLongPosition(1);
        this.position[2] = this.position[2] + distance.getLongPosition(2);
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].move(distance);
            this.ra_origins_alpha[i].move(distance);
        }
    }

    public void move(int[] distance) {
        this.position[0] = this.position[0] + (long)distance[0];
        this.position[1] = this.position[1] + (long)distance[1];
        this.position[2] = this.position[2] + (long)distance[2];
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].move(distance);
            this.ra_origins_alpha[i].move(distance);
        }
    }

    public void move(long[] distance) {
        this.position[0] = this.position[0] + distance[0];
        this.position[1] = this.position[1] + distance[1];
        this.position[2] = this.position[2] + distance[2];
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].move(distance);
            this.ra_origins_alpha[i].move(distance);
        }
    }

    public void setPosition(Localizable position) {
        this.position[0] = position.getLongPosition(0);
        this.position[1] = position.getLongPosition(1);
        this.position[2] = position.getLongPosition(2);
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].setPosition(position);
            this.ra_origins_alpha[i].setPosition(position);
        }
    }

    public void setPosition(int[] position) {
        this.position[0] = position[0];
        this.position[1] = position[1];
        this.position[2] = position[2];
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].setPosition(position);
            this.ra_origins_alpha[i].setPosition(position);
        }
    }

    public void setPosition(long[] position) {
        this.position[0] = position[0];
        this.position[1] = position[1];
        this.position[2] = position[2];
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].setPosition(position);
            this.ra_origins_alpha[i].setPosition(position);
        }
    }

    public void setPosition(int position, int d) {
        this.position[d] = position;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].setPosition(position, d);
            this.ra_origins_alpha[i].setPosition(position, d);
        }
    }

    public void setPosition(long position, int d) {
        this.position[d] = position;
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            this.ra_origins[i].setPosition(position, d);
            this.ra_origins_alpha[i].setPosition(position, d);
        }
    }

    public int numDimensions() {
        return 3;
    }

    public T get() {
        this.pixel.setZero();
        for (int i = 0; i < this.nRandomAccesses; ++i) {
            float alpha_v = ((FloatType)this.ra_origins_alpha[i].get()).get();
            if (alpha_v == 0.0f) continue;
            this.pixel.add(this.ra_origins[i].get());
        }
        return this.pixel;
    }

    public SumAlphaFused3DRandomAccess<T> copy() {
        return new SumAlphaFused3DRandomAccess<T>(this);
    }

    @Override
    public RandomAccess<T> copy(boolean[] subset) {
        return new SumAlphaFused3DRandomAccess<T>(this, subset);
    }
}

